/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.thread.Queue;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SizedQueue"}, parent="Queue")
public class SizedQueue
extends Queue {
    private int capacity = 1;

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        SizedQueue result2 = new SizedQueue(context.runtime, (RubyClass)recv2);
        result2.callInit(args2, block);
        return result2;
    }

    public SizedQueue(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public static void setup(Ruby runtime) {
        RubyClass cSizedQueue = runtime.defineClass("SizedQueue", runtime.getClass("Queue"), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new SizedQueue(runtime, klass);
            }
        });
        cSizedQueue.setReifiedClass(SizedQueue.class);
        cSizedQueue.defineAnnotatedMethods(SizedQueue.class);
    }

    @JRubyMethod
    public synchronized IRubyObject clear(ThreadContext context) {
        super.clear(context);
        this.notifyAll();
        return context.runtime.getNil();
    }

    @JRubyMethod
    public synchronized RubyNumeric max(ThreadContext context) {
        return RubyNumeric.int2fix(context.runtime, this.capacity);
    }

    @JRubyMethod(name={"max=", "initialize"})
    public synchronized IRubyObject max_set(ThreadContext context, IRubyObject arg2) {
        int new_capacity = RubyNumeric.fix2int(arg2);
        if (new_capacity <= 0) {
            context.runtime.newArgumentError("queue size must be positive");
        }
        int difference = new_capacity > this.capacity ? new_capacity - this.capacity : 0;
        this.capacity = new_capacity;
        if (difference > 0) {
            this.notifyAll();
        }
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"pop", "deq", "shift"})
    public synchronized IRubyObject pop(ThreadContext context) {
        IRubyObject result2 = super.pop(context);
        this.notifyAll();
        return result2;
    }

    @JRubyMethod(name={"pop", "deq", "shift"})
    public synchronized IRubyObject pop(ThreadContext context, IRubyObject arg0) {
        IRubyObject result2 = super.pop(context, arg0);
        this.notifyAll();
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"push", "<<"})
    public synchronized IRubyObject push(ThreadContext context, IRubyObject value2) {
        this.checkShutdown(context);
        if (this.java_length() >= (long)this.capacity) {
            ++this.numWaiting;
            try {
                while (this.java_length() >= (long)this.capacity) {
                    try {
                        context.getThread().wait_timeout(this, null);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.checkShutdown(context);
                }
                Object var5_4 = null;
                --this.numWaiting;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                --this.numWaiting;
                throw throwable;
            }
        }
        super.push(context, value2);
        this.notifyAll();
        return context.runtime.getNil();
    }
}

