/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class BN
extends RubyObject {
    private static final long serialVersionUID = -5660938062191525498L;
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final int DEFAULT_CERTAINTY = 100;
    private static Random _random;
    private static SecureRandom _secureRandom;
    private static ObjectAllocator BN_ALLOCATOR;
    private volatile BigInteger value;

    public static BN newBN(Ruby runtime, BigInteger value2) {
        return new BN(runtime, value2 != null ? value2 : BigInteger.ZERO);
    }

    public static void createBN(Ruby runtime, RubyModule ossl) {
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        ossl.defineClassUnder("BNError", openSSLError, openSSLError.getAllocator());
        RubyClass bn = ossl.defineClassUnder("BN", runtime.getObject(), BN_ALLOCATOR);
        bn.defineAnnotatedMethods(BN.class);
    }

    private BN(Ruby runtime, RubyClass clazz, BigInteger value2) {
        super(runtime, clazz);
        this.value = value2;
    }

    private BN(Ruby runtime, BigInteger value2) {
        super(runtime, runtime.getModule("OpenSSL").getClass("BN"));
        this.value = value2;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public IRubyObject doClone() {
        return BN.newBN(this.getRuntime(), this.value);
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        super.initialize_copy(original);
        if (this != original) {
            this.value = ((BN)original).value;
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1)
    public synchronized IRubyObject bn_initialize(IRubyObject[] args2) {
        Ruby runtime = this.getRuntime();
        if (this.value != BigInteger.ZERO) {
            throw BN.newBNError(runtime, "illegal initialization");
        }
        int argc = Arity.checkArgumentCount(runtime, args2, 1, 2);
        int base = argc == 2 ? RubyNumeric.num2int(args2[1]) : 10;
        RubyString str = RubyString.stringValue(args2[0]);
        switch (base) {
            case 2: {
                this.value = new BigInteger(1, str.getBytes());
                break;
            }
            case 10: 
            case 16: {
                try {
                    this.value = new BigInteger(str.toString(), base);
                    break;
                }
                catch (NumberFormatException e) {
                    throw runtime.newArgumentError("value " + str + " is not legal for radix " + base);
                }
            }
            case 0: {
                throw runtime.newArgumentError("unsupported radix: " + base);
            }
            default: {
                throw runtime.newArgumentError("illegal radix: " + base);
            }
        }
        return this;
    }

    @JRubyMethod(name={"copy"})
    public synchronized IRubyObject bn_copy(IRubyObject other) {
        if (this != other) {
            this.value = BN.getBigInteger(other);
        }
        return this;
    }

    @JRubyMethod(name={"to_s"}, rest=true)
    public IRubyObject bn_to_s(IRubyObject[] args2) {
        Ruby runtime = this.getRuntime();
        int argc = Arity.checkArgumentCount(runtime, args2, 0, 1);
        int base = argc == 1 ? RubyNumeric.num2int(args2[0]) : 10;
        switch (base) {
            case 2: {
                byte[] bytes2 = this.value.abs().toByteArray();
                if (bytes2[0] == 0) {
                    return runtime.newString(new ByteList(bytes2, 1, bytes2.length - 1));
                }
                return runtime.newString(new ByteList(bytes2, false));
            }
            case 10: 
            case 16: {
                return runtime.newString(this.value.toString(base).toUpperCase());
            }
            case 0: {
                throw runtime.newArgumentError("unsupported radix: " + base);
            }
        }
        throw runtime.newArgumentError("illegal radix: " + base);
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject bn_to_i() {
        Ruby runtime = this.getRuntime();
        return RubyNumeric.str2inum(runtime, runtime.newString(this.value.toString()), 10, true);
    }

    @JRubyMethod(name={"to_bn"})
    public IRubyObject bn_to_bn() {
        return this;
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject bn_coerce(IRubyObject other) {
        RubyObject self;
        Ruby runtime = this.getRuntime();
        switch (other.getMetaClass().index) {
            case 4: {
                self = runtime.newString(this.value.toString());
                break;
            }
            case 1: 
            case 2: {
                self = RubyNumeric.str2inum(runtime, runtime.newString(this.value.toString()), 10, true);
                break;
            }
            default: {
                if (other instanceof BN) {
                    self = this;
                    break;
                }
                throw runtime.newTypeError("Don't know how to coerce");
            }
        }
        return runtime.newArray(other, (IRubyObject)self);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject bn_is_zero() {
        return this.getRuntime().newBoolean(this.value.equals(BigInteger.ZERO));
    }

    @JRubyMethod(name={"one?"})
    public IRubyObject bn_is_one() {
        return this.getRuntime().newBoolean(this.value.equals(BigInteger.ONE));
    }

    @JRubyMethod(name={"odd?"})
    public IRubyObject bn_is_odd() {
        return this.getRuntime().newBoolean(this.value.testBit(0));
    }

    @JRubyMethod(name={"cmp", "<=>"})
    public IRubyObject bn_cmp(IRubyObject other) {
        return this.getRuntime().newFixnum(this.value.compareTo(BN.getBigInteger(other)));
    }

    @JRubyMethod(name={"ucmp"})
    public IRubyObject bn_ucmp(IRubyObject other) {
        return this.getRuntime().newFixnum(this.value.abs().compareTo(BN.getBigInteger(other).abs()));
    }

    @JRubyMethod(name={"eql?", "==", "==="})
    public IRubyObject bn_eql(IRubyObject other) {
        return this.getRuntime().newBoolean(this.value.equals(BN.getBigInteger(other)));
    }

    @JRubyMethod(name={"sqr"})
    public IRubyObject bn_sqr() {
        return BN.newBN(this.getRuntime(), this.value.pow(2));
    }

    @JRubyMethod(name={"~"})
    public IRubyObject bn_not() {
        return BN.newBN(this.getRuntime(), this.value.not());
    }

    @JRubyMethod(name={"+"})
    public IRubyObject bn_add(IRubyObject other) {
        return BN.newBN(this.getRuntime(), this.value.add(BN.getBigInteger(other)));
    }

    @JRubyMethod(name={"-"})
    public IRubyObject bn_sub(IRubyObject other) {
        return BN.newBN(this.getRuntime(), this.value.subtract(BN.getBigInteger(other)));
    }

    @JRubyMethod(name={"*"})
    public IRubyObject bn_mul(IRubyObject other) {
        return BN.newBN(this.getRuntime(), this.value.multiply(BN.getBigInteger(other)));
    }

    @JRubyMethod(name={"%"})
    public IRubyObject bn_mod(IRubyObject other) {
        try {
            return BN.newBN(this.getRuntime(), this.value.mod(BN.getBigInteger(other)));
        }
        catch (ArithmeticException e) {
            throw this.getRuntime().newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"/"})
    public IRubyObject bn_div(IRubyObject other) {
        Ruby runtime = this.getRuntime();
        try {
            BigInteger[] result2 = this.value.divideAndRemainder(BN.getBigInteger(other));
            return runtime.newArray((IRubyObject)BN.newBN(runtime, result2[0]), (IRubyObject)BN.newBN(runtime, result2[1]));
        }
        catch (ArithmeticException e) {
            throw runtime.newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"&"})
    public IRubyObject bn_and(IRubyObject other) {
        return BN.newBN(this.getRuntime(), this.value.and(BN.getBigInteger(other)));
    }

    @JRubyMethod(name={"|"})
    public IRubyObject bn_or(IRubyObject other) {
        return BN.newBN(this.getRuntime(), this.value.or(BN.getBigInteger(other)));
    }

    @JRubyMethod(name={"^"})
    public IRubyObject bn_xor(IRubyObject other) {
        return BN.newBN(this.getRuntime(), this.value.xor(BN.getBigInteger(other)));
    }

    @JRubyMethod(name={"**"})
    public IRubyObject bn_exp(IRubyObject other) {
        int exp2;
        switch (other.getMetaClass().index) {
            case 1: {
                long val = ((RubyFixnum)other).getLongValue();
                if (val >= 0L && val <= Integer.MAX_VALUE) {
                    exp2 = (int)val;
                    break;
                }
            }
            case 2: {
                throw BN.newBNError(this.getRuntime(), "invalid exponent");
            }
            default: {
                if (!(other instanceof BN)) {
                    throw this.getRuntime().newTypeError("Cannot convert into OpenSSL::BN");
                }
                BigInteger val = ((BN)other).value;
                if (val.compareTo(BigInteger.ZERO) < 0 || val.compareTo(MAX_INT) > 0) {
                    throw BN.newBNError(this.getRuntime(), "invalid exponent");
                }
                exp2 = val.intValue();
                break;
            }
        }
        try {
            return BN.newBN(this.getRuntime(), this.value.pow(exp2));
        }
        catch (ArithmeticException e) {
            throw BN.newBNError(this.getRuntime(), "invalid exponent");
        }
    }

    @JRubyMethod(name={"gcd"})
    public IRubyObject bn_gcd(IRubyObject other) {
        return BN.newBN(this.getRuntime(), this.value.gcd(BN.getBigInteger(other)));
    }

    @JRubyMethod(name={"mod_sqr"})
    public IRubyObject bn_mod_sqr(IRubyObject other) {
        try {
            return BN.newBN(this.getRuntime(), this.value.modPow(TWO, BN.getBigInteger(other)));
        }
        catch (ArithmeticException e) {
            throw this.getRuntime().newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_inverse"})
    public IRubyObject bn_mod_inverse(IRubyObject other) {
        try {
            return BN.newBN(this.getRuntime(), this.value.modInverse(BN.getBigInteger(other)));
        }
        catch (ArithmeticException e) {
            throw this.getRuntime().newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_add"})
    public IRubyObject bn_mod_add(IRubyObject other, IRubyObject mod) {
        try {
            return BN.newBN(this.getRuntime(), this.value.add(BN.getBigInteger(other)).mod(BN.getBigInteger(mod)));
        }
        catch (ArithmeticException e) {
            throw this.getRuntime().newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_sub"})
    public IRubyObject bn_mod_sub(IRubyObject other, IRubyObject mod) {
        try {
            return BN.newBN(this.getRuntime(), this.value.subtract(BN.getBigInteger(other)).mod(BN.getBigInteger(mod)));
        }
        catch (ArithmeticException e) {
            throw this.getRuntime().newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_mul"})
    public IRubyObject bn_mod_mul(IRubyObject other, IRubyObject mod) {
        try {
            return BN.newBN(this.getRuntime(), this.value.multiply(BN.getBigInteger(other)).mod(BN.getBigInteger(mod)));
        }
        catch (ArithmeticException e) {
            throw this.getRuntime().newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_exp"})
    public IRubyObject bn_mod_exp(IRubyObject other, IRubyObject mod) {
        try {
            return BN.newBN(this.getRuntime(), this.value.modPow(BN.getBigInteger(other), BN.getBigInteger(mod)));
        }
        catch (ArithmeticException e) {
            throw this.getRuntime().newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"set_bit!"})
    public synchronized IRubyObject bn_set_bit(IRubyObject n) {
        int pos2 = RubyNumeric.num2int(n);
        BigInteger oldValue = this.value;
        try {
            this.value = oldValue.signum() >= 0 ? oldValue.setBit(pos2) : oldValue.abs().setBit(pos2).negate();
        }
        catch (ArithmeticException e) {
            throw BN.newBNError(this.getRuntime(), "invalid pos");
        }
        return this;
    }

    @JRubyMethod(name={"clear_bit!"})
    public synchronized IRubyObject bn_clear_bit(IRubyObject n) {
        int pos2 = RubyNumeric.num2int(n);
        BigInteger oldValue = this.value;
        try {
            this.value = oldValue.signum() >= 0 ? oldValue.clearBit(pos2) : oldValue.abs().clearBit(pos2).negate();
        }
        catch (ArithmeticException e) {
            throw BN.newBNError(this.getRuntime(), "invalid pos");
        }
        return this;
    }

    @JRubyMethod(name={"mask_bits!"})
    public synchronized IRubyObject bn_mask_bits(IRubyObject n) {
        int pos2 = RubyNumeric.num2int(n);
        if (pos2 < 0) {
            throw BN.newBNError(this.getRuntime(), "invalid pos");
        }
        BigInteger oldValue = this.value;
        if (oldValue.signum() >= 0) {
            if (oldValue.bitLength() < pos2) {
                throw BN.newBNError(this.getRuntime(), "invalid pos");
            }
            this.value = oldValue.mod(TWO.pow(pos2));
        } else {
            BigInteger absValue = oldValue.abs();
            if (absValue.bitLength() < pos2) {
                throw BN.newBNError(this.getRuntime(), "invalid pos");
            }
            this.value = absValue.mod(TWO.pow(pos2)).negate();
        }
        return this;
    }

    @JRubyMethod(name={"bit_set?"})
    public IRubyObject bn_is_bit_set(IRubyObject n) {
        int pos2 = RubyNumeric.num2int(n);
        BigInteger val = this.value;
        try {
            if (val.signum() >= 0) {
                return this.getRuntime().newBoolean(val.testBit(pos2));
            }
            return this.getRuntime().newBoolean(val.abs().testBit(pos2));
        }
        catch (ArithmeticException e) {
            throw BN.newBNError(this.getRuntime(), "invalid pos");
        }
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject bn_lshift(IRubyObject n) {
        int nbits = RubyNumeric.num2int(n);
        BigInteger val = this.value;
        if (val.signum() >= 0) {
            return BN.newBN(this.getRuntime(), val.shiftLeft(nbits));
        }
        return BN.newBN(this.getRuntime(), val.abs().shiftLeft(nbits).negate());
    }

    @JRubyMethod(name={">>"})
    public IRubyObject bn_rshift(IRubyObject n) {
        int nbits = RubyNumeric.num2int(n);
        BigInteger val = this.value;
        if (val.signum() >= 0) {
            return BN.newBN(this.getRuntime(), val.shiftRight(nbits));
        }
        return BN.newBN(this.getRuntime(), val.abs().shiftRight(nbits).negate());
    }

    @JRubyMethod(name={"num_bits"})
    public IRubyObject bn_num_bits() {
        return this.getRuntime().newFixnum(this.value.abs().bitLength());
    }

    @JRubyMethod(name={"num_bytes"})
    public IRubyObject bn_num_bytes() {
        return this.getRuntime().newFixnum((this.value.abs().bitLength() + 7) / 8);
    }

    @JRubyMethod(name={"num_bits_set"})
    public IRubyObject bn_num_bits_set() {
        return this.getRuntime().newFixnum(this.value.abs().bitCount());
    }

    @JRubyMethod(name={"prime?"}, rest=true)
    public IRubyObject bn_is_prime(IRubyObject[] args2) {
        Ruby runtime = this.getRuntime();
        int argc = Arity.checkArgumentCount(runtime, args2, 0, 1);
        int certainty = argc == 0 ? 100 : RubyNumeric.fix2int(args2[0]);
        return runtime.newBoolean(this.value.isProbablePrime(certainty));
    }

    @JRubyMethod(name={"prime_fasttest?"}, rest=true)
    public IRubyObject bn_is_prime_fasttest(IRubyObject[] args2) {
        Ruby runtime = this.getRuntime();
        int argc = Arity.checkArgumentCount(runtime, args2, 0, 2);
        int certainty = argc == 0 ? 100 : RubyNumeric.fix2int(args2[0]);
        return runtime.newBoolean(this.value.isProbablePrime(certainty));
    }

    @JRubyMethod(name={"generate_prime"}, meta=true, rest=true)
    public static IRubyObject bn_generate_prime(IRubyObject recv2, IRubyObject[] args2) {
        BigInteger rem;
        Ruby runtime = recv2.getRuntime();
        int argc = Arity.checkArgumentCount(runtime, args2, 1, 4);
        int bits = RubyNumeric.num2int(args2[0]);
        boolean safe = argc > 1 ? args2[1] != runtime.getFalse() : true;
        BigInteger add3 = argc > 2 ? BN.getBigInteger(args2[2]) : null;
        BigInteger bigInteger = rem = argc > 3 ? BN.getBigInteger(args2[3]) : null;
        if (bits < 3) {
            if (safe) {
                throw runtime.newArgumentError("bits < 3");
            }
            if (bits < 2) {
                throw runtime.newArgumentError("bits < 2");
            }
        }
        return BN.newBN(runtime, BN.generatePrime(bits, safe, add3, rem));
    }

    public static BigInteger generatePrime(int bits, boolean safe, BigInteger add3, BigInteger rem) {
        BigInteger p2;
        if (add3 != null && rem == null) {
            rem = BigInteger.ONE;
        }
        int qbits = bits - 1;
        SecureRandom secureRandom = BN.getSecureRandom();
        do {
            if (safe) {
                BigInteger q;
                while (!(p2 = (q = new BigInteger(qbits, 2, secureRandom)).shiftLeft(1).setBit(0)).isProbablePrime(100) || !q.isProbablePrime(100)) {
                }
                continue;
            }
            p2 = BigInteger.probablePrime(bits, secureRandom);
        } while (add3 != null && !p2.mod(add3).equals(rem));
        return p2;
    }

    public static BigInteger generatePrime(int bits, boolean safe) {
        return BN.generatePrime(bits, safe, null, null);
    }

    @JRubyMethod(name={"rand"}, meta=true, rest=true)
    public static IRubyObject bn_rand(IRubyObject recv2, IRubyObject[] args2) {
        return BN.getRandomBN(recv2.getRuntime(), args2, BN.getSecureRandom());
    }

    @JRubyMethod(name={"pseudo_rand"}, meta=true, rest=true)
    public static IRubyObject bn_pseudo_rand(IRubyObject recv2, IRubyObject[] args2) {
        return BN.getRandomBN(recv2.getRuntime(), args2, BN.getRandom());
    }

    public static BN getRandomBN(Ruby runtime, IRubyObject[] args2, Random random) {
        BigInteger value2;
        boolean bottom;
        int top;
        int argc = Arity.checkArgumentCount(runtime, args2, 1, 3);
        int bits = RubyNumeric.num2int(args2[0]);
        if (argc > 1) {
            top = RubyNumeric.fix2int(args2[1]);
            bottom = argc == 3 ? args2[2].isTrue() : false;
        } else {
            top = 0;
            bottom = false;
        }
        try {
            value2 = BN.getRandomBI(bits, top, bottom, random);
        }
        catch (IllegalArgumentException e) {
            throw runtime.newArgumentError(e.getMessage());
        }
        return BN.newBN(runtime, value2);
    }

    public static BigInteger getRandomBI(int bits, int top, boolean bottom, Random random) {
        if (bits <= 0) {
            if (bits == 0) {
                return BigInteger.ZERO;
            }
            throw new IllegalArgumentException("Illegal bit length");
        }
        if (top < -1 || top > 1) {
            throw new IllegalArgumentException("Illegal top value");
        }
        int bytes2 = (bits + 7) / 8;
        int bit = (bits - 1) % 8;
        int mask = 255 << bit + 1;
        byte[] buf = new byte[bytes2];
        random.nextBytes(buf);
        if (top >= 0) {
            if (top == 0) {
                buf[0] = (byte)(buf[0] | 1 << bit);
            } else if (bit == 0) {
                buf[0] = 1;
                buf[1] = (byte)(buf[1] | 0x80);
            } else {
                buf[0] = (byte)(buf[0] | 3 << bit - 1);
            }
        }
        buf[0] = (byte)(buf[0] & ~mask);
        if (bottom) {
            int n = bytes2 - 1;
            buf[n] = (byte)(buf[n] | 1);
        }
        return new BigInteger(1, buf);
    }

    @JRubyMethod(name={"rand_range"}, meta=true)
    public static IRubyObject bn_rand_range(IRubyObject recv2, IRubyObject arg2) {
        return BN.getRandomBNInRange(recv2.getRuntime(), BN.getBigInteger(arg2), BN.getSecureRandom());
    }

    @JRubyMethod(name={"pseudo_rand_range"}, meta=true)
    public static IRubyObject bn_pseudo_rand_range(IRubyObject recv2, IRubyObject arg2) {
        return BN.getRandomBNInRange(recv2.getRuntime(), BN.getBigInteger(arg2), BN.getRandom());
    }

    private static BN getRandomBNInRange(Ruby runtime, BigInteger limit2, Random random) {
        BigInteger value2;
        try {
            value2 = BN.getRandomBIInRange(limit2, random);
        }
        catch (IllegalArgumentException e) {
            throw BN.newBNError(runtime, "illegal range");
        }
        return BN.newBN(runtime, value2);
    }

    public static BigInteger getRandomBIInRange(BigInteger limit2, Random random) {
        BigInteger value2;
        if (limit2.signum() < 0) {
            throw new IllegalArgumentException("illegal range");
        }
        int bits = limit2.bitLength();
        while ((value2 = new BigInteger(bits, random)).compareTo(limit2) >= 0) {
        }
        return value2;
    }

    private static Random getRandom() {
        Random rand2 = _random;
        if (rand2 != null) {
            return rand2;
        }
        _random = new Random();
        return _random;
    }

    private static SecureRandom getSecureRandom() {
        SecureRandom rand2 = _secureRandom;
        if (rand2 != null) {
            return rand2;
        }
        _secureRandom = new SecureRandom();
        return _secureRandom;
    }

    public static RaiseException newBNError(Ruby runtime, String message2) {
        return new RaiseException(runtime, runtime.getModule("OpenSSL").getClass("BNError"), message2, true);
    }

    public static BigInteger getBigInteger(IRubyObject arg2) {
        if (arg2.isNil()) {
            return null;
        }
        switch (arg2.getMetaClass().index) {
            case 1: 
            case 2: {
                return new BigInteger(arg2.toString());
            }
        }
        if (arg2 instanceof BN) {
            return ((BN)arg2).value;
        }
        throw arg2.getRuntime().newTypeError("Cannot convert into OpenSSL::BN");
    }

    static {
        BN_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new BN(runtime, klass, BigInteger.ZERO);
            }
        };
    }
}

