/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jruby.RubySymbol;
import org.jruby.ext.ffi.FFI;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class TypeSizeMapper {
    private final FFI ffi;
    private volatile Map<RubySymbol, Type> symbolTypeCache = Collections.emptyMap();

    TypeSizeMapper(FFI ffi2) {
        this.ffi = ffi2;
    }

    public final int sizeof(ThreadContext context, RubySymbol name2) {
        Object obj = name2.getFFIHandle();
        if (obj instanceof Type) {
            return ((Type)obj).size;
        }
        Type type2 = this.symbolTypeCache.get(name2);
        if (type2 != null) {
            return type2.size;
        }
        return this.lookupAndCacheSize(context, name2);
    }

    private synchronized int lookupAndCacheSize(ThreadContext context, RubySymbol name2) {
        Type type2 = this.lookupType(context, name2);
        IdentityHashMap<RubySymbol, Type> map = new IdentityHashMap<RubySymbol, Type>(this.symbolTypeCache);
        map.put(name2, type2);
        this.symbolTypeCache = map;
        name2.setFFIHandle(type2);
        return type2.size;
    }

    private Type lookupType(ThreadContext context, IRubyObject name2) {
        IRubyObject type2 = this.ffi.typedefs.fastARef(name2);
        if (type2 instanceof Type) {
            return (Type)type2;
        }
        type2 = this.ffi.ffiModule.callMethod(context, "find_type", name2);
        if (type2 instanceof Type) {
            return (Type)type2;
        }
        throw context.runtime.newTypeError("cannot resolve type " + name2);
    }

    public static final int getTypeSize(ThreadContext context, RubySymbol sizeArg) {
        return context.runtime.getFFI().getSizeMapper().sizeof(context, sizeArg);
    }
}

