/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ASTInterpreter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_METHOD(Ruby runtime, ThreadContext context, String file2, int line, RubyModule implClass, Node node, String name2, IRubyObject self, Block block, boolean isTraceable) {
        IRubyObject iRubyObject;
        block8: {
            block7: {
                try {
                    ThreadContext.pushBacktrace(context, name2, file2, line);
                    if (isTraceable) {
                        ASTInterpreter.methodPreTrace(runtime, context, name2, implClass);
                    }
                    iRubyObject = node.interpret(runtime, context, self, block);
                    Object var12_11 = null;
                    if (!isTraceable) break block7;
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var12_12 = null;
                        if (isTraceable) {
                            try {
                                ASTInterpreter.methodPostTrace(runtime, context, name2, implClass);
                                Object var14_15 = null;
                            }
                            catch (Throwable throwable2) {
                                Object var14_16 = null;
                                ThreadContext.popBacktrace(context);
                                throw throwable2;
                            }
                            ThreadContext.popBacktrace(context);
                            {
                                break block9;
                            }
                        }
                        ThreadContext.popBacktrace(context);
                    }
                    throw throwable;
                }
                try {
                    ASTInterpreter.methodPostTrace(runtime, context, name2, implClass);
                    Object var14_13 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    ThreadContext.popBacktrace(context);
                    throw throwable;
                }
                ThreadContext.popBacktrace(context);
                {
                    break block8;
                }
            }
            ThreadContext.popBacktrace(context);
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(Ruby runtime, ThreadContext context, Node node, String name2, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, name2, node.getPosition());
            iRubyObject = node.interpret(runtime, context, self, block);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(Ruby runtime, ThreadContext context, String file2, int line, Node node, String name2, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, name2, file2, line);
            iRubyObject = node.interpret(runtime, context, self, block);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_CLASS(Ruby runtime, ThreadContext context, Node node, String name2, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, name2, node.getPosition());
            iRubyObject = node.interpret(runtime, context, self, block);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(Ruby runtime, ThreadContext context, String file2, int line, Node node, String name2, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, name2, file2, line);
            iRubyObject = node.interpret(runtime, context, self, block);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_ROOT(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, "(root)", node.getPosition());
            iRubyObject = node.interpret(runtime, context, self, block);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    private static void methodPreTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.CALL, name2, implClass);
        }
    }

    private static void methodPostTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.RETURN, name2, implClass);
        }
    }

    @Deprecated
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject src, Binding binding2) {
        return ASTInterpreter.evalWithBinding(context, binding2.getSelf(), src, binding2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject self, IRubyObject src, Binding binding2) {
        IRubyObject iRubyObject;
        Frame lastFrame;
        block9: {
            Ruby runtime = src.getRuntime();
            DynamicScope evalScope = runtime.is1_9() ? binding2.getEvalScope(runtime) : binding2.getDynamicScope().getEvalScope(runtime);
            evalScope.getStaticScope().determineModule();
            lastFrame = context.preEvalWithBinding(binding2);
            try {
                IRubyObject iRubyObject2;
                block8: {
                    try {
                        RubyString source2 = src.convertToString();
                        Node node = runtime.parseEval(source2.getByteList(), binding2.getFile(), evalScope, binding2.getLine());
                        Block block = binding2.getFrame().getBlock();
                        if (runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.OFFIR) {
                            iRubyObject2 = Interpreter.interpretBindingEval(runtime, binding2.getFile(), binding2.getLine(), binding2.getMethod(), node, self, block);
                            Object var12_15 = null;
                            break block8;
                        }
                        iRubyObject = ASTInterpreter.INTERPRET_EVAL(runtime, context, binding2.getFile(), binding2.getLine(), node, binding2.getMethod(), self, block);
                        break block9;
                    }
                    catch (JumpException.BreakJump bj) {
                        throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
                    }
                    catch (JumpException.RedoJump rj) {
                        throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.REDO, (IRubyObject)rj.getValue(), "unexpected redo");
                    }
                    catch (StackOverflowError soe) {
                        throw runtime.newSystemStackError("stack level too deep", soe);
                    }
                }
                context.postEvalWithBinding(binding2, lastFrame);
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                context.postEvalWithBinding(binding2, lastFrame);
                throw throwable;
            }
        }
        Object var12_16 = null;
        context.postEvalWithBinding(binding2, lastFrame);
        return iRubyObject;
    }

    public static IRubyObject evalSimple(ThreadContext context, IRubyObject self, RubyString src, String file2, int lineNumber) {
        assert (file2 != null);
        Ruby runtime = src.getRuntime();
        RubyString source2 = src.convertToString();
        DynamicScope evalScope = context.getCurrentScope().getEvalScope(runtime);
        evalScope.getStaticScope().determineModule();
        try {
            Node node = runtime.parseEval(source2.getByteList(), file2, evalScope, lineNumber);
            if (runtime.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.OFFIR) {
                return Interpreter.interpretSimpleEval(runtime, file2, lineNumber, "(eval)", node, self);
            }
            return ASTInterpreter.INTERPRET_EVAL(runtime, context, file2, lineNumber, node, "(eval)", self, Block.NULL_BLOCK);
        }
        catch (JumpException.BreakJump bj) {
            throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
        }
        catch (StackOverflowError soe) {
            throw runtime.newSystemStackError("stack level too deep", soe);
        }
    }

    public static void callTraceFunction(Ruby runtime, ThreadContext context, RubyEvent event) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        runtime.callEventHooks(context, event, context.getFile(), context.getLine(), name2, type2);
    }

    public static IRubyObject pollAndReturn(ThreadContext context, IRubyObject result2) {
        context.pollThreadEvents();
        return result2;
    }

    public static IRubyObject multipleAsgnArrayNode(Ruby runtime, ThreadContext context, MultipleAsgnNode iVisited, ArrayNode node, IRubyObject self, Block aBlock) {
        IRubyObject[] array = new IRubyObject[node.size()];
        for (int i2 = 0; i2 < node.size(); ++i2) {
            array[i2] = node.get(i2).interpret(runtime, context, self, aBlock);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, iVisited, RubyArray.newArrayNoCopyLight(runtime, array), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalClassDefinitionBody(Ruby runtime, ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type2, IRubyObject self, Block block) {
        Object v2;
        block12: {
            Object v1;
            IRubyObject iRubyObject;
            context.preClassEval(scope, type2);
            try {
                if (runtime.hasEventHooks()) {
                    ASTInterpreter.callTraceFunction(runtime, context, RubyEvent.CLASS);
                }
                if (bodyNode != null) break block12;
                iRubyObject = runtime.getNil();
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var10_11 = null;
                try {
                    if (runtime.hasEventHooks()) {
                        ASTInterpreter.callTraceFunction(runtime, context, RubyEvent.END);
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var12_17 = v0;
                context.postClassEval();
                throw throwable;
            }
            try {
                if (runtime.hasEventHooks()) {
                    ASTInterpreter.callTraceFunction(runtime, context, RubyEvent.END);
                }
                v1 = null;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            Object var12_15 = v1;
            context.postClassEval();
            return iRubyObject;
        }
        String name2 = type2.getBaseName();
        if (name2 == null) {
            name2 = type2.isSingleton() ? "__singleton__" : (type2.isModule() ? "<anonymous module>" : "<anonymous class>");
        }
        IRubyObject iRubyObject = ASTInterpreter.INTERPRET_CLASS(runtime, context, bodyNode, name2, type2, block);
        Object var10_10 = null;
        try {
            if (runtime.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime, context, RubyEvent.END);
            }
            v2 = null;
        }
        catch (Throwable throwable) {
            v2 = null;
        }
        Object var12_16 = v2;
        context.postClassEval();
        return iRubyObject;
    }

    public static ByteList getArgumentDefinition(Ruby runtime, ThreadContext context, Node node, ByteList type2, IRubyObject self, Block block) {
        if (node == null) {
            return type2;
        }
        if (node instanceof ArrayNode) {
            ArrayNode list2 = (ArrayNode)node;
            int size2 = list2.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                if (list2.get(i2).definition(runtime, context, self, block) != null) continue;
                return null;
            }
        } else if (node.definition(runtime, context, self, block) == null) {
            return null;
        }
        return type2;
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            return ASTInterpreter.getIterNodeBlock(blockNode, context, self);
        }
        if (blockNode instanceof BlockPassNode) {
            return ASTInterpreter.getBlockPassBlock(blockNode, runtime, context, self, currentBlock);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    private static Block getBlockPassBlock(Node blockNode, Ruby runtime, ThreadContext context, IRubyObject self, Block currentBlock) {
        Node bodyNode = ((BlockPassNode)blockNode).getBodyNode();
        IRubyObject proc2 = bodyNode == null ? runtime.getNil() : bodyNode.interpret(runtime, context, self, currentBlock);
        return RuntimeHelpers.getBlockFromBlockPassBody(proc2, currentBlock);
    }

    private static Block getIterNodeBlock(Node blockNode, ThreadContext context, IRubyObject self) {
        IterNode iterNode = (IterNode)blockNode;
        StaticScope scope = iterNode.getScope();
        scope.determineModule();
        return InterpretedBlock.newInterpretedClosure(context, iterNode.getBlockBody(), self);
    }

    public static RubyModule getClassVariableBase(ThreadContext context, Ruby runtime) {
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        while (rubyClass.isSingleton() || rubyClass == runtime.getDummy()) {
            if (scope == null) {
                return null;
            }
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() != null) continue;
            runtime.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method");
        }
        return rubyClass;
    }

    public static IRubyObject[] setupArgs(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            String savedFile = context.getFile();
            int savedLine = context.getLine();
            int size2 = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size2];
            for (int i2 = 0; i2 < size2; ++i2) {
                argsArray[i2] = argsArrayNode.get(i2).interpret(runtime, context, self, aBlock);
            }
            context.setFileAndLine(savedFile, savedLine);
            return argsArray;
        }
        return ArgsUtil.convertToJavaArray(node.interpret(runtime, context, self, aBlock));
    }
}

