/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ASTInspector;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyRuntimeAdapter;
import org.jruby.embed.ParseFailedException;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.EmbedEvalUnitImpl;
import org.jruby.embed.io.ReaderInputStream;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedRubyRuntimeAdapterImpl
implements EmbedRubyRuntimeAdapter {
    private RubyRuntimeAdapter adapter = JavaEmbedUtils.newRuntimeAdapter();
    private ScriptingContainer container;

    public EmbedRubyRuntimeAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    public EmbedEvalUnit parse(String script, int ... lines2) {
        if (script == null) {
            return null;
        }
        boolean unicode_escape = false;
        Object obj = this.container.getAttribute((Object)AttributeName.UNICODE_ESCAPE);
        if (obj != null && obj instanceof Boolean) {
            unicode_escape = (Boolean)obj;
        }
        if (unicode_escape) {
            ReaderInputStream istream = new ReaderInputStream(new StringReader(script));
            return this.runParser(istream, null, lines2);
        }
        return this.runParser(script, null, lines2);
    }

    public EmbedEvalUnit parse(Reader reader, String filename2, int ... lines2) {
        if (reader != null) {
            ReaderInputStream istream = new ReaderInputStream(reader);
            return this.runParser(istream, filename2, lines2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EmbedEvalUnit parse(PathType type2, String filename2, int ... lines2) {
        Object basedir;
        if (filename2 == null) {
            return null;
        }
        if (type2 == null) {
            type2 = PathType.ABSOLUTE;
        }
        InputStream istream = null;
        try {
            try {
                switch (type2) {
                    case ABSOLUTE: {
                        istream = new FileInputStream(filename2);
                        break;
                    }
                    case RELATIVE: {
                        basedir = (String)this.container.getAttribute((Object)AttributeName.BASE_DIR);
                        if (basedir == null) {
                            basedir = SystemPropertyCatcher.getBaseDir();
                        }
                        String absolutePath = (String)basedir + File.separator + filename2;
                        istream = new FileInputStream(absolutePath);
                        break;
                    }
                    case CLASSPATH: {
                        istream = this.container.getProvider().getRuntime().getJRubyClassLoader().getResourceAsStream(filename2);
                        break;
                    }
                }
                basedir = this.parse(istream, filename2, lines2);
                Object var8_8 = null;
                if (istream == null) return basedir;
            }
            catch (FileNotFoundException e) {
                throw new ParseFailedException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (istream == null) throw throwable;
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            // empty catch block
            return basedir;
        }
        istream.close();
        return basedir;
    }

    public EmbedEvalUnit parse(InputStream istream, String filename2, int ... lines2) {
        if (istream != null) {
            return this.runParser(istream, filename2, lines2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EmbedEvalUnit runParser(Object input, String filename2, int ... lines2) {
        EmbedEvalUnitImpl embedEvalUnitImpl;
        block19: {
            EmbedEvalUnitImpl embedEvalUnitImpl2;
            block18: {
                EmbedEvalUnitImpl embedEvalUnitImpl3;
                block17: {
                    if (input == null) {
                        return null;
                    }
                    if (filename2 == null || filename2.length() == 0) {
                        filename2 = this.container.getScriptFilename();
                    }
                    Ruby runtime = this.container.getProvider().getRuntime();
                    ValueAccessor d = new ValueAccessor(RubyString.newString(runtime, filename2));
                    runtime.getGlobalVariables().define("$PROGRAM_NAME", d);
                    runtime.getGlobalVariables().define("$0", d);
                    int line = 0;
                    if (lines2 != null && lines2.length > 0) {
                        line = lines2[0];
                    }
                    try {
                        try {
                            ManyVarsDynamicScope scope = null;
                            boolean sharing_variables = true;
                            Object obj = this.container.getAttribute((Object)AttributeName.SHARING_VARIABLES);
                            if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
                                sharing_variables = false;
                            }
                            if (sharing_variables) {
                                scope = EmbedRubyRuntimeAdapterImpl.getManyVarsDynamicScope(this.container, 0);
                            }
                            Node node = null;
                            node = input instanceof String ? runtime.parseEval((String)input, filename2, (DynamicScope)scope, line) : runtime.parseFile((InputStream)input, filename2, scope, line);
                            RubyInstanceConfig.CompileMode compileMode = runtime.getInstanceConfig().getCompileMode();
                            if (compileMode == RubyInstanceConfig.CompileMode.FORCE) {
                                ASTInspector inspector = new ASTInspector();
                                inspector.setFlag(32768);
                                Script script = runtime.tryCompile(node, inspector);
                                if (script != null) {
                                    embedEvalUnitImpl3 = new EmbedEvalUnitImpl(this.container, node, scope, script);
                                    Object var16_19 = null;
                                    break block17;
                                }
                                embedEvalUnitImpl2 = new EmbedEvalUnitImpl(this.container, node, scope);
                                break block18;
                            }
                            embedEvalUnitImpl = new EmbedEvalUnitImpl(this.container, node, scope);
                            break block19;
                        }
                        catch (RaiseException e) {
                            runtime.printError(e.getException());
                            throw new ParseFailedException(e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            throw new ParseFailedException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_22 = null;
                        try {
                            if (!(input instanceof InputStream)) throw throwable;
                            ((InputStream)input).close();
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new ParseFailedException(ex);
                        }
                    }
                }
                try {}
                catch (IOException ex) {
                    throw new ParseFailedException(ex);
                }
                if (!(input instanceof InputStream)) return embedEvalUnitImpl3;
                ((InputStream)input).close();
                return embedEvalUnitImpl3;
            }
            Object var16_20 = null;
            try {}
            catch (IOException ex) {
                throw new ParseFailedException(ex);
            }
            if (!(input instanceof InputStream)) return embedEvalUnitImpl2;
            ((InputStream)input).close();
            return embedEvalUnitImpl2;
        }
        Object var16_21 = null;
        try {}
        catch (IOException ex) {
            throw new ParseFailedException(ex);
        }
        if (!(input instanceof InputStream)) return embedEvalUnitImpl;
        ((InputStream)input).close();
        return embedEvalUnitImpl;
    }

    static ManyVarsDynamicScope getManyVarsDynamicScope(ScriptingContainer container, int depth) {
        StaticScopeFactory scopeFactory = container.getProvider().getRuntime().getStaticScopeFactory();
        StaticScope topStaticScope = scopeFactory.newLocalScope(null);
        topStaticScope.setModule(container.getProvider().getRuntime().getObject());
        ManyVarsDynamicScope currentScope = new ManyVarsDynamicScope(topStaticScope, null);
        String[] names4Injection = container.getVarMap().getLocalVarNames();
        StaticScope evalScope = names4Injection == null || names4Injection.length == 0 ? scopeFactory.newEvalScope(currentScope.getStaticScope()) : scopeFactory.newEvalScope(currentScope.getStaticScope(), names4Injection);
        ManyVarsDynamicScope scope = new ManyVarsDynamicScope(evalScope, currentScope);
        scope.getStaticScope().determineModule();
        return scope;
    }

    public IRubyObject eval(Ruby runtime, String script) {
        return this.adapter.eval(runtime, script);
    }

    public JavaEmbedUtils.EvalUnit parse(Ruby runtime, String script, String filename2, int lineNumber) {
        return this.adapter.parse(runtime, script, filename2, lineNumber);
    }

    public JavaEmbedUtils.EvalUnit parse(Ruby runtime, InputStream istream, String filename2, int lineNumber) {
        return this.adapter.parse(runtime, istream, filename2, lineNumber);
    }
}

