/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySystemExit;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EvalFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedEvalUnitImpl
implements EmbedEvalUnit {
    private ScriptingContainer container;
    private Node node;
    private ManyVarsDynamicScope scope;
    private Script script;

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope) {
        this(container, node, scope, null);
    }

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope, Script script) {
        this.container = container;
        this.node = node;
        this.scope = scope;
        this.script = script;
    }

    public Node getNode() {
        return this.node;
    }

    public ManyVarsDynamicScope getScope() {
        return this.scope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject run() {
        if (this.node == null && this.script == null) {
            return null;
        }
        Ruby runtime = this.container.getProvider().getRuntime();
        BiVariableMap vars = this.container.getVarMap();
        boolean sharing_variables = true;
        Object obj = this.container.getAttribute((Object)AttributeName.SHARING_VARIABLES);
        if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            sharing_variables = false;
        }
        ThreadContext threadContext = runtime.getCurrentContext();
        try {
            IRubyObject iRubyObject;
            block13: {
                try {
                    RubyInstanceConfig.CompileMode mode2;
                    if (sharing_variables) {
                        vars.inject(this.scope, 0, null);
                        threadContext.pushScope(this.scope);
                    }
                    IRubyObject ret = (mode2 = runtime.getInstanceConfig().getCompileMode()) == RubyInstanceConfig.CompileMode.FORCE ? runtime.runScriptBody(this.script) : runtime.runInterpreter(this.node);
                    if (sharing_variables) {
                        vars.retrieve(ret);
                    }
                    iRubyObject = ret;
                    Object var10_13 = null;
                    if (!sharing_variables) break block13;
                }
                catch (RaiseException e) {
                    if (!(e.getException() instanceof RubySystemExit)) {
                        runtime.printError(e.getException());
                        throw new EvalFailedException(e.getMessage(), e);
                    }
                    IRubyObject iRubyObject2 = ((RubySystemExit)e.getException()).status();
                    Object var10_14 = null;
                    if (sharing_variables) {
                        threadContext.popScope();
                    }
                    vars.terminate();
                    return iRubyObject2;
                }
                catch (StackOverflowError soe) {
                    throw runtime.newSystemStackError("stack level too deep", soe);
                }
                catch (Throwable e) {
                    throw new EvalFailedException(e);
                }
                threadContext.popScope();
            }
            vars.terminate();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (sharing_variables) {
                threadContext.popScope();
            }
            vars.terminate();
            throw throwable;
        }
    }
}

