/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.RubyInstanceConfig;
import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class InvokeDynamicInvocationCompiler
extends StandardInvocationCompiler {
    public InvokeDynamicInvocationCompiler(BaseBodyCompiler methodCompiler, SkinnyMethodAdapter method2) {
        super(methodCompiler, method2);
    }

    public void invokeAttrAssign(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, boolean selfCall, boolean expr) {
        String signature;
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        argsCallback.call(this.methodCompiler);
        switch (argsCallback.getArity()) {
            case 1: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 2: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.invokedynamic("attrAssign" + (selfCall ? "Self" : "") + (expr ? "Expr" : "") + ":" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getInvocationHandle(), this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine());
        if (!expr) {
            this.method.pop();
        }
    }

    public void invokeDynamic(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        String invokeName;
        block30: {
            block29: {
                if (callType == CallType.SUPER) {
                    super.invokeDynamic(name2, receiverCallback, argsCallback, callType, closureArg, iterator);
                    return;
                }
                this.methodCompiler.loadThreadContext();
                this.methodCompiler.loadSelf();
                if (receiverCallback != null) {
                    receiverCallback.call(this.methodCompiler);
                } else {
                    this.methodCompiler.loadSelf();
                }
                if (!iterator) break block29;
                switch (callType) {
                    case NORMAL: {
                        invokeName = "callIter";
                        break block30;
                    }
                    case FUNCTIONAL: {
                        invokeName = "fcallIter";
                        break block30;
                    }
                    case VARIABLE: {
                        invokeName = "vcallIter";
                        break block30;
                    }
                    default: {
                        throw new NotCompilableException("unknown call type " + (Object)((Object)callType));
                    }
                }
            }
            switch (callType) {
                case NORMAL: {
                    invokeName = "call";
                    break;
                }
                case FUNCTIONAL: {
                    invokeName = "fcall";
                    break;
                }
                case VARIABLE: {
                    invokeName = "vcall";
                    break;
                }
                default: {
                    throw new NotCompilableException("unknown call type " + (Object)((Object)callType));
                }
            }
        }
        invokeName = invokeName + ":" + JavaNameMangler.mangleMethodName(name2);
        if (argsCallback == null) {
            if (closureArg == null) {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
            } else {
                closureArg.call(this.methodCompiler);
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class));
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                        break;
                    }
                }
            } else {
                closureArg.call(this.methodCompiler);
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
                    }
                }
            }
        }
        this.method.invokedynamic(invokeName, signature, InvokeDynamicSupport.getInvocationHandle(), this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine());
    }

    public void invokeDynamicVarargs(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        String invokeName;
        block15: {
            block14: {
                if (callType == CallType.SUPER) {
                    super.invokeDynamic(name2, receiverCallback, argsCallback, callType, closureArg, iterator);
                    return;
                }
                assert (argsCallback.getArity() == -1);
                this.methodCompiler.loadThreadContext();
                this.methodCompiler.loadSelf();
                if (receiverCallback != null) {
                    receiverCallback.call(this.methodCompiler);
                } else {
                    this.methodCompiler.loadSelf();
                }
                if (!iterator) break block14;
                switch (callType) {
                    case NORMAL: {
                        invokeName = "callIter";
                        break block15;
                    }
                    case FUNCTIONAL: {
                        invokeName = "fcallIter";
                        break block15;
                    }
                    default: {
                        throw new NotCompilableException("unknown call type " + (Object)((Object)callType));
                    }
                }
            }
            switch (callType) {
                case NORMAL: {
                    invokeName = "call";
                    break;
                }
                case FUNCTIONAL: {
                    invokeName = "fcall";
                    break;
                }
                default: {
                    throw new NotCompilableException("unknown call type " + (Object)((Object)callType));
                }
            }
        }
        invokeName = invokeName + ":" + JavaNameMangler.mangleMethodName(name2);
        argsCallback.call(this.methodCompiler);
        if (closureArg == null) {
            signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
        } else {
            closureArg.call(this.methodCompiler);
            signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }
        this.method.invokedynamic(invokeName, signature, InvokeDynamicSupport.getInvocationHandle(), this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine());
    }

    public void invokeEqq(ArgumentsCallback receivers, final CompilerCallback argument) {
        if (argument == null) {
            super.invokeEqq(receivers, argument);
        } else if (receivers.getArity() == 1) {
            this.invokeDynamic("===", receivers, new ArgumentsCallback(){

                public int getArity() {
                    return 1;
                }

                public void call(BodyCompiler context) {
                    argument.call(context);
                }
            }, CallType.FUNCTIONAL, null, false);
            this.methodCompiler.isTrue();
        } else {
            super.invokeEqq(receivers, argument);
        }
    }

    public void yieldSpecific(ArgumentsCallback argsCallback) {
        String signature;
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback == null) {
            signature = CodegenUtils.sig(IRubyObject.class, Block.class, ThreadContext.class);
        } else {
            argsCallback.call(this.methodCompiler);
            switch (argsCallback.getArity()) {
                case 1: {
                    signature = CodegenUtils.sig(IRubyObject.class, Block.class, ThreadContext.class, IRubyObject.class);
                    break;
                }
                case 2: {
                    signature = CodegenUtils.sig(IRubyObject.class, Block.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                case 3: {
                    signature = CodegenUtils.sig(IRubyObject.class, Block.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                default: {
                    throw new NotCompilableException("Can't do specific-arity call for > 3 args yet");
                }
            }
        }
        this.method.invokedynamic("yieldSpecific", signature, InvokeDynamicSupport.getInvocationHandle(), this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine());
    }

    public void invokeBinaryFixnumRHS(String name2, CompilerCallback receiverCallback, long fixnum) {
        if (!RubyInstanceConfig.INVOKEDYNAMIC_FASTOPS) {
            super.invokeBinaryFixnumRHS(name2, receiverCallback, fixnum);
            return;
        }
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.method.invokedynamic("fixnumOperator:" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getFixnumOperatorHandle(), fixnum, this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine());
    }

    public void invokeBinaryBooleanFixnumRHS(String name2, CompilerCallback receiverCallback, long fixnum) {
        if (!RubyInstanceConfig.INVOKEDYNAMIC_FASTOPS) {
            super.invokeBinaryFixnumRHS(name2, receiverCallback, fixnum);
            return;
        }
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        String signature = CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.method.invokedynamic("fixnumBoolean:" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getFixnumBooleanHandle(), fixnum, this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine());
    }

    public void invokeBinaryFloatRHS(String name2, CompilerCallback receiverCallback, double flote) {
        if (!RubyInstanceConfig.INVOKEDYNAMIC_FASTOPS) {
            super.invokeBinaryFloatRHS(name2, receiverCallback, flote);
            return;
        }
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.method.invokedynamic("floatOperator:" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getFloatOperatorHandle(), flote, this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine());
    }
}

