/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.util.TraceClassVisitor;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.ClassCache;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JITCompiler
implements JITCompilerMBean {
    private static final Logger LOG = LoggerFactory.getLogger("JITCompiler");
    public static final boolean USE_CACHE = true;
    public static final String RUBY_JIT_PREFIX = "rubyjit";
    public static final String CLASS_METHOD_DELIMITER = "$$";
    private final JITCounts counts = new JITCounts();
    private final ExecutorService executor = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("JRubyJIT"));

    public JITCompiler(Ruby ruby2) {
        ruby2.getBeanManager().register(this);
    }

    public void tryJIT(DefaultMethod method2, ThreadContext context, String className, String methodName) {
        if (context.runtime.getInstanceConfig().getCompileMode().shouldJIT()) {
            this.jitIsEnabled(method2, context, className, methodName);
        }
    }

    public void tearDown() {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private void jitIsEnabled(DefaultMethod method2, ThreadContext context, String className, String methodName) {
        RubyInstanceConfig instanceConfig = context.runtime.getInstanceConfig();
        if (method2.incrementCallCount() >= instanceConfig.getJitThreshold()) {
            this.jitThresholdReached(method2, instanceConfig, context, className, methodName);
        }
    }

    private void jitThresholdReached(final DefaultMethod method2, final RubyInstanceConfig config, ThreadContext context, final String className, final String methodName) {
        method2.setCallCount(-1);
        final Ruby runtime = context.runtime;
        Runnable jitTask = new Runnable(){

            public void run() {
                try {
                    int methodCount;
                    ClassCache classCache = config.getClassCache();
                    if (classCache.isFull()) {
                        JITCompiler.this.counts.abandonCount.incrementAndGet();
                        return;
                    }
                    if (config.getExcludedMethods().size() > 0) {
                        IRubyObject possibleRealClass;
                        String excludeModuleName = className;
                        if (method2.getImplementationClass().isSingleton() && (possibleRealClass = ((MetaClass)method2.getImplementationClass()).getAttached()) instanceof RubyModule) {
                            excludeModuleName = "Meta:" + ((RubyModule)possibleRealClass).getName();
                        }
                        if (config.getExcludedMethods().contains(excludeModuleName) || config.getExcludedMethods().contains(excludeModuleName + "#" + methodName) || config.getExcludedMethods().contains(methodName)) {
                            method2.setCallCount(-1);
                            JITCompiler.log(method2, methodName, "skipping method: " + excludeModuleName + "#" + methodName, new String[0]);
                            return;
                        }
                    }
                    String key2 = SexpMaker.create(methodName, method2.getArgsNode(), method2.getBodyNode());
                    JITClassGenerator generator = new JITClassGenerator(className, methodName, key2, runtime, method2, JITCompiler.this.counts);
                    Class sourceClass = config.getClassCache().cacheClassByKey(key2, generator);
                    if (sourceClass == null) {
                        JITCompiler.this.counts.failCount.incrementAndGet();
                        return;
                    }
                    JITCompiler.this.counts.successCount.incrementAndGet();
                    Script jitCompiledScript = (Script)sourceClass.newInstance();
                    Set<Script> jittedMethods = runtime.getJittedMethods();
                    jittedMethods.add(jitCompiledScript);
                    if (config.getJitLogEvery() > 0 && (methodCount = jittedMethods.size()) % config.getJitLogEvery() == 0) {
                        JITCompiler.log(method2, methodName, "live compiled methods: " + methodCount, new String[0]);
                    }
                    if (config.isJitLogging()) {
                        JITCompiler.log(method2, className + "." + methodName, "done jitting", new String[0]);
                    }
                    method2.switchToJitted(jitCompiledScript, generator.callConfig());
                    return;
                }
                catch (Throwable t) {
                    if (runtime.getDebug().isTrue()) {
                        t.printStackTrace();
                    }
                    if (config.isJitLoggingVerbose()) {
                        JITCompiler.log(method2, className + "." + methodName, "could not compile", t.getMessage());
                    }
                    JITCompiler.this.counts.failCount.incrementAndGet();
                    return;
                }
            }
        };
        if (config.getJitBackground() && config.getJitThreshold() > 0 && this.executor != null) {
            try {
                this.executor.submit(jitTask);
            }
            catch (RejectedExecutionException ree) {
                jitTask.run();
            }
        } else {
            jitTask.run();
        }
    }

    public static String getHashForString(String str) {
        return JITCompiler.getHashForBytes(RubyEncoding.encodeUTF8(str));
    }

    public static String getHashForBytes(byte[] bytes2) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(bytes2);
            byte[] digest2 = sha1.digest();
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < digest2.length; ++i2) {
                builder.append(Integer.toString((digest2[i2] & 0xFF) + 256, 16).substring(1));
            }
            return builder.toString().toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveToCodeCache(Ruby ruby2, byte[] bytecode, String packageName, File cachedClassFile) {
        block16: {
            FileOutputStream fos;
            String codeCache = RubyInstanceConfig.JIT_CODE_CACHE;
            File codeCacheDir = new File(codeCache);
            if (!codeCacheDir.exists()) {
                ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " does not exist");
            } else if (!codeCacheDir.isDirectory()) {
                ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " is not a directory");
            } else if (!codeCacheDir.canWrite()) {
                ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " is not writable");
            } else {
                boolean createdDirs;
                if (!new File(codeCache, packageName).isDirectory() && !(createdDirs = new File(codeCache, packageName).mkdirs())) {
                    ruby2.getWarnings().warn("could not create JIT cache dir: " + new File(codeCache, packageName));
                }
                fos = null;
                if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                    LOG.info("writing jitted code to to " + cachedClassFile, new Object[0]);
                }
                fos = new FileOutputStream(cachedClassFile);
                fos.write(bytecode);
                Object var9_8 = null;
                try {
                    fos.close();
                }
                catch (Exception e2) {}
            }
            break block16;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var9_9 = null;
                    try {
                        fos.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    fos.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static String calculateFilename(ArgsNode argsNode, Node bodyNode) {
        if (bodyNode != null) {
            return bodyNode.getPosition().getFile();
        }
        if (argsNode != null) {
            return argsNode.getPosition().getFile();
        }
        return "__eval__";
    }

    static void log(DefaultMethod method2, String name2, String message2, String ... reason2) {
        String className = method2.getImplementationClass().getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        StringBuilder builder = new StringBuilder(message2 + ":" + className + "." + name2 + " at " + method2.getPosition());
        if (reason2.length > 0) {
            builder.append(" because of: \"");
            for (int i2 = 0; i2 < reason2.length; ++i2) {
                builder.append(reason2[i2]);
            }
            builder.append('\"');
        }
        LOG.info(builder.toString(), new Object[0]);
    }

    public long getSuccessCount() {
        return this.counts.successCount.get();
    }

    public long getCompileCount() {
        return this.counts.compiledCount.get();
    }

    public long getFailCount() {
        return this.counts.failCount.get();
    }

    public long getCompileTime() {
        return this.counts.compileTime.get() / 1000L;
    }

    public long getAbandonCount() {
        return this.counts.abandonCount.get();
    }

    public long getCodeSize() {
        return this.counts.codeSize.get();
    }

    public long getAverageCodeSize() {
        return this.counts.averageCodeSize.get();
    }

    public long getAverageCompileTime() {
        return this.counts.averageCompileTime.get() / 1000L;
    }

    public long getLargestCodeSize() {
        return this.counts.largestCodeSize.get();
    }

    static /* synthetic */ Logger access$500() {
        return LOG;
    }

    public static class JITClassGenerator
    implements ClassCache.ClassGenerator {
        private final StandardASMCompiler asmCompiler;
        private final StaticScope staticScope;
        private final Node bodyNode;
        private final ArgsNode argsNode;
        private final Ruby ruby;
        private final String packageName;
        private final String className;
        private final String filename;
        private final String methodName;
        private final JITCounts counts;
        private final String digestString;
        private CallConfiguration jitCallConfig;
        private byte[] bytecode;
        private String name;

        public JITClassGenerator(String className, String methodName, String key2, Ruby ruby2, DefaultMethod method2, JITCounts counts) {
            this.packageName = JITCompiler.RUBY_JIT_PREFIX;
            this.digestString = RubyInstanceConfig.JAVA_VERSION == 51 ? JITCompiler.getHashForString(key2) + Math.abs(ruby2.hashCode()) : JITCompiler.getHashForString(key2);
            this.className = this.packageName + "/" + className.replace('.', '/') + JITCompiler.CLASS_METHOD_DELIMITER + JavaNameMangler.mangleMethodName(methodName) + "_" + this.digestString;
            this.name = this.className.replaceAll("/", ".");
            this.bodyNode = method2.getBodyNode();
            this.argsNode = method2.getArgsNode();
            this.methodName = methodName;
            this.filename = JITCompiler.calculateFilename(this.argsNode, this.bodyNode);
            this.staticScope = method2.getStaticScope();
            this.asmCompiler = new StandardASMCompiler(this.className, this.filename);
            this.ruby = ruby2;
            this.counts = counts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void compile() {
            block23: {
                if (this.bytecode != null) {
                    return;
                }
                codeCache = RubyInstanceConfig.JIT_CODE_CACHE;
                cachedClassFile = new File(codeCache + "/" + this.className + ".class");
                if (codeCache != null && cachedClassFile.exists()) {
                    fis = null;
                    try {
                        try {
                            if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                                JITCompiler.access$500().info("loading cached code from: " + cachedClassFile, new Object[0]);
                            }
                            fis = new FileInputStream(cachedClassFile);
                            this.bytecode = new byte[(int)fis.getChannel().size()];
                            fis.read(this.bytecode);
                            this.name = new ClassReader(this.bytecode).getClassName();
                            var6_4 = null;
                        }
                        catch (Exception e) {
                            var6_5 = null;
                            try {
                                fis.close();
                            }
                            catch (Exception e) {}
                            break block23;
                        }
                    }
                    catch (Throwable var5_11) {
                        var6_6 = null;
                        ** try [egrp 2[TRYBLOCK] [4 : 173->180)] { 
lbl31:
                        // 1 sources

                        fis.close();
                        throw var5_11;
lbl33:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                        throw var5_11;
                    }
                    ** try [egrp 2[TRYBLOCK] [4 : 173->180)] { 
lbl38:
                    // 1 sources

                    fis.close();
                    return;
lbl40:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
            }
            start = System.nanoTime();
            this.asmCompiler.startScript(this.staticScope);
            compiler = this.ruby.getInstanceConfig().newCompiler();
            args = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    compiler.compileArgs(JITClassGenerator.this.argsNode, context, true);
                }
            };
            inspector = new ASTInspector();
            if (this.ruby.getInstanceConfig().isJitDumping()) {
                inspector = new ASTInspector(this.className, true);
            }
            inspector.inspect(this.argsNode);
            inspector.inspect(this.bodyNode);
            if (this.bodyNode != null) {
                methodCompiler = this.asmCompiler.startFileMethod(args, this.staticScope, inspector);
                compiler.compileBody(this.bodyNode, methodCompiler, true);
            } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                methodCompiler = this.asmCompiler.startFileMethod(args, this.staticScope, inspector);
                methodCompiler.loadNil();
            } else {
                methodCompiler = this.asmCompiler.startFileMethod(null, this.staticScope, inspector);
                methodCompiler.loadNil();
                this.jitCallConfig = CallConfiguration.FrameNoneScopeNone;
            }
            methodCompiler.endBody();
            this.asmCompiler.endScript(false, false);
            if (this.jitCallConfig == null) {
                this.jitCallConfig = inspector.getCallConfig();
            }
            this.bytecode = this.asmCompiler.getClassByteArray();
            if (this.ruby.getInstanceConfig().isJitDumping()) {
                tcv = new TraceClassVisitor(new PrintWriter(System.out));
                new ClassReader(this.bytecode).accept(tcv, 0);
            }
            if (this.bytecode.length > this.ruby.getInstanceConfig().getJitMaxSize()) {
                this.bytecode = null;
                throw new NotCompilableException("JITed method size exceeds configured max of " + this.ruby.getInstanceConfig().getJitMaxSize());
            }
            if (codeCache != null) {
                JITCompiler.saveToCodeCache(this.ruby, this.bytecode, this.packageName, cachedClassFile);
            }
            JITCounts.access$700(this.counts).incrementAndGet();
            JITCounts.access$800(this.counts).addAndGet(System.nanoTime() - start);
            JITCounts.access$900(this.counts).addAndGet(this.bytecode.length);
            JITCounts.access$1000(this.counts).set(JITCounts.access$800(this.counts).get() / JITCounts.access$700(this.counts).get());
            JITCounts.access$1100(this.counts).set(JITCounts.access$900(this.counts).get() / JITCounts.access$700(this.counts).get());
            var11_15 = this.counts;
            synchronized (var11_15) {
                if (JITCounts.access$1200(this.counts).get() >= (long)this.bytecode.length) return;
                JITCounts.access$1200(this.counts).set(this.bytecode.length);
                return;
            }
        }

        public void generate() {
            this.compile();
        }

        public byte[] bytecode() {
            return this.bytecode;
        }

        public String name() {
            return this.name;
        }

        public CallConfiguration callConfig() {
            this.compile();
            return this.jitCallConfig;
        }

        public String toString() {
            return this.methodName + "() at " + this.bodyNode.getPosition().getFile() + ":" + this.bodyNode.getPosition().getLine();
        }
    }

    public static class JITCounts {
        private final AtomicLong compiledCount = new AtomicLong(0L);
        private final AtomicLong successCount = new AtomicLong(0L);
        private final AtomicLong failCount = new AtomicLong(0L);
        private final AtomicLong abandonCount = new AtomicLong(0L);
        private final AtomicLong compileTime = new AtomicLong(0L);
        private final AtomicLong averageCompileTime = new AtomicLong(0L);
        private final AtomicLong codeSize = new AtomicLong(0L);
        private final AtomicLong averageCodeSize = new AtomicLong(0L);
        private final AtomicLong largestCodeSize = new AtomicLong(0L);
    }
}

