/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.unsafe.UnsafeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueNode
extends Node {
    private final Node bodyNode;
    private final RescueBodyNode rescueNode;
    private final Node elseNode;

    public RescueNode(ISourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
        super(position);
        this.bodyNode = bodyNode;
        this.rescueNode = rescueNode;
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RESCUENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public RescueBodyNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.rescueNode, this.bodyNode, this.elseNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.interpretWithJavaExceptions(runtime, context, self, aBlock);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRubyObject interpretWithJavaExceptions(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result2 = null;
        boolean exceptionRaised = false;
        while (true) {
            Object var12_18;
            IRubyObject globalExceptionState = runtime.getGlobalVariables().get("$!");
            boolean anotherExceptionRaised = false;
            try {
                try {
                    result2 = this.executeBody(runtime, context, self, aBlock);
                    var12_18 = null;
                    if (!anotherExceptionRaised) {
                        runtime.getGlobalVariables().set("$!", globalExceptionState);
                    }
                }
                catch (RaiseException raiseJump) {
                    block17: {
                        try {
                            result2 = this.handleException(runtime, context, self, aBlock, raiseJump);
                            exceptionRaised = true;
                        }
                        catch (JumpException.RetryJump rj) {
                            break block17;
                        }
                        catch (RaiseException je) {
                            anotherExceptionRaised = true;
                            throw je;
                        }
                        var12_18 = null;
                        if (!anotherExceptionRaised) {
                            runtime.getGlobalVariables().set("$!", globalExceptionState);
                        }
                        break;
                    }
                    var12_18 = null;
                    if (anotherExceptionRaised) continue;
                    runtime.getGlobalVariables().set("$!", globalExceptionState);
                    continue;
                }
                catch (JumpException.FlowControlException flow) {
                    throw flow;
                }
                catch (Throwable t) {
                    if (t instanceof Unrescuable) {
                        UnsafeFactory.getUnsafe().throwException(t);
                    }
                    try {
                        result2 = this.handleJavaException(runtime, context, self, aBlock, t);
                        exceptionRaised = true;
                    }
                    catch (JumpException.RetryJump rj) {
                        var12_18 = null;
                        if (anotherExceptionRaised) continue;
                        runtime.getGlobalVariables().set("$!", globalExceptionState);
                        continue;
                    }
                    catch (RaiseException je) {
                        anotherExceptionRaised = true;
                        throw je;
                    }
                    var12_18 = null;
                    if (!anotherExceptionRaised) {
                        runtime.getGlobalVariables().set("$!", globalExceptionState);
                    }
                }
            }
            catch (Throwable throwable) {
                var12_18 = null;
                if (anotherExceptionRaised) throw throwable;
                runtime.getGlobalVariables().set("$!", globalExceptionState);
                throw throwable;
            }
            break;
        }
        if (this.elseNode == null) return result2;
        if (exceptionRaised) return result2;
        if (this.rescueNode != null) return this.elseNode.interpret(runtime, context, self, aBlock);
        runtime.getWarnings().warn(IRubyWarnings.ID.ELSE_WITHOUT_RESCUE, this.elseNode.getPosition(), "else without rescue is useless");
        return this.elseNode.interpret(runtime, context, self, aBlock);
    }

    private IRubyObject handleException(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock, RaiseException raiseJump) {
        RubyException raisedException = raiseJump.getException();
        for (RescueBodyNode cRescueNode = this.rescueNode; cRescueNode != null; cRescueNode = cRescueNode.getOptRescueNode()) {
            IRubyObject[] exceptions = this.getExceptions(cRescueNode, runtime, context, self, aBlock);
            if (!RuntimeHelpers.isExceptionHandled(raisedException, exceptions, context).isTrue()) continue;
            return cRescueNode.interpret(runtime, context, self, aBlock);
        }
        throw raiseJump;
    }

    private IRubyObject handleJavaException(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock, Throwable throwable) {
        for (RescueBodyNode cRescueNode = this.rescueNode; cRescueNode != null; cRescueNode = cRescueNode.getOptRescueNode()) {
            IRubyObject exceptionObj;
            IRubyObject[] exceptions = this.getExceptions(cRescueNode, runtime, context, self, aBlock);
            if (!RuntimeHelpers.isJavaExceptionHandled(throwable, exceptions, context).isTrue()) continue;
            if (exceptions.length == 1 && exceptions[0] == runtime.getNativeException()) {
                exceptionObj = new NativeException(runtime, runtime.getNativeException(), throwable);
                ((NativeException)exceptionObj).prepareIntegratedBacktrace(context, throwable.getStackTrace());
            } else {
                exceptionObj = JavaUtil.convertJavaToUsableRubyObject(runtime, throwable);
            }
            runtime.getGlobalVariables().set("$!", exceptionObj);
            return cRescueNode.interpret(runtime, context, self, aBlock);
        }
        UnsafeFactory.getUnsafe().throwException(throwable);
        throw new RuntimeException("Unsafe.throwException failed");
    }

    private IRubyObject executeBody(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.bodyNode == null) {
            return runtime.getNil();
        }
        return this.bodyNode.interpret(runtime, context, self, aBlock);
    }

    private IRubyObject[] getExceptions(RescueBodyNode cRescueNode, Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        Node exceptionNodes = cRescueNode.getExceptionNodes();
        IRubyObject[] exceptions = exceptionNodes == null ? new IRubyObject[]{runtime.getStandardError()} : ASTInterpreter.setupArgs(runtime, context, exceptionNodes, self, aBlock);
        return exceptions;
    }
}

