/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.isismtt.x509;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import org.bouncycastle.asn1.x500.DirectoryString;

public class ProfessionInfo
extends ASN1Encodable {
    public static final DERObjectIdentifier Rechtsanwltin = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".1");
    public static final DERObjectIdentifier Rechtsanwalt = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".2");
    public static final DERObjectIdentifier Rechtsbeistand = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".3");
    public static final DERObjectIdentifier Steuerberaterin = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".4");
    public static final DERObjectIdentifier Steuerberater = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".5");
    public static final DERObjectIdentifier Steuerbevollmchtigte = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".6");
    public static final DERObjectIdentifier Steuerbevollmchtigter = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".7");
    public static final DERObjectIdentifier Notarin = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".8");
    public static final DERObjectIdentifier Notar = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".9");
    public static final DERObjectIdentifier Notarvertreterin = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".10");
    public static final DERObjectIdentifier Notarvertreter = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".11");
    public static final DERObjectIdentifier Notariatsverwalterin = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".12");
    public static final DERObjectIdentifier Notariatsverwalter = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".13");
    public static final DERObjectIdentifier Wirtschaftsprferin = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".14");
    public static final DERObjectIdentifier Wirtschaftsprfer = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".15");
    public static final DERObjectIdentifier VereidigteBuchprferin = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".16");
    public static final DERObjectIdentifier VereidigterBuchprfer = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".17");
    public static final DERObjectIdentifier Patentanwltin = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".18");
    public static final DERObjectIdentifier Patentanwalt = new DERObjectIdentifier(NamingAuthority.id_isismtt_at_namingAuthorities_RechtWirtschaftSteuern + ".19");
    private NamingAuthority namingAuthority;
    private ASN1Sequence professionItems;
    private ASN1Sequence professionOIDs;
    private String registrationNumber;
    private ASN1OctetString addProfessionInfo;

    public static ProfessionInfo getInstance(Object object) {
        if (object == null || object instanceof ProfessionInfo) {
            return (ProfessionInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ProfessionInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    private ProfessionInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() > 5) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        DEREncodable dEREncodable = (DEREncodable)enumeration.nextElement();
        if (dEREncodable instanceof ASN1TaggedObject) {
            if (((ASN1TaggedObject)dEREncodable).getTagNo() != 0) {
                throw new IllegalArgumentException("Bad tag number: " + ((ASN1TaggedObject)dEREncodable).getTagNo());
            }
            this.namingAuthority = NamingAuthority.getInstance((ASN1TaggedObject)dEREncodable, true);
            dEREncodable = (DEREncodable)enumeration.nextElement();
        }
        this.professionItems = ASN1Sequence.getInstance(dEREncodable);
        if (enumeration.hasMoreElements()) {
            dEREncodable = (DEREncodable)enumeration.nextElement();
            if (dEREncodable instanceof ASN1Sequence) {
                this.professionOIDs = ASN1Sequence.getInstance(dEREncodable);
            } else if (dEREncodable instanceof DERPrintableString) {
                this.registrationNumber = DERPrintableString.getInstance(dEREncodable).getString();
            } else if (dEREncodable instanceof ASN1OctetString) {
                this.addProfessionInfo = ASN1OctetString.getInstance(dEREncodable);
            } else {
                throw new IllegalArgumentException("Bad object encountered: " + dEREncodable.getClass());
            }
        }
        if (enumeration.hasMoreElements()) {
            dEREncodable = (DEREncodable)enumeration.nextElement();
            if (dEREncodable instanceof DERPrintableString) {
                this.registrationNumber = DERPrintableString.getInstance(dEREncodable).getString();
            } else if (dEREncodable instanceof DEROctetString) {
                this.addProfessionInfo = (DEROctetString)dEREncodable;
            } else {
                throw new IllegalArgumentException("Bad object encountered: " + dEREncodable.getClass());
            }
        }
        if (enumeration.hasMoreElements()) {
            dEREncodable = (DEREncodable)enumeration.nextElement();
            if (dEREncodable instanceof DEROctetString) {
                this.addProfessionInfo = (DEROctetString)dEREncodable;
            } else {
                throw new IllegalArgumentException("Bad object encountered: " + dEREncodable.getClass());
            }
        }
    }

    public ProfessionInfo(NamingAuthority namingAuthority, DirectoryString[] directoryStringArray, DERObjectIdentifier[] dERObjectIdentifierArray, String string2, ASN1OctetString aSN1OctetString) {
        int n;
        this.namingAuthority = namingAuthority;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (n = 0; n != directoryStringArray.length; ++n) {
            aSN1EncodableVector.add(directoryStringArray[n]);
        }
        this.professionItems = new DERSequence(aSN1EncodableVector);
        if (dERObjectIdentifierArray != null) {
            aSN1EncodableVector = new ASN1EncodableVector();
            for (n = 0; n != dERObjectIdentifierArray.length; ++n) {
                aSN1EncodableVector.add(dERObjectIdentifierArray[n]);
            }
            this.professionOIDs = new DERSequence(aSN1EncodableVector);
        }
        this.registrationNumber = string2;
        this.addProfessionInfo = aSN1OctetString;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.namingAuthority != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.namingAuthority));
        }
        aSN1EncodableVector.add(this.professionItems);
        if (this.professionOIDs != null) {
            aSN1EncodableVector.add(this.professionOIDs);
        }
        if (this.registrationNumber != null) {
            aSN1EncodableVector.add(new DERPrintableString(this.registrationNumber, true));
        }
        if (this.addProfessionInfo != null) {
            aSN1EncodableVector.add(this.addProfessionInfo);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public ASN1OctetString getAddProfessionInfo() {
        return this.addProfessionInfo;
    }

    public NamingAuthority getNamingAuthority() {
        return this.namingAuthority;
    }

    public DirectoryString[] getProfessionItems() {
        DirectoryString[] directoryStringArray = new DirectoryString[this.professionItems.size()];
        int n = 0;
        Enumeration enumeration = this.professionItems.getObjects();
        while (enumeration.hasMoreElements()) {
            directoryStringArray[n++] = DirectoryString.getInstance(enumeration.nextElement());
        }
        return directoryStringArray;
    }

    public DERObjectIdentifier[] getProfessionOIDs() {
        if (this.professionOIDs == null) {
            return new DERObjectIdentifier[0];
        }
        DERObjectIdentifier[] dERObjectIdentifierArray = new DERObjectIdentifier[this.professionOIDs.size()];
        int n = 0;
        Enumeration enumeration = this.professionOIDs.getObjects();
        while (enumeration.hasMoreElements()) {
            dERObjectIdentifierArray[n++] = DERObjectIdentifier.getInstance(enumeration.nextElement());
        }
        return dERObjectIdentifierArray;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }
}

