/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.RubyFile;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyFile;

public class ExternalScript
implements Library {
    private final LoadServiceResource resource;

    public ExternalScript(LoadServiceResource resource2, String name2) {
        this.resource = resource2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(Ruby runtime, boolean wrap2) {
        InputStream in = null;
        try {
            try {
                in = this.resource.getInputStream();
                String name2 = JRubyFile.normalizeSeps(this.resource.getName());
                if (runtime.getInstanceConfig().getCompileMode().shouldPrecompileAll()) {
                    runtime.compileAndLoadFile(name2, in, wrap2);
                } else {
                    File path2 = this.resource.getPath();
                    if (path2 != null && !this.resource.isAbsolute()) {
                        name2 = JRubyFile.normalizeSeps(RubyFile.canonicalize(path2.getPath()));
                    }
                    runtime.loadFile(name2, in, wrap2);
                }
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        in.close();
        return;
    }

    public String toString() {
        return "ExternalScript: " + this.resource.getName();
    }
}

