/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class TemporaryClosureVariable
extends TemporaryVariable {
    final int closureId;
    final String prefix;

    public TemporaryClosureVariable(int closureId, int offset2) {
        super(offset2);
        this.closureId = closureId;
        this.prefix = "%cl_" + closureId + "_";
        this.name = this.getPrefix() + offset2;
    }

    public TemporaryClosureVariable(String name2, int offset2) {
        super(name2, offset2);
        this.closureId = -1;
        this.prefix = "";
    }

    public Variable cloneForCloningClosure(InlinerInfo ii) {
        return new TemporaryClosureVariable(this.name, this.offset);
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void visit(IRVisitor visitor) {
        visitor.TemporaryClosureVariable(this);
    }
}

