/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHandle
extends Operand {
    protected final Operand methodName;
    protected final Operand receiver;
    private String resolvedMethodName;
    private CacheEntry cachedMethod;
    private IRubyObject receiverObj;

    public MethodHandle(Operand methodName, Operand receiver2) {
        this.methodName = methodName;
        this.receiver = receiver2;
    }

    public Operand getMethodNameOperand() {
        return this.methodName;
    }

    public DynamicMethod getResolvedMethod() {
        return this.cachedMethod.method;
    }

    public String getResolvedMethodName() {
        return this.resolvedMethodName;
    }

    public IRubyObject getReceiverObj() {
        return this.receiverObj;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.methodName.addUsedVariables(l);
        this.receiver.addUsedVariables(l);
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newMethodName = this.methodName.getSimplifiedOperand(valueMap, force);
        Operand newReceiver = this.receiver.getSimplifiedOperand(valueMap, force);
        return newMethodName == this.methodName && newReceiver == this.receiver ? this : new MethodHandle(newMethodName, newReceiver);
    }

    public String toString() {
        return "<" + this.receiver + "." + this.methodName + ">";
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return new MethodHandle(this.methodName.cloneForInlining(ii), this.receiver.cloneForInlining(ii));
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        this.receiverObj = (IRubyObject)this.receiver.retrieve(context, self, currDynScope, temp);
        if (this.methodName instanceof MethAddr) {
            this.resolvedMethodName = ((MethAddr)this.methodName).getName();
        } else {
            IRubyObject mnameObj = (IRubyObject)this.methodName.retrieve(context, self, currDynScope, temp);
            assert (mnameObj instanceof RubyString || mnameObj instanceof RubySymbol);
            if (!mnameObj.toString().equals(this.resolvedMethodName)) {
                this.cachedMethod = null;
                this.resolvedMethodName = mnameObj.toString();
            }
        }
        RubyClass receiverClass = this.receiverObj.getMetaClass();
        if (this.cachedMethod == null || !this.cachedMethod.typeOk(receiverClass)) {
            this.cachedMethod = receiverClass.searchWithCache(this.resolvedMethodName);
        }
        return this;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.MethodHandle(this);
    }
}

