/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array
extends Operand {
    public final Operand[] elts;

    public Array() {
        this.elts = new Operand[0];
    }

    public Array(List<Operand> elts) {
        this(elts.toArray(new Operand[elts.size()]));
    }

    public Array(Operand[] elts) {
        this.elts = elts == null ? new Operand[]{} : elts;
    }

    public boolean isBlank() {
        return this.elts.length == 0;
    }

    public int size() {
        return this.elts.length;
    }

    public Operand get(int i2) {
        return this.elts[i2];
    }

    public String toString() {
        return "Array:" + (this.isBlank() ? "[]" : Arrays.toString(this.elts));
    }

    @Override
    public boolean hasKnownValue() {
        for (Operand o : this.elts) {
            if (o.hasKnownValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand[] newElts = new Operand[this.elts.length];
        for (int i2 = 0; i2 < this.elts.length; ++i2) {
            newElts[i2] = this.elts[i2].getSimplifiedOperand(valueMap, force);
        }
        return new Array(newElts);
    }

    @Override
    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        return null;
    }

    public Operand toArray() {
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this.elts) {
            o.addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        if (this.hasKnownValue()) {
            return this;
        }
        Operand[] newElts = new Operand[this.elts.length];
        for (int i2 = 0; i2 < this.elts.length; ++i2) {
            newElts[i2] = this.elts[i2].cloneForInlining(ii);
        }
        return new Array(newElts);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        IRubyObject[] elements = new IRubyObject[this.elts.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = (IRubyObject)this.elts[i2].retrieve(context, self, currDynScope, temp);
        }
        return context.getRuntime().newArray(elements);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Array(this);
    }

    public Operand[] getElts() {
        return this.elts;
    }
}

