/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.ruby19;

import java.util.Map;
import org.jruby.RubyProc;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLambdaInstr
extends Instr
implements ResultInstr {
    private final ISourcePosition position;
    private Variable result;
    private Operand[] operands;

    public BuildLambdaInstr(Variable lambda2, IRClosure lambdaBody, ISourcePosition position) {
        super(Operation.LAMBDA);
        this.result = lambda2;
        this.operands = new Operand[]{new WrappedIRClosure(lambdaBody)};
        this.position = position;
    }

    @Override
    public Operand[] getOperands() {
        return this.operands;
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new BuildLambdaInstr(ii.getRenamedVariable(this.getResult()), this.getLambdaBody(), this.position);
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        for (int i2 = 0; i2 < this.operands.length; ++i2) {
            this.operands[i2] = this.operands[i2].getSimplifiedOperand(valueMap, force);
        }
    }

    private IRClosure getLambdaBody() {
        return ((WrappedIRClosure)this.operands[0]).getClosure();
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block aBlock) {
        this.getLambdaBody().getStaticScope().determineModule();
        IRClosure body = this.getLambdaBody();
        return RubyProc.newProc(context.getRuntime(), (Block)(body == null ? context.getRuntime().getIRManager().getNil() : this.operands[0]).retrieve(context, self, currDynScope, temp), Block.Type.LAMBDA, this.position);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildLambdaInstr(this);
    }
}

