/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EQQInstr
extends Instr
implements ResultInstr {
    private Operand arg1;
    private Operand arg2;
    private Variable result;

    public EQQInstr(Variable result2, Operand v1, Operand v2) {
        super(Operation.EQQ);
        assert (result2 != null) : "EQQInstr result is null";
        this.arg1 = v1;
        this.arg2 = v2;
        this.result = result2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.arg1, this.arg2};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.arg1 = this.arg1.getSimplifiedOperand(valueMap, force);
        this.arg2 = this.arg2.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.arg1 + ", " + this.arg2 + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new EQQInstr(ii.getRenamedVariable(this.result), this.arg1.cloneForInlining(ii), this.arg2.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        boolean isUndefValue;
        IRubyObject receiver2 = (IRubyObject)this.arg1.retrieve(context, self, currDynScope, temp);
        IRubyObject value2 = (IRubyObject)this.arg2.retrieve(context, self, currDynScope, temp);
        boolean bl = isUndefValue = value2 == UndefinedValue.UNDEFINED;
        if (receiver2 instanceof RubyArray) {
            RubyArray testVals = (RubyArray)receiver2;
            int n = testVals.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                IRubyObject eqqVal;
                IRubyObject v = testVals.eltInternal(i2);
                IRubyObject iRubyObject = eqqVal = isUndefValue ? v : v.callMethod(context, "===", value2);
                if (!eqqVal.isTrue()) continue;
                return eqqVal;
            }
            return context.getRuntime().newBoolean(false);
        }
        return isUndefValue ? receiver2 : receiver2.callMethod(context, "===", value2);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.EQQInstr(this);
    }
}

