/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckArgsArrayArityInstr
extends Instr {
    public final int required;
    public final int opt;
    public final int rest;
    private Operand argsArray;

    public CheckArgsArrayArityInstr(Operand argsArray, int required, int opt, int rest2) {
        super(Operation.CHECK_ARGS_ARRAY_ARITY);
        this.required = required;
        this.opt = opt;
        this.rest = rest2;
        this.argsArray = argsArray;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.argsArray};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.argsArray = this.argsArray.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.argsArray + ", " + this.required + ", " + this.opt + ", " + this.rest + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new CheckArgsArrayArityInstr(this.argsArray.cloneForInlining(ii), this.required, this.opt, this.rest);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        RubyArray args2 = (RubyArray)this.argsArray.retrieve(context, self, currDynScope, temp);
        int numArgs = args2.size();
        if (numArgs < this.required || this.rest == -1 && numArgs > this.required + this.opt) {
            Arity.raiseArgumentError(context.getRuntime(), numArgs, this.required, this.required + this.opt);
        }
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CheckArgsArrayArityInstr(this);
    }
}

