/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.jruby.util.unsafe.UnsafeFactory;

public class CompiledIRMethod
extends DynamicMethod
implements PositionAware {
    private static final Logger LOG = LoggerFactory.getLogger("CompiledIRMethod");
    private final MethodHandle method;
    private final String name;
    private final String file;
    private final int line;
    private final StaticScope scope;
    private Arity arity;
    boolean displayedCFG = false;

    public CompiledIRMethod(MethodHandle method2, String name2, String file2, int line, StaticScope scope, Visibility visibility, RubyModule implementationClass) {
        super(implementationClass, visibility, CallConfiguration.FrameNoneScopeNone);
        this.method = method2;
        this.name = name2;
        this.file = file2;
        this.line = line;
        this.scope = scope;
        this.arity = this.calculateArity();
        this.setHandle(method2);
    }

    private Arity calculateArity() {
        StaticScope s2 = this.scope;
        if (s2.getOptionalArgs() > 0 || s2.getRestArg() >= 0) {
            return Arity.required(s2.getRequiredArgs());
        }
        return Arity.createArity(s2.getRequiredArgs());
    }

    public Arity getArity() {
        return this.arity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        if (Interpreter.isDebug()) {
            String realName = name2 == null || "".equals(name2) ? this.name : name2;
            LOG.info("Executing '" + realName + "'", new Object[0]);
        }
        try {
            RubyModule implementationClass = this.getImplementationClass();
            context.preMethodFrameAndScope(implementationClass, name2, self, block, this.scope);
            context.setCurrentVisibility(this.getVisibility());
            IRubyObject iRubyObject = (IRubyObject)this.method.invokeWithArguments(context, this.scope, self, args2, block);
            Object var10_11 = null;
            context.popFrame();
            context.postMethodScopeOnly();
            return iRubyObject;
        }
        catch (Throwable t) {
            try {
                UnsafeFactory.getUnsafe().throwException(t);
                IRubyObject iRubyObject = null;
                Object var10_12 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                return iRubyObject;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        if (Interpreter.isDebug()) {
            String realName = name2 == null || "".equals(name2) ? this.name : name2;
            LOG.info("Executing '" + realName + "'", new Object[0]);
        }
        try {
            RubyModule implementationClass = this.getImplementationClass();
            context.preMethodFrameAndScope(implementationClass, name2, self, block, this.scope);
            context.setCurrentVisibility(this.getVisibility());
            IRubyObject iRubyObject = (IRubyObject)this.method.invokeWithArguments(context, this.scope, self, block);
            Object var9_10 = null;
            context.popFrame();
            context.postMethodScopeOnly();
            return iRubyObject;
        }
        catch (Throwable t) {
            try {
                UnsafeFactory.getUnsafe().throwException(t);
                IRubyObject iRubyObject = null;
                Object var9_11 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                return iRubyObject;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (Interpreter.isDebug()) {
            String realName = name2 == null || "".equals(name2) ? this.name : name2;
            LOG.info("Executing '" + realName + "'", new Object[0]);
        }
        try {
            RubyModule implementationClass = this.getImplementationClass();
            context.preMethodFrameAndScope(implementationClass, name2, self, block, this.scope);
            context.setCurrentVisibility(this.getVisibility());
            IRubyObject iRubyObject = (IRubyObject)this.method.invokeWithArguments(context, this.scope, self, arg0, block);
            Object var10_11 = null;
            context.popFrame();
            context.postMethodScopeOnly();
            return iRubyObject;
        }
        catch (Throwable t) {
            try {
                UnsafeFactory.getUnsafe().throwException(t);
                IRubyObject iRubyObject = null;
                Object var10_12 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                return iRubyObject;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (Interpreter.isDebug()) {
            String realName = name2 == null || "".equals(name2) ? this.name : name2;
            LOG.info("Executing '" + realName + "'", new Object[0]);
        }
        try {
            RubyModule implementationClass = this.getImplementationClass();
            context.preMethodFrameAndScope(implementationClass, name2, self, block, this.scope);
            context.setCurrentVisibility(this.getVisibility());
            IRubyObject iRubyObject = (IRubyObject)this.method.invokeWithArguments(context, this.scope, self, arg0, arg1, block);
            Object var11_12 = null;
            context.popFrame();
            context.postMethodScopeOnly();
            return iRubyObject;
        }
        catch (Throwable t) {
            try {
                UnsafeFactory.getUnsafe().throwException(t);
                IRubyObject iRubyObject = null;
                Object var11_13 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                return iRubyObject;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (Interpreter.isDebug()) {
            String realName = name2 == null || "".equals(name2) ? this.name : name2;
            LOG.info("Executing '" + realName + "'", new Object[0]);
        }
        try {
            RubyModule implementationClass = this.getImplementationClass();
            context.preMethodFrameAndScope(implementationClass, name2, self, block, this.scope);
            context.setCurrentVisibility(this.getVisibility());
            IRubyObject iRubyObject = (IRubyObject)this.method.invokeWithArguments(context, this.scope, self, arg0, arg1, arg2, block);
            Object var12_13 = null;
            context.popFrame();
            context.postMethodScopeOnly();
            return iRubyObject;
        }
        catch (Throwable t) {
            try {
                UnsafeFactory.getUnsafe().throwException(t);
                IRubyObject iRubyObject = null;
                Object var12_14 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                return iRubyObject;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                context.popFrame();
                context.postMethodScopeOnly();
                throw throwable;
            }
        }
    }

    public DynamicMethod dup() {
        return new CompiledIRMethod(this.method, this.name, this.file, this.line, this.scope, this.visibility, this.implementationClass);
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public StaticScope getStaticScope() {
        return this.scope;
    }
}

