/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.hidden.jline.internal;

import java.util.ArrayList;
import java.util.List;
import org.jruby.hidden.jline.internal.Configuration;
import org.jruby.hidden.jline.internal.Log;
import org.jruby.hidden.jline.internal.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShutdownHooks {
    public static final String JLINE_SHUTDOWNHOOK = "org.jruby.hidden.jline.shutdownhook";
    private static final boolean enabled = Configuration.getBoolean("org.jruby.hidden.jline.shutdownhook", true);
    private static final List<Task> tasks = new ArrayList<Task>();
    private static Thread hook;

    public static synchronized <T extends Task> T add(T task) {
        Preconditions.checkNotNull(task);
        if (!enabled) {
            Log.debug("Shutdown-hook is disabled; not installing: ", task);
            return task;
        }
        if (hook == null) {
            hook = ShutdownHooks.addHook(new Thread("JLine Shutdown Hook"){

                public void run() {
                    ShutdownHooks.runTasks();
                }
            });
        }
        Log.debug("Adding shutdown-hook task: ", task);
        tasks.add(task);
        return task;
    }

    private static synchronized void runTasks() {
        Log.debug("Running all shutdown-hook tasks");
        for (Task task : tasks.toArray(new Task[tasks.size()])) {
            Log.debug("Running task: ", task);
            try {
                task.run();
            }
            catch (Throwable e) {
                Log.warn("Task failed", e);
            }
        }
        tasks.clear();
    }

    private static Thread addHook(Thread thread2) {
        Log.debug("Registering shutdown-hook: ", thread2);
        try {
            Runtime.getRuntime().addShutdownHook(thread2);
        }
        catch (AbstractMethodError e) {
            Log.debug("Failed to register shutdown-hook", e);
        }
        return thread2;
    }

    public static synchronized void remove(Task task) {
        Preconditions.checkNotNull(task);
        if (!enabled || hook == null) {
            return;
        }
        tasks.remove(task);
        if (tasks.isEmpty()) {
            ShutdownHooks.removeHook(hook);
            hook = null;
        }
    }

    private static void removeHook(Thread thread2) {
        Log.debug("Removing shutdown-hook: ", thread2);
        try {
            Runtime.getRuntime().removeShutdownHook(thread2);
        }
        catch (AbstractMethodError e) {
            Log.debug("Failed to remove shutdown-hook", e);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static interface Task {
        public void run() throws Exception;
    }
}

