/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;

public class Utils {
    private Utils() {
    }

    public static String toHex(byte[] val) {
        StringBuffer out = new StringBuffer();
        int j = val.length;
        for (int i2 = 0; i2 < j; ++i2) {
            String ve = Integer.toString((char)val[i2] & 0xFF, 16);
            if (ve.length() == 1) {
                ve = "0" + ve;
            }
            out.append(ve);
        }
        return out.toString();
    }

    public static String toHex(byte[] val, char sep) {
        StringBuffer out = new StringBuffer();
        String sap = "";
        int j = val.length;
        for (int i2 = 0; i2 < j; ++i2) {
            String ve = Integer.toString((char)val[i2] & 0xFF, 16);
            if (ve.length() == 1) {
                ve = "0" + ve;
            }
            out.append(sap).append(ve);
            sap = "" + sep;
        }
        return out.toString().toUpperCase();
    }

    public static void checkKind(Ruby rt, IRubyObject obj, String path2) {
        if (((RubyObject)obj).kind_of_p(rt.getCurrentContext(), rt.getClassFromPath(path2)).isFalse()) {
            throw rt.newTypeError(String.format("wrong argument (%s)! (Expected kind of %s)", obj.getMetaClass().getName(), path2));
        }
    }

    public static RubyClass getClassFromPath(Ruby rt, String path2) {
        return (RubyClass)rt.getClassFromPath(path2);
    }

    public static RaiseException newError(Ruby rt, String path2, String message2) {
        return new RaiseException(rt, Utils.getClassFromPath(rt, path2), message2, true);
    }

    public static RaiseException newError(Ruby rt, String path2, String message2, boolean nativeException) {
        return new RaiseException(rt, Utils.getClassFromPath(rt, path2), message2, nativeException);
    }

    public static IRubyObject newRubyInstance(Ruby rt, String path2) {
        return rt.getClassFromPath(path2).callMethod(rt.getCurrentContext(), "new");
    }

    public static IRubyObject newRubyInstance(Ruby rt, String path2, IRubyObject arg2) {
        return rt.getClassFromPath(path2).callMethod(rt.getCurrentContext(), "new", arg2);
    }

    public static IRubyObject newRubyInstance(Ruby rt, String path2, IRubyObject[] args2) {
        return rt.getClassFromPath(path2).callMethod(rt.getCurrentContext(), "new", args2);
    }
}

