/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperNode
extends Node
implements BlockAcceptingNode {
    private final Node argsNode;
    private Node iterNode;
    private final CallSite callSite;

    public SuperNode(ISourcePosition position, Node argsNode) {
        this(position, argsNode, null);
    }

    public SuperNode(ISourcePosition position, Node argsNode, Node iterNode) {
        super(position);
        this.argsNode = argsNode;
        this.iterNode = iterNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        this.callSite = MethodIndex.getSuperCallSite();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SUPERNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitSuperNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public List<Node> childNodes() {
        return this.iterNode != null ? SuperNode.createList(this.argsNode, this.iterNode) : SuperNode.createList(this.argsNode);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject[] args2 = ASTInterpreter.setupArgs(runtime, context, this.argsNode, self, aBlock);
        Block block = ASTInterpreter.getBlock(runtime, context, self, aBlock, this.iterNode);
        if (this.iterNode == null && !block.isGiven()) {
            block = aBlock;
        }
        return this.callSite.callVarargs(context, self, self, args2, block);
    }

    @Override
    public ByteList definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        String name2 = context.getFrameName();
        RubyModule klazz = context.getFrameKlazz();
        if (name2 != null && klazz != null && RuntimeHelpers.findImplementerIfNecessary(self.getMetaClass(), klazz).getSuperClass().isMethodBound(name2, false)) {
            return ASTInterpreter.getArgumentDefinition(runtime, context, this.argsNode, SUPER_BYTELIST, self, aBlock);
        }
        return null;
    }
}

