/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.DNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RegexpOptions;

public class DRegexpNode
extends DNode
implements ILiteralNode {
    private final RegexpOptions options;
    private RubyRegexp onceRegexp;

    public DRegexpNode(ISourcePosition position, RegexpOptions options2) {
        this(position, options2, null);
    }

    public DRegexpNode(ISourcePosition position, RegexpOptions options2, Encoding encoding2) {
        super(position, encoding2);
        this.options = options2;
    }

    public NodeType getNodeType() {
        return NodeType.DREGEXPNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDRegxNode(this);
    }

    public boolean getOnce() {
        return this.options.isOnce();
    }

    public RegexpOptions getOptions() {
        return this.options;
    }

    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.getOnce() && this.onceRegexp != null) {
            return this.onceRegexp;
        }
        RubyString string2 = runtime.is1_9() ? this.buildDRegexpString19(runtime, context, self, aBlock) : this.buildDynamicString(runtime, context, self, aBlock);
        RubyRegexp regexp2 = RubyRegexp.newDRegexp(runtime, string2, this.options);
        if (this.getOnce() && this.onceRegexp == null) {
            this.onceRegexp = regexp2;
        }
        return regexp2;
    }

    private RubyString buildDRegexpString19(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyString string2 = null;
        int size2 = this.size();
        IRubyObject[] strings = new RubyString[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            strings[i2] = this.getString(runtime, context, self, aBlock, string2, this.get(i2));
        }
        return RubyRegexp.preprocessDRegexp(runtime, strings, this.options);
    }

    public RubyString getString(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock, RubyString string2, Node node) {
        return node.interpret(runtime, context, self, aBlock).convertToString();
    }
}

