/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Colon2ConstNode
extends Colon2Node {
    private volatile transient IRubyObject cachedValue = null;
    private volatile Object generation = -1;
    private volatile int hash = -1;

    public Colon2ConstNode(ISourcePosition position, Node leftNode, String name2) {
        super(position, leftNode, name2);
        assert (leftNode != null) : "Colon2ConstNode cannot have null leftNode";
    }

    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyModule target = RuntimeHelpers.checkIsModule(this.leftNode.interpret(runtime, context, self, aBlock));
        IRubyObject value2 = this.getValue(context, target);
        return value2 != null ? value2 : target.getConstantFromConstMissing(this.name);
    }

    public ByteList definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject lastError = context.getErrorInfo();
        try {
            if (RuntimeHelpers.isModuleAndHasConstant(this.leftNode.interpret(runtime, context, self, aBlock), this.name)) {
                return CONSTANT_BYTELIST;
            }
        }
        catch (JumpException e) {
            context.setErrorInfo(lastError);
        }
        return null;
    }

    public IRubyObject getValue(ThreadContext context, RubyModule target) {
        IRubyObject value2 = this.cachedValue;
        return this.isCached(context, target, value2) ? value2 : this.reCache(context, target);
    }

    private boolean isCached(ThreadContext context, RubyModule target, IRubyObject value2) {
        return value2 != null && this.generation == context.getRuntime().getConstantInvalidator().getData() && this.hash == target.hashCode();
    }

    public IRubyObject reCache(ThreadContext context, RubyModule target) {
        IRubyObject value2;
        Object newGeneration = context.getRuntime().getConstantInvalidator().getData();
        this.cachedValue = value2 = target.getConstantFromNoConstMissing(this.name, false);
        if (value2 != null) {
            this.generation = newGeneration;
            this.hash = target.hashCode();
        }
        return value2;
    }
}

