/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyYielder;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Enumerable::Enumerator"}, include={"Enumerable"})
public class RubyEnumerator
extends RubyObject {
    private IRubyObject object;
    private String method;
    private IRubyObject[] methodArgs;
    private static ObjectAllocator ENUMERATOR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyEnumerator(runtime, klass);
        }
    };

    public static void defineEnumerator(Ruby runtime) {
        runtime.getKernel().defineAnnotatedMethods(RubyEnumeratorKernel.class);
        RubyModule enm = runtime.getClassFromPath("Enumerable");
        enm.defineAnnotatedMethods(RubyEnumeratorEnumerable.class);
        RubyClass enmr = runtime.is1_9() ? runtime.defineClass("Enumerator", runtime.getObject(), ENUMERATOR_ALLOCATOR) : enm.defineClassUnder("Enumerator", runtime.getObject(), ENUMERATOR_ALLOCATOR);
        enmr.includeModule(enm);
        enmr.defineAnnotatedMethods(RubyEnumerator.class);
        runtime.setEnumerator(enmr);
        RubyYielder.createYielderClass(runtime);
    }

    private RubyEnumerator(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
        this.object = runtime.getNil();
        this.initialize(runtime.getNil(), (IRubyObject)RubyString.newEmptyString(runtime), IRubyObject.NULL_ARRAY);
    }

    private RubyEnumerator(Ruby runtime, IRubyObject object, IRubyObject method2, IRubyObject[] args2) {
        super(runtime, runtime.getEnumerator());
        this.initialize(object, method2, args2);
    }

    public static IRubyObject enumeratorize(Ruby runtime, IRubyObject object, String method2) {
        return new RubyEnumerator(runtime, object, runtime.fastNewSymbol(method2), IRubyObject.NULL_ARRAY);
    }

    public static IRubyObject enumeratorize(Ruby runtime, IRubyObject object, String method2, IRubyObject arg2) {
        return new RubyEnumerator(runtime, object, runtime.fastNewSymbol(method2), new IRubyObject[]{arg2});
    }

    public static IRubyObject enumeratorize(Ruby runtime, IRubyObject object, String method2, IRubyObject[] args2) {
        return new RubyEnumerator(runtime, object, runtime.fastNewSymbol(method2), args2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context) {
        throw context.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newArgumentError(0, 1);
        }
        IRubyObject obj = context.getRuntime().getClass("Generator").callMethod(context, "new", new IRubyObject[0], block);
        return this.initialize19(context, obj, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context, IRubyObject object) {
        return this.initialize(object, (IRubyObject)context.getRuntime().fastNewSymbol("each"), NULL_ARRAY);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject object, Block block) {
        return this.initialize(object, (IRubyObject)context.getRuntime().fastNewSymbol("each"), NULL_ARRAY);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method2) {
        return this.initialize(object, method2, NULL_ARRAY);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject object, IRubyObject method2, Block block) {
        return this.initialize(object, method2, NULL_ARRAY);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method2, IRubyObject methodArg) {
        return this.initialize(object, method2, new IRubyObject[]{methodArg});
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject object, IRubyObject method2, IRubyObject methodArg, Block block) {
        return this.initialize(object, method2, new IRubyObject[]{methodArg});
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.initialize(context);
            }
            case 1: {
                return this.initialize(context, args2[0]);
            }
            case 2: {
                return this.initialize(context, args2[0], args2[1]);
            }
        }
        IRubyObject[] methArgs = new IRubyObject[args2.length - 2];
        System.arraycopy(args2, 2, methArgs, 0, methArgs.length);
        return this.initialize(args2[0], args2[1], methArgs);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.initialize19(context, block);
            }
            case 1: {
                return this.initialize19(context, args2[0], block);
            }
            case 2: {
                return this.initialize19(context, args2[0], args2[1], block);
            }
        }
        IRubyObject[] methArgs = new IRubyObject[args2.length - 2];
        System.arraycopy(args2, 2, methArgs, 0, methArgs.length);
        return this.initialize(args2[0], args2[1], methArgs);
    }

    private IRubyObject initialize(IRubyObject object, IRubyObject method2, IRubyObject[] methodArgs2) {
        this.object = object;
        this.method = method2.asJavaString();
        this.methodArgs = methodArgs2;
        this.setInstanceVariable("@__object__", object);
        this.setInstanceVariable("@__method__", method2);
        this.setInstanceVariable("@__args__", RubyArray.newArrayNoCopyLight(this.getRuntime(), methodArgs2));
        return this;
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyEnumerator copy = (RubyEnumerator)super.dup();
        copy.object = this.object;
        copy.method = this.method;
        copy.methodArgs = this.methodArgs;
        return copy;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        return this.object.callMethod(context, this.method, this.methodArgs, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject inspect19(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        if (runtime.isInspecting(this)) {
            return this.inspect(context, true);
        }
        try {
            runtime.registerInspecting(this);
            IRubyObject iRubyObject = this.inspect(context, false);
            return iRubyObject;
        }
        finally {
            runtime.unregisterInspecting(this);
        }
    }

    private IRubyObject inspect(ThreadContext context, boolean recurse) {
        Ruby runtime = context.getRuntime();
        ByteList bytes2 = new ByteList();
        bytes2.append((byte)35).append((byte)60);
        bytes2.append(this.getMetaClass().getName().getBytes());
        bytes2.append((byte)58).append((byte)32);
        if (recurse) {
            bytes2.append("...>".getBytes());
            return RubyString.newStringNoCopy(runtime, bytes2).taint(context);
        }
        boolean tainted = this.isTaint();
        bytes2.append(RubyObject.inspect(context, this.object).getByteList());
        bytes2.append((byte)58);
        bytes2.append(this.method.getBytes());
        if (this.methodArgs.length > 0) {
            bytes2.append((byte)40);
            for (int i2 = 0; i2 < this.methodArgs.length; ++i2) {
                bytes2.append(RubyObject.inspect(context, this.methodArgs[i2]).getByteList());
                if (i2 < this.methodArgs.length - 1) {
                    bytes2.append((byte)44).append((byte)32);
                } else {
                    bytes2.append((byte)41);
                }
                if (!this.methodArgs[i2].isTaint()) continue;
                tainted = true;
            }
        }
        bytes2.append((byte)62);
        RubyString result2 = RubyString.newStringNoCopy(runtime, bytes2);
        if (tainted) {
            result2.setTaint(true);
        }
        return result2;
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().getEnumerator().callMethod(context, "new", arg2);
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getEnumerator(), "new", arg1, arg2);
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getEnumerator(), "new", arg1, arg2, arg3);
    }

    private static IRubyObject with_index_common(ThreadContext context, IRubyObject self, Block block, String rubyMethodName, IRubyObject arg2) {
        int index2;
        Ruby runtime = context.getRuntime();
        int n = index2 = arg2.isNil() ? 0 : RubyNumeric.num2int(arg2);
        if (!block.isGiven()) {
            return arg2.isNil() ? RubyEnumerator.enumeratorize(runtime, self, rubyMethodName) : RubyEnumerator.enumeratorize(runtime, self, rubyMethodName, runtime.newFixnum(index2));
        }
        return RubyEnumerable.callEach(runtime, context, self, new EachWithIndex(context, block, index2));
    }

    @JRubyMethod
    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerator.with_index_common(context, self, block, "each_with_index", context.getRuntime().getNil());
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public static IRubyObject with_index(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerator.with_index_common(context, self, block, "with_index", context.getRuntime().getNil());
    }

    @JRubyMethod(name={"with_index"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject with_index19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerator.with_index_common(context, self, block, "with_index", context.getRuntime().getNil());
    }

    @JRubyMethod(name={"with_index"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject with_index19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
        return RubyEnumerator.with_index_common(context, self, block, "with_index", arg2);
    }

    private static class EachWithIndex
    implements BlockCallback {
        private int index = 0;
        private final Block block;
        private final Ruby runtime;

        public EachWithIndex(ThreadContext ctx, Block block, int index2) {
            this.block = block;
            this.runtime = ctx.getRuntime();
            this.index = index2;
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
            return this.block.call(context, new IRubyObject[]{this.runtime.newArray(RubyEnumerable.checkArgs(this.runtime, iargs), (IRubyObject)this.runtime.newFixnum(this.index++))});
        }
    }

    public static final class RubyEnumeratorEnumerable {
        public static IRubyObject each_slice(ThreadContext context, IRubyObject self, IRubyObject arg2, final Block block) {
            final int size2 = RubyNumeric.num2int(arg2);
            final Ruby runtime = context.getRuntime();
            if (size2 <= 0) {
                throw runtime.newArgumentError("invalid slice size");
            }
            final RubyArray[] result2 = new RubyArray[]{runtime.newArray(size2)};
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    result2[0].append(largs[0]);
                    if (result2[0].size() == size2) {
                        block.yield(ctx, result2[0]);
                        result2[0] = runtime.newArray(size2);
                    }
                    return runtime.getNil();
                }
            });
            if (result2[0].size() > 0) {
                block.yield(context, result2[0]);
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod(name={"each_slice"})
        public static IRubyObject each_slice19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_slice(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "each_slice", arg2);
        }

        @JRubyMethod(name={"enum_slice"})
        public static IRubyObject enum_slice19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_slice(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "enum_slice", arg2);
        }

        public static IRubyObject each_cons(ThreadContext context, IRubyObject self, IRubyObject arg2, final Block block) {
            final int size2 = (int)RubyNumeric.num2long(arg2);
            final Ruby runtime = context.getRuntime();
            if (size2 <= 0) {
                throw runtime.newArgumentError("invalid size");
            }
            final RubyArray result2 = runtime.newArray(size2);
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (result2.size() == size2) {
                        result2.shift(ctx);
                    }
                    result2.append(largs[0]);
                    if (result2.size() == size2) {
                        block.yield(ctx, result2.aryDup());
                    }
                    return runtime.getNil();
                }
            });
            return runtime.getNil();
        }

        @JRubyMethod(name={"each_cons"})
        public static IRubyObject each_cons19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_cons(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "each_cons", arg2);
        }

        @JRubyMethod(name={"enum_cons"})
        public static IRubyObject enum_cons19(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return block.isGiven() ? RubyEnumeratorEnumerable.each_cons(context, self, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "enum_cons", arg2);
        }

        @JRubyMethod(name={"each_with_object"}, compat=CompatVersion.RUBY1_9)
        public static IRubyObject each_with_object(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return RubyEnumeratorEnumerable.with_object_common(context, self, arg2, block, "each_with_object");
        }

        @JRubyMethod(name={"with_object"}, compat=CompatVersion.RUBY1_9)
        public static IRubyObject with_object(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
            return RubyEnumeratorEnumerable.with_object_common(context, self, arg2, block, "with_object");
        }

        private static IRubyObject with_object_common(ThreadContext context, IRubyObject self, final IRubyObject arg2, final Block block, String rubyMethodName) {
            final Ruby runtime = context.getRuntime();
            if (!block.isGiven()) {
                return RubyEnumerator.enumeratorize(runtime, self, rubyMethodName, arg2);
            }
            RubyEnumerable.callEach(runtime, context, self, Arity.ONE_ARGUMENT, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    block.call(ctx, new IRubyObject[]{runtime.newArray(largs[0], arg2)});
                    return runtime.getNil();
                }
            });
            return arg2;
        }
    }

    public static final class RubyEnumeratorKernel {
        @JRubyMethod(name={"to_enum", "enum_for"})
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self) {
            return RubyEnumerator.newEnumerator(context, self);
        }

        @JRubyMethod(name={"to_enum", "enum_for"})
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject arg2) {
            return RubyEnumerator.newEnumerator(context, self, arg2);
        }

        @JRubyMethod(name={"to_enum", "enum_for"})
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject arg0, IRubyObject arg1) {
            return RubyEnumerator.newEnumerator(context, self, arg0, arg1);
        }

        @JRubyMethod(name={"to_enum", "enum_for"}, optional=1, rest=true)
        public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
            IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
            newArgs[0] = self;
            System.arraycopy(args2, 0, newArgs, 1, args2.length);
            return context.getRuntime().getEnumerator().callMethod(context, "new", newArgs);
        }
    }
}

