/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mozilla;

import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.mozilla.PublicKeyAndChallenge;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class SignedPublicKeyAndChallenge
extends ASN1Encodable {
    private ASN1Sequence spkacSeq;
    private PublicKeyAndChallenge pkac;
    private AlgorithmIdentifier signatureAlgorithm;
    private DERBitString signature;

    private static ASN1Sequence toDERSequence(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            return (ASN1Sequence)aSN1InputStream.readObject();
        }
        catch (Exception exception2) {
            throw new IllegalArgumentException("badly encoded request");
        }
    }

    public SignedPublicKeyAndChallenge(byte[] byArray) {
        this.spkacSeq = SignedPublicKeyAndChallenge.toDERSequence(byArray);
        this.pkac = PublicKeyAndChallenge.getInstance(this.spkacSeq.getObjectAt(0));
        this.signatureAlgorithm = AlgorithmIdentifier.getInstance(this.spkacSeq.getObjectAt(1));
        this.signature = (DERBitString)this.spkacSeq.getObjectAt(2);
    }

    public DERObject toASN1Object() {
        return this.spkacSeq;
    }

    public PublicKeyAndChallenge getPublicKeyAndChallenge() {
        return this.pkac;
    }

    public boolean verify() throws NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        return this.verify(null);
    }

    public boolean verify(String string2) throws NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        Signature signature = null;
        signature = string2 == null ? Signature.getInstance(this.signatureAlgorithm.getObjectId().getId()) : Signature.getInstance(this.signatureAlgorithm.getObjectId().getId(), string2);
        PublicKey publicKey = this.getPublicKey(string2);
        signature.initVerify(publicKey);
        DERBitString dERBitString = new DERBitString(this.pkac);
        signature.update(dERBitString.getBytes());
        return signature.verify(this.signature.getBytes());
    }

    public PublicKey getPublicKey(String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.pkac.getSubjectPublicKeyInfo();
        try {
            DERBitString dERBitString = new DERBitString(subjectPublicKeyInfo);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(dERBitString.getBytes());
            AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithmId();
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmIdentifier.getObjectId().getId(), string2);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("error encoding public key");
        }
    }
}

