/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.AuthAttributesProvider;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableInputStream;
import org.bouncycastle.cms.CMSReadable;
import org.bouncycastle.cms.CMSSecureReadable;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.MacOutputStream;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.util.io.TeeInputStream;

class CMSEnvelopedHelper {
    static final CMSEnvelopedHelper INSTANCE = new CMSEnvelopedHelper();
    private static final Map KEYSIZES = new HashMap();
    private static final Map BASE_CIPHER_NAMES = new HashMap();
    private static final Map CIPHER_ALG_NAMES = new HashMap();
    private static final Map MAC_ALG_NAMES = new HashMap();

    CMSEnvelopedHelper() {
    }

    String getAsymmetricEncryptionAlgName(String string2) {
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(string2)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return string2;
    }

    Cipher createAsymmetricCipher(String string2, String string3) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        String string4 = this.getAsymmetricEncryptionAlgName(string2);
        if (!string4.equals(string2)) {
            try {
                return Cipher.getInstance(string4, string3);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return Cipher.getInstance(string2, string3);
    }

    Cipher createAsymmetricCipher(String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String string3 = this.getAsymmetricEncryptionAlgName(string2);
        if (!string3.equals(string2)) {
            try {
                return this.getCipherInstance(string3, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return this.getCipherInstance(string2, provider);
    }

    KeyGenerator createSymmetricKeyGenerator(String string2, Provider provider) throws NoSuchAlgorithmException {
        try {
            return this.createKeyGenerator(string2, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                String string3 = (String)BASE_CIPHER_NAMES.get(string2);
                if (string3 != null) {
                    return this.createKeyGenerator(string3, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                // empty catch block
            }
            if (provider != null) {
                return this.createSymmetricKeyGenerator(string2, null);
            }
            throw noSuchAlgorithmException;
        }
    }

    AlgorithmParameters createAlgorithmParameters(String string2, Provider provider) throws NoSuchAlgorithmException {
        try {
            return this.createAlgorithmParams(string2, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                String string3 = (String)BASE_CIPHER_NAMES.get(string2);
                if (string3 != null) {
                    return this.createAlgorithmParams(string3, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                // empty catch block
            }
            throw noSuchAlgorithmException;
        }
    }

    AlgorithmParameterGenerator createAlgorithmParameterGenerator(String string2, Provider provider) throws NoSuchAlgorithmException {
        try {
            return this.createAlgorithmParamsGenerator(string2, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                String string3 = (String)BASE_CIPHER_NAMES.get(string2);
                if (string3 != null) {
                    return this.createAlgorithmParamsGenerator(string3, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                // empty catch block
            }
            throw noSuchAlgorithmException;
        }
    }

    String getRFC3211WrapperName(String string2) {
        String string3 = (String)BASE_CIPHER_NAMES.get(string2);
        if (string3 == null) {
            throw new IllegalArgumentException("no name for " + string2);
        }
        return string3 + "RFC3211Wrap";
    }

    int getKeySize(String string2) {
        Integer n = (Integer)KEYSIZES.get(string2);
        if (n == null) {
            throw new IllegalArgumentException("no keysize for " + string2);
        }
        return n;
    }

    private Cipher getCipherInstance(String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider != null) {
            return Cipher.getInstance(string2, provider);
        }
        return Cipher.getInstance(string2);
    }

    private AlgorithmParameters createAlgorithmParams(String string2, Provider provider) throws NoSuchAlgorithmException {
        if (provider != null) {
            return AlgorithmParameters.getInstance(string2, provider);
        }
        return AlgorithmParameters.getInstance(string2);
    }

    private AlgorithmParameterGenerator createAlgorithmParamsGenerator(String string2, Provider provider) throws NoSuchAlgorithmException {
        if (provider != null) {
            return AlgorithmParameterGenerator.getInstance(string2, provider);
        }
        return AlgorithmParameterGenerator.getInstance(string2);
    }

    private KeyGenerator createKeyGenerator(String string2, Provider provider) throws NoSuchAlgorithmException {
        if (provider != null) {
            return KeyGenerator.getInstance(string2, provider);
        }
        return KeyGenerator.getInstance(string2);
    }

    Cipher createSymmetricCipher(String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return this.getCipherInstance(string2, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string3 = (String)CIPHER_ALG_NAMES.get(string2);
            try {
                return this.getCipherInstance(string3, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                if (provider != null) {
                    return this.createSymmetricCipher(string2, null);
                }
                throw noSuchAlgorithmException;
            }
        }
    }

    private Mac createMac(String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider != null) {
            return Mac.getInstance(string2, provider);
        }
        return Mac.getInstance(string2);
    }

    Mac getMac(String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return this.createMac(string2, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string3 = (String)MAC_ALG_NAMES.get(string2);
            try {
                return this.createMac(string3, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                if (provider != null) {
                    return this.getMac(string2, null);
                }
                throw noSuchAlgorithmException;
            }
        }
    }

    AlgorithmParameters getEncryptionAlgorithmParameters(String string2, byte[] byArray, Provider provider) throws CMSException {
        if (byArray == null) {
            return null;
        }
        try {
            AlgorithmParameters algorithmParameters = this.createAlgorithmParameters(string2, provider);
            algorithmParameters.init(byArray, "ASN.1");
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find parameters for algorithm", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't find parse parameters", iOException);
        }
    }

    String getSymmetricCipherName(String string2) {
        String string3 = (String)BASE_CIPHER_NAMES.get(string2);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        return CMSEnvelopedHelper.buildRecipientInformationStore(aSN1Set, algorithmIdentifier, cMSSecureReadable, null);
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        ArrayList arrayList = new ArrayList();
        for (int j = 0; j != aSN1Set.size(); ++j) {
            RecipientInfo recipientInfo = RecipientInfo.getInstance(aSN1Set.getObjectAt(j));
            CMSEnvelopedHelper.readRecipientInfo(arrayList, recipientInfo, algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        }
        return new RecipientInformationStore(arrayList);
    }

    private static void readRecipientInfo(List list2, RecipientInfo recipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        DEREncodable dEREncodable = recipientInfo.getInfo();
        if (dEREncodable instanceof KeyTransRecipientInfo) {
            list2.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)dEREncodable, algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
        } else if (dEREncodable instanceof KEKRecipientInfo) {
            list2.add(new KEKRecipientInformation((KEKRecipientInfo)dEREncodable, algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
        } else if (dEREncodable instanceof KeyAgreeRecipientInfo) {
            KeyAgreeRecipientInformation.readRecipientInfo(list2, (KeyAgreeRecipientInfo)dEREncodable, algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        } else if (dEREncodable instanceof PasswordRecipientInfo) {
            list2.add(new PasswordRecipientInformation((PasswordRecipientInfo)dEREncodable, algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
        }
    }

    static Object execute(JCECallback jCECallback) throws CMSException {
        try {
            return jCECallback.doInJCE();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("MAC algorithm parameter spec invalid.", invalidParameterSpecException);
        }
    }

    static {
        KEYSIZES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, new Integer(192));
        KEYSIZES.put(CMSEnvelopedGenerator.AES128_CBC, new Integer(128));
        KEYSIZES.put(CMSEnvelopedGenerator.AES192_CBC, new Integer(192));
        KEYSIZES.put(CMSEnvelopedGenerator.AES256_CBC, new Integer(256));
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AES");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AES/CBC/PKCS5Padding");
        MAC_ALG_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDEMac");
        MAC_ALG_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AESMac");
    }

    static class CMSAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private Mac mac;
        private CMSReadable readable;

        CMSAuthenticatedSecureReadable(AlgorithmIdentifier algorithmIdentifier, CMSReadable cMSReadable) {
            this.algorithm = algorithmIdentifier;
            this.readable = cMSReadable;
        }

        public AlgorithmIdentifier getAlgorithm() {
            return this.algorithm;
        }

        public Object getCryptoObject() {
            return this.mac;
        }

        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }

        public CMSReadable getReadable(final SecretKey secretKey, final Provider provider) throws CMSException {
            final String string2 = this.algorithm.getObjectId().getId();
            final ASN1Object aSN1Object = (ASN1Object)this.algorithm.getParameters();
            this.mac = (Mac)CMSEnvelopedHelper.execute(new JCECallback(){

                public Object doInJCE() throws CMSException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException {
                    Mac mac = INSTANCE.getMac(string2, provider);
                    if (aSN1Object != null && !(aSN1Object instanceof ASN1Null)) {
                        AlgorithmParameters algorithmParameters = INSTANCE.createAlgorithmParameters(string2, provider);
                        try {
                            algorithmParameters.init(aSN1Object.getEncoded(), "ASN.1");
                        }
                        catch (IOException iOException) {
                            throw new CMSException("error decoding algorithm parameters.", iOException);
                        }
                        mac.init(secretKey, algorithmParameters.getParameterSpec(IvParameterSpec.class));
                    } else {
                        mac.init(secretKey);
                    }
                    return mac;
                }
            });
            try {
                return new CMSProcessableInputStream(new TeeInputStream(this.readable.getInputStream(), new MacOutputStream(this.mac)));
            }
            catch (IOException iOException) {
                throw new CMSException("error reading content.", iOException);
            }
        }
    }

    static class CMSDigestAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private DigestCalculator digestCalculator;
        private CMSReadable readable;

        public CMSDigestAuthenticatedSecureReadable(DigestCalculator digestCalculator, CMSReadable cMSReadable) {
            this.digestCalculator = digestCalculator;
            this.readable = cMSReadable;
        }

        public AlgorithmIdentifier getAlgorithm() {
            return null;
        }

        public Object getCryptoObject() {
            return null;
        }

        public CMSReadable getReadable(SecretKey secretKey, Provider provider) throws CMSException {
            return null;
        }

        public InputStream getInputStream() throws IOException, CMSException {
            return new FilterInputStream(this.readable.getInputStream()){

                public int read() throws IOException {
                    int n = this.in.read();
                    if (n >= 0) {
                        CMSDigestAuthenticatedSecureReadable.this.digestCalculator.getOutputStream().write(n);
                    }
                    return n;
                }

                public int read(byte[] byArray, int n, int n2) throws IOException {
                    int n3 = this.in.read(byArray, n, n2);
                    if (n3 >= 0) {
                        CMSDigestAuthenticatedSecureReadable.this.digestCalculator.getOutputStream().write(byArray, n, n3);
                    }
                    return n3;
                }
            };
        }

        public byte[] getDigest() {
            return this.digestCalculator.getDigest();
        }
    }

    static class CMSEnvelopedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private Cipher cipher;
        private CMSReadable readable;

        CMSEnvelopedSecureReadable(AlgorithmIdentifier algorithmIdentifier, CMSReadable cMSReadable) {
            this.algorithm = algorithmIdentifier;
            this.readable = cMSReadable;
        }

        public AlgorithmIdentifier getAlgorithm() {
            return this.algorithm;
        }

        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }

        public Object getCryptoObject() {
            return this.cipher;
        }

        public CMSReadable getReadable(final SecretKey secretKey, final Provider provider) throws CMSException {
            final String string2 = this.algorithm.getObjectId().getId();
            final ASN1Object aSN1Object = (ASN1Object)this.algorithm.getParameters();
            this.cipher = (Cipher)CMSEnvelopedHelper.execute(new JCECallback(){

                public Object doInJCE() throws CMSException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException {
                    Cipher cipher2 = INSTANCE.createSymmetricCipher(string2, provider);
                    if (aSN1Object != null && !(aSN1Object instanceof ASN1Null)) {
                        try {
                            AlgorithmParameters algorithmParameters = INSTANCE.createAlgorithmParameters(string2, cipher2.getProvider());
                            try {
                                algorithmParameters.init(aSN1Object.getEncoded(), "ASN.1");
                            }
                            catch (IOException iOException) {
                                throw new CMSException("error decoding algorithm parameters.", iOException);
                            }
                            cipher2.init(2, (Key)secretKey, algorithmParameters);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            if (string2.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || string2.equals("1.3.6.1.4.1.188.7.1.1.2") || string2.equals(CMSEnvelopedDataGenerator.AES128_CBC) || string2.equals(CMSEnvelopedDataGenerator.AES192_CBC) || string2.equals(CMSEnvelopedDataGenerator.AES256_CBC)) {
                                cipher2.init(2, (Key)secretKey, new IvParameterSpec(ASN1OctetString.getInstance(aSN1Object).getOctets()));
                            }
                            throw noSuchAlgorithmException;
                        }
                    } else if (string2.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || string2.equals("1.3.6.1.4.1.188.7.1.1.2") || string2.equals("1.2.840.113533.7.66.10")) {
                        cipher2.init(2, (Key)secretKey, new IvParameterSpec(new byte[8]));
                    } else {
                        cipher2.init(2, secretKey);
                    }
                    return cipher2;
                }
            });
            try {
                return new CMSProcessableInputStream(new CipherInputStream(this.readable.getInputStream(), this.cipher));
            }
            catch (IOException iOException) {
                throw new CMSException("error reading content.", iOException);
            }
        }
    }

    static interface JCECallback {
        public Object doInJCE() throws CMSException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException;
    }
}

