/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;

public class CMSAuthenticatedGenerator
extends CMSEnvelopedGenerator {
    protected CMSAttributeTableGenerator authGen;
    protected CMSAttributeTableGenerator unauthGen;

    public CMSAuthenticatedGenerator() {
    }

    public CMSAuthenticatedGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String string2, AlgorithmParameterSpec algorithmParameterSpec, Provider provider) throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException {
        AlgorithmParameters algorithmParameters = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameters(string2, provider);
        algorithmParameters.init(algorithmParameterSpec);
        return this.getAlgorithmIdentifier(string2, algorithmParameters);
    }

    protected AlgorithmParameterSpec generateParameterSpec(String string2, SecretKey secretKey, Provider provider) throws CMSException {
        try {
            if (string2.equals(RC2_CBC)) {
                byte[] byArray = new byte[8];
                this.rand.nextBytes(byArray);
                return new RC2ParameterSpec(secretKey.getEncoded().length * 8, byArray);
            }
            AlgorithmParameterGenerator algorithmParameterGenerator = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameterGenerator(string2, provider);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            return algorithmParameters.getParameterSpec(IvParameterSpec.class);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
    }

    public void setAuthenticatedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.authGen = cMSAttributeTableGenerator;
    }

    public void setUnauthenticatedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.unauthGen = cMSAttributeTableGenerator;
    }

    protected Map getBaseParameters(DERObjectIdentifier dERObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("contentType", dERObjectIdentifier);
        hashMap.put("digestAlgID", algorithmIdentifier);
        hashMap.put("digest", byArray.clone());
        return hashMap;
    }
}

