/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket.example;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class UnixServer {
    public static void main(String[] stringArray) throws IOException {
        File file2 = new File("/tmp/fubar.sock");
        file2.deleteOnExit();
        UnixSocketAddress unixSocketAddress = new UnixSocketAddress(file2);
        UnixServerSocketChannel unixServerSocketChannel = UnixServerSocketChannel.open();
        try {
            AbstractSelector abstractSelector = NativeSelectorProvider.getInstance().openSelector();
            unixServerSocketChannel.configureBlocking(false);
            unixServerSocketChannel.socket().bind(unixSocketAddress);
            unixServerSocketChannel.register(abstractSelector, 16, new ServerActor(unixServerSocketChannel, abstractSelector));
            while (abstractSelector.select() > 0) {
                Set<SelectionKey> set = abstractSelector.selectedKeys();
                for (SelectionKey selectionKey : set) {
                    Actor actor = (Actor)selectionKey.attachment();
                    if (actor.rxready()) continue;
                    selectionKey.cancel();
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(UnixServerSocket.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    static final class ClientActor
    implements Actor {
        private final UnixSocketChannel channel;

        public ClientActor(UnixSocketChannel unixSocketChannel) {
            this.channel = unixSocketChannel;
        }

        @Override
        public final boolean rxready() {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                int n = this.channel.read(byteBuffer);
                UnixSocketAddress unixSocketAddress = this.channel.getRemoteSocketAddress();
                System.out.printf("Read in %d bytes from %s\n", n, unixSocketAddress);
                if (n > 0) {
                    byteBuffer.flip();
                    this.channel.write(byteBuffer);
                    return true;
                }
                if (n < 0) {
                    return false;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
            return true;
        }
    }

    static final class ServerActor
    implements Actor {
        private final UnixServerSocketChannel channel;
        private final Selector selector;

        public ServerActor(UnixServerSocketChannel unixServerSocketChannel, Selector selector) {
            this.channel = unixServerSocketChannel;
            this.selector = selector;
        }

        @Override
        public final boolean rxready() {
            try {
                UnixSocketChannel unixSocketChannel = this.channel.accept();
                unixSocketChannel.configureBlocking(false);
                unixSocketChannel.register(this.selector, 1, new ClientActor(unixSocketChannel));
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    static interface Actor {
        public boolean rxready();
    }
}

