/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.FromNativeContext;
import jnr.posix.BaseNativePOSIX;
import jnr.posix.FileStat;
import jnr.posix.LibCProvider;
import jnr.posix.LinuxFileStat32;
import jnr.posix.LinuxFileStat64;
import jnr.posix.LinuxLibC;
import jnr.posix.LinuxPasswd;
import jnr.posix.NativeTimes;
import jnr.posix.POSIXHandler;
import jnr.posix.Times;
import jnr.posix.util.Platform;

final class LinuxPOSIX
extends BaseNativePOSIX {
    private volatile boolean use_fxstat64 = true;
    private volatile boolean use_lxstat64 = true;
    private volatile boolean use_xstat64 = true;
    private final int statVersion = Platform.IS_32_BIT ? 3 : 0;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg2, FromNativeContext ctx) {
            return arg2 != null ? new LinuxPasswd((Pointer)arg2) : null;
        }
    };

    LinuxPOSIX(String libraryName, LibCProvider libcProvider, POSIXHandler handler) {
        super(libraryName, libcProvider, handler);
    }

    public FileStat allocateStat() {
        if (Platform.IS_32_BIT) {
            return new LinuxFileStat32(this);
        }
        return new LinuxFileStat64(this);
    }

    private final FileStat old_fstat(FileDescriptor fileDescriptor) {
        try {
            return super.fstat(fileDescriptor);
        }
        catch (UnsatisfiedLinkError ex2) {
            this.handler.unimplementedError("fstat");
            return null;
        }
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        if (this.use_fxstat64) {
            try {
                FileStat stat2 = this.allocateStat();
                int fd = this.helper.getfd(fileDescriptor);
                if (((LinuxLibC)this.libc()).__fxstat64(this.statVersion, fd, stat2) < 0) {
                    this.handler.error(Errno.ENOENT, "" + fd);
                }
                return stat2;
            }
            catch (UnsatisfiedLinkError ex) {
                this.use_fxstat64 = false;
                return this.old_fstat(fileDescriptor);
            }
        }
        return this.old_fstat(fileDescriptor);
    }

    private final FileStat old_lstat(String path2) {
        try {
            return super.lstat(path2);
        }
        catch (UnsatisfiedLinkError ex) {
            this.handler.unimplementedError("lstat");
            return null;
        }
    }

    public FileStat lstat(String path2) {
        if (this.use_lxstat64) {
            try {
                FileStat stat2 = this.allocateStat();
                if (((LinuxLibC)this.libc()).__lxstat64(this.statVersion, path2, stat2) < 0) {
                    this.handler.error(Errno.ENOENT, path2);
                }
                return stat2;
            }
            catch (UnsatisfiedLinkError ex) {
                this.use_lxstat64 = false;
                return this.old_lstat(path2);
            }
        }
        return this.old_lstat(path2);
    }

    private final FileStat old_stat(String path2) {
        try {
            return super.stat(path2);
        }
        catch (UnsatisfiedLinkError ex) {
            this.handler.unimplementedError("stat");
            return null;
        }
    }

    public FileStat stat(String path2) {
        if (this.use_xstat64) {
            try {
                FileStat stat2 = this.allocateStat();
                if (((LinuxLibC)this.libc()).__xstat64(this.statVersion, path2, stat2) < 0) {
                    this.handler.error(Errno.ENOENT, path2);
                }
                return stat2;
            }
            catch (UnsatisfiedLinkError ex) {
                this.use_xstat64 = false;
                return this.old_stat(path2);
            }
        }
        return this.old_stat(path2);
    }

    public long sysconf(Sysconf name2) {
        return this.libc().sysconf(name2);
    }

    public Times times() {
        return NativeTimes.times(this);
    }
}

