/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jnr.ffi.Library;
import jnr.ffi.Platform;
import jnr.ffi.provider.jffi.SymbolNotFoundError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLibrary {
    private final String[] libraryNames;
    private volatile List<com.kenai.jffi.Library> nativeLibraries = Collections.EMPTY_LIST;

    NativeLibrary(String name2) {
        this.libraryNames = new String[]{name2};
    }

    NativeLibrary(String ... names2) {
        this.libraryNames = (String[])names2.clone();
    }

    public static String locateLibrary(String libraryName) {
        if (new File(libraryName).isAbsolute()) {
            return libraryName;
        }
        LinkedList<String> searchPath = new LinkedList<String>();
        searchPath.addAll(0, Library.getLibraryPath(libraryName));
        searchPath.addAll(StaticDataHolder.userLibraryPath);
        String path2 = Platform.getNativePlatform().locateLibrary(libraryName, searchPath);
        return path2 != null ? path2 : null;
    }

    private static final List<String> getPropertyPaths(String propName) {
        String value2 = System.getProperty(propName);
        if (value2 != null) {
            String[] paths = value2.split(File.pathSeparator);
            return new ArrayList<String>(Arrays.asList(paths));
        }
        return Collections.emptyList();
    }

    long getSymbolAddress(String name2) {
        for (com.kenai.jffi.Library l : this.getNativeLibraries()) {
            long address2 = l.getSymbolAddress(name2);
            if (address2 == 0L) continue;
            return address2;
        }
        return 0L;
    }

    long findSymbolAddress(String name2) {
        long address2 = this.getSymbolAddress(name2);
        if (address2 == 0L) {
            throw new SymbolNotFoundError(com.kenai.jffi.Library.getLastError());
        }
        return address2;
    }

    private synchronized List<com.kenai.jffi.Library> getNativeLibraries() {
        if (!this.nativeLibraries.isEmpty()) {
            return this.nativeLibraries;
        }
        this.nativeLibraries = this.loadNativeLibraries();
        return this.nativeLibraries;
    }

    private synchronized List<com.kenai.jffi.Library> loadNativeLibraries() {
        ArrayList<com.kenai.jffi.Library> libs = new ArrayList<com.kenai.jffi.Library>();
        for (String libraryName : this.libraryNames) {
            String path2;
            com.kenai.jffi.Library lib = com.kenai.jffi.Library.getCachedInstance(libraryName, 9);
            if (lib == null && libraryName != null && (path2 = NativeLibrary.locateLibrary(libraryName)) != null && !libraryName.equals(path2)) {
                lib = com.kenai.jffi.Library.getCachedInstance(path2, 9);
            }
            if (lib == null) {
                throw new UnsatisfiedLinkError(com.kenai.jffi.Library.getLastError());
            }
            libs.add(lib);
        }
        return Collections.unmodifiableList(libs);
    }

    private static final class StaticDataHolder {
        private static final List<String> userLibraryPath = new CopyOnWriteArrayList<String>();

        private StaticDataHolder() {
        }

        static {
            userLibraryPath.addAll(NativeLibrary.getPropertyPaths("jnr.ffi.library.path"));
            userLibraryPath.addAll(NativeLibrary.getPropertyPaths("jaffl.library.path"));
            userLibraryPath.addAll(NativeLibrary.getPropertyPaths("jna.library.path"));
        }
    }
}

