/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Closure;
import com.kenai.jffi.DirectClosureBuffer;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class ClosurePool {
    private final Set<Magazine> magazines = Collections.synchronizedSet(new HashSet());
    private final ConcurrentLinkedQueue<Handle> freeQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Handle> partialQueue = new ConcurrentLinkedQueue();
    private final CallContext callContext;
    private static final Closure NULL_CLOSURE = new Closure(){

        public void invoke(Closure.Buffer buffer) {
        }
    };

    ClosurePool(CallContext callContext) {
        this.callContext = callContext;
    }

    synchronized void recycle(Magazine magazine) {
        magazine.recycle();
        if (!magazine.isEmpty()) {
            this.useMagazine(magazine);
        } else {
            this.magazines.remove(magazine);
        }
    }

    void recycle(Magazine.Slot slot, MagazineHolder holder) {
        this.partialQueue.add(new Handle(slot, holder));
    }

    private void useMagazine(Magazine m) {
        Magazine.Slot s2;
        ConcurrentLinkedQueue<Handle> q;
        MagazineHolder h = new MagazineHolder(this, m);
        ArrayList<Handle> handles = new ArrayList<Handle>();
        ConcurrentLinkedQueue<Handle> concurrentLinkedQueue = q = m.isFull() ? this.freeQueue : this.partialQueue;
        while ((s2 = m.get()) != null) {
            handles.add(new Handle(s2, h));
        }
        q.addAll(handles);
    }

    public Closure.Handle newClosureHandle(Closure closure) {
        Handle h = this.partialQueue.poll();
        if (h == null) {
            h = this.freeQueue.poll();
        }
        if (h == null) {
            h = this.allocateNewHandle();
        }
        h.slot.proxy.closure = closure;
        return h;
    }

    private Handle allocateNewHandle() {
        Handle h;
        while ((h = this.partialQueue.poll()) == null && (h = this.freeQueue.poll()) == null) {
            Magazine m = new Magazine(this.callContext);
            this.useMagazine(m);
            this.magazines.add(m);
        }
        return h;
    }

    static final class Proxy {
        static final Method METHOD = Proxy.getMethod();
        final CallContext callContext;
        volatile Closure closure = ClosurePool.access$000();

        private static Method getMethod() {
            try {
                return Proxy.class.getDeclaredMethod("invoke", Long.TYPE, Long.TYPE);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }

        Proxy(CallContext callContext) {
            this.callContext = callContext;
        }

        public void invoke(long retvalAddress, long paramAddress) {
            this.closure.invoke(new DirectClosureBuffer(this.callContext, retvalAddress, paramAddress));
        }
    }

    private static final class MagazineHolder {
        final ClosurePool pool;
        final Magazine magazine;

        public MagazineHolder(ClosurePool pool, Magazine magazine) {
            this.pool = pool;
            this.magazine = magazine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pool.recycle(this.magazine);
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class Magazine {
        private static final MemoryIO IO = MemoryIO.getInstance();
        private final Foreign foreign = Foreign.getInstance();
        private final CallContext ctx;
        private final long magazine;
        private final Slot[] slots;
        private int next;
        private int freeCount;

        Magazine(CallContext ctx) {
            Proxy proxy2;
            long h;
            this.ctx = ctx;
            this.magazine = this.foreign.newClosureMagazine(ctx.getAddress(), Proxy.METHOD, false);
            ArrayList<Slot> slots = new ArrayList<Slot>();
            while ((h = this.foreign.closureMagazineGet(this.magazine, proxy2 = new Proxy(ctx))) != 0L) {
                Slot s2 = new Slot(h, proxy2);
                slots.add(s2);
            }
            this.slots = new Slot[slots.size()];
            slots.toArray(this.slots);
            this.next = 0;
            this.freeCount = this.slots.length;
        }

        Slot get() {
            while (this.freeCount > 0 && this.next < this.slots.length) {
                Slot s2 = this.slots[this.next++];
                if (!s2.autorelease) continue;
                --this.freeCount;
                return s2;
            }
            return null;
        }

        boolean isFull() {
            return this.slots.length == this.freeCount;
        }

        boolean isEmpty() {
            return this.freeCount < 1;
        }

        void recycle() {
            for (int i2 = 0; i2 < this.slots.length; ++i2) {
                Slot s2 = this.slots[i2];
                if (!s2.autorelease) continue;
                ++this.freeCount;
                s2.proxy.closure = NULL_CLOSURE;
            }
            this.next = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                boolean release = true;
                for (int i2 = 0; i2 < this.slots.length; ++i2) {
                    if (this.slots[i2].autorelease) continue;
                    release = false;
                    break;
                }
                if (this.magazine != 0L && release) {
                    this.foreign.freeClosureMagazine(this.magazine);
                }
            }
            finally {
                super.finalize();
            }
        }

        static final class Slot {
            final long handle;
            final long codeAddress;
            final Proxy proxy;
            volatile boolean autorelease;

            public Slot(long handle, Proxy proxy2) {
                this.handle = handle;
                this.proxy = proxy2;
                this.autorelease = true;
                this.codeAddress = IO.getAddress(handle);
            }
        }
    }

    private static final class Handle
    implements Closure.Handle {
        final MagazineHolder holder;
        final Magazine.Slot slot;
        private volatile boolean disposed;

        Handle(Magazine.Slot slot, MagazineHolder holder) {
            this.slot = slot;
            this.holder = holder;
        }

        public long getAddress() {
            if (this.disposed) {
                throw new RuntimeException("trying to access disposed closure handle");
            }
            return this.slot.codeAddress;
        }

        public void setAutoRelease(boolean autorelease2) {
            if (!this.disposed) {
                this.slot.autorelease = autorelease2;
            }
        }

        @Deprecated
        public void free() {
            this.dispose();
        }

        public synchronized void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.slot.autorelease = true;
                this.slot.proxy.closure = NULL_CLOSURE;
                this.holder.pool.recycle(this.slot, this.holder);
            }
        }
    }
}

