/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.freebsd;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.FileDescriptor;
import java.io.IOException;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.jna.JnaNativePty;
import org.jline.terminal.impl.jna.freebsd.CLibrary;

public class FreeBsdNativePty
extends JnaNativePty {
    private static final CLibrary C_LIBRARY = (CLibrary)Native.loadLibrary((String)Platform.C_LIBRARY_NAME, CLibrary.class);

    public static FreeBsdNativePty current() throws IOException {
        int slave = 0;
        byte[] buf = new byte[64];
        C_LIBRARY.ttyname_r(slave, buf, buf.length);
        int len = 0;
        while (buf[len] != 0) {
            ++len;
        }
        String name = new String(buf, 0, len);
        return new FreeBsdNativePty(-1, null, slave, FileDescriptor.in, 1, FileDescriptor.out, name);
    }

    public static FreeBsdNativePty open(Attributes attr, Size size) throws IOException {
        int[] master = new int[1];
        int[] slave = new int[1];
        byte[] buf = new byte[64];
        UtilLibrary.INSTANCE.openpty(master, slave, buf, attr != null ? new CLibrary.termios(attr) : null, size != null ? new CLibrary.winsize(size) : null);
        int len = 0;
        while (buf[len] != 0) {
            ++len;
        }
        String name = new String(buf, 0, len);
        return new FreeBsdNativePty(master[0], FreeBsdNativePty.newDescriptor(master[0]), slave[0], FreeBsdNativePty.newDescriptor(slave[0]), name);
    }

    public FreeBsdNativePty(int master, FileDescriptor masterFD, int slave, FileDescriptor slaveFD, String name) {
        super(master, masterFD, slave, slaveFD, name);
    }

    public FreeBsdNativePty(int master, FileDescriptor masterFD, int slave, FileDescriptor slaveFD, int slaveOut, FileDescriptor slaveOutFD, String name) {
        super(master, masterFD, slave, slaveFD, slaveOut, slaveOutFD, name);
    }

    public Attributes getAttr() throws IOException {
        CLibrary.termios termios2 = new CLibrary.termios();
        C_LIBRARY.tcgetattr(this.getSlave(), termios2);
        return termios2.toAttributes();
    }

    protected void doSetAttr(Attributes attr) throws IOException {
        CLibrary.termios termios2 = new CLibrary.termios(attr);
        C_LIBRARY.tcsetattr(this.getSlave(), 0, termios2);
    }

    public Size getSize() throws IOException {
        CLibrary.winsize sz = new CLibrary.winsize();
        C_LIBRARY.ioctl(this.getSlave(), 1074295912L, sz);
        return sz.toSize();
    }

    public void setSize(Size size) throws IOException {
        CLibrary.winsize sz = new CLibrary.winsize(size);
        C_LIBRARY.ioctl(this.getSlave(), -2146929561L, sz);
    }

    public static interface UtilLibrary
    extends Library {
        public static final UtilLibrary INSTANCE = (UtilLibrary)Native.loadLibrary((String)"util", UtilLibrary.class);

        public void openpty(int[] var1, int[] var2, byte[] var3, CLibrary.termios var4, CLibrary.winsize var5) throws LastErrorException;
    }
}

