/*
 * Decompiled with CFR 0.152.
 */
package org.jline.script;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageHelper {
    private static void checkDirectory(File directory, String pckgname, List<Class<?>> classes, boolean classesOnly) throws ClassNotFoundException {
        if (directory.exists() && directory.isDirectory()) {
            String[] files;
            for (String file : files = directory.list()) {
                File tmpDirectory;
                if (file.endsWith(".class")) {
                    try {
                        classes.add(Class.forName(pckgname + '.' + file.substring(0, file.length() - 6)));
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                    continue;
                }
                if (classesOnly || !(tmpDirectory = new File(directory, file)).isDirectory()) continue;
                PackageHelper.checkDirectory(tmpDirectory, pckgname + "." + file, classes, classesOnly);
            }
        }
    }

    private static void checkJarFile(JarURLConnection connection, String pckgname, List<Class<?>> classes, boolean classesOnly) throws IOException, ClassNotFoundException {
        JarFile jarFile = connection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        JarEntry jarEntry = null;
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.contains(".class")) continue;
            name = name.substring(0, name.length() - 6).replace('/', '.');
            if (classesOnly) {
                String namepckg = name.substring(0, name.lastIndexOf("."));
                if (!pckgname.equals(namepckg) || name.contains("$")) continue;
                classes.add(Class.forName(name));
                continue;
            }
            if (!name.contains(pckgname)) continue;
            classes.add(Class.forName(name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> getClassesForPackage(String pckgname) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        boolean classesOnly = pckgname.endsWith(".*");
        if (classesOnly) {
            pckgname = pckgname.substring(0, pckgname.length() - 2);
        }
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/'));
            URL url = null;
            while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        PackageHelper.checkJarFile((JarURLConnection)connection, pckgname, classes, classesOnly);
                        continue;
                    }
                    if (!connection.getClass().getCanonicalName().equals("sun.net.www.protocol.file.FileURLConnection")) throw new ClassNotFoundException(pckgname + " (" + url.getPath() + ") does not appear to be a valid package");
                    try {
                        PackageHelper.checkDirectory(new File(URLDecoder.decode(url.getPath(), "UTF-8")), pckgname, classes, classesOnly);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Unsupported encoding)", ex);
                    }
                }
                catch (IOException ioex) {
                    throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ioex);
                    return classes;
                }
            }
        }
        catch (NullPointerException ex) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Null pointer exception)", ex);
        }
        catch (IOException ioex) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ioex);
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException("NoClassDefFoundError was thrown when trying to get all resources for " + pckgname, e);
        }
    }
}

