/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jline.builtins.Builtins;
import org.jline.builtins.CommandRegistry;
import org.jline.builtins.Completers;
import org.jline.builtins.ConsoleEngine;
import org.jline.builtins.ConsoleEngineImpl;
import org.jline.builtins.Options;
import org.jline.builtins.SystemRegistryImpl;
import org.jline.builtins.Widgets;
import org.jline.keymap.KeyMap;
import org.jline.reader.Completer;
import org.jline.reader.ConfigurationPath;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.ScriptEngine;
import org.jline.reader.UserInterruptException;
import org.jline.reader.Widget;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.script.GroovyEngine;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.InfoCmp;
import org.jline.utils.OSUtils;

public class Repl {
    private static Path workDir() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public static void main(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            parser.setEofOnUnclosedBracket(new DefaultParser.Bracket[]{DefaultParser.Bracket.CURLY, DefaultParser.Bracket.ROUND, DefaultParser.Bracket.SQUARE});
            parser.setEofOnUnclosedQuote(true);
            parser.setEscapeChars(null);
            parser.setRegexCommand("[:]{0,1}[a-zA-Z!]{1,}\\S*");
            Terminal terminal = TerminalBuilder.builder().build();
            File file = new File(Repl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            String root = file.getCanonicalPath().replace("classes", "").replaceAll("\\\\", "/");
            GroovyEngine scriptEngine = new GroovyEngine();
            scriptEngine.put("ROOT", (Object)root);
            ConfigurationPath configPath = new ConfigurationPath(Paths.get(root, new String[0]), Paths.get(root, new String[0]));
            ConsoleEngineImpl consoleEngine = new ConsoleEngineImpl((ScriptEngine)scriptEngine, Repl::workDir, configPath);
            Builtins builtins = new Builtins(Repl::workDir, configPath, arg_0 -> Repl.lambda$main$0((ConsoleEngine)consoleEngine, arg_0));
            MyCommands myCommands = new MyCommands(Repl::workDir);
            SystemRegistryImpl systemRegistry = new SystemRegistryImpl((Parser)parser, terminal, Repl::workDir, configPath);
            systemRegistry.register("command", (CommandRegistry)new SubCommands());
            systemRegistry.setCommandRegistries(new CommandRegistry[]{consoleEngine, builtins, myCommands});
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser((Parser)parser).variable("secondary-prompt-pattern", (Object)"%M%P > ").variable("indentation", (Object)2).variable("list-max", (Object)100).variable("history-file", (Object)Paths.get(root, "history")).option(LineReader.Option.INSERT_BRACKET, true).option(LineReader.Option.EMPTY_WORD_OPTIONS, false).option(LineReader.Option.USE_FORWARD_SLASH, true).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).build();
            if (OSUtils.IS_WINDOWS) {
                reader.setVariable("blink-matching-paren", (Object)0);
            }
            consoleEngine.setLineReader(reader);
            builtins.setLineReader(reader);
            myCommands.setLineReader(reader);
            Widgets.TailTipWidgets ttw = new Widgets.TailTipWidgets(reader, arg_0 -> ((SystemRegistryImpl)systemRegistry).commandDescription(arg_0), 5, Widgets.TailTipWidgets.TipType.COMPLETER);
            ttw.setDescriptionCache(false);
            KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
            keyMap.bind((Object)new Reference("tailtip-toggle"), (CharSequence)KeyMap.alt((String)"s"));
            systemRegistry.initialize(Paths.get(root, "init.jline").toFile());
            consoleEngine.println((Object)(terminal.getName() + ": " + terminal.getType()));
            while (true) {
                try {
                    while (true) {
                        systemRegistry.cleanUp();
                        String line = reader.readLine("groovy-repl> ");
                        line = parser.getCommand(line).startsWith("!") ? line.replaceFirst("!", "! ") : line;
                        Object result = systemRegistry.execute(line);
                        consoleEngine.println(result);
                    }
                }
                catch (UserInterruptException line) {
                    continue;
                }
                catch (EndOfFileException e) {
                }
                catch (Exception e) {
                    systemRegistry.trace(e);
                    continue;
                }
                break;
            }
            systemRegistry.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static /* synthetic */ Widget lambda$main$0(ConsoleEngine consoleEngine, String fun) {
        return new ConsoleEngine.WidgetCreator(consoleEngine, fun);
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }

    private static class MyCommands
    extends VoidCommand
    implements CommandRegistry {
        private LineReader reader;
        private Supplier<Path> workDir;

        public MyCommands(Supplier<Path> workDir) {
            this.workDir = workDir;
            this.commandExecute.put("tput", new Builtins.CommandMethods(this::tput, this::tputCompleter));
            this.commandExecute.put("testkey", new Builtins.CommandMethods(this::testkey, this::defaultCompleter));
            this.commandExecute.put("clear", new Builtins.CommandMethods(this::clear, this::defaultCompleter));
            this.commandExecute.put("!", new Builtins.CommandMethods(this::shell, this::defaultCompleter));
        }

        public void setLineReader(LineReader reader) {
            this.reader = reader;
        }

        private Terminal terminal() {
            return this.reader.getTerminal();
        }

        private void tput(Builtins.CommandInput input) {
            String[] usage = new String[]{"tput -  put terminal capability", "Usage: tput [CAPABILITY]", "  -? --help                       Displays command help"};
            try {
                Options opt = this.parseOptions(usage, input.args());
                List argv = opt.args();
                if (argv.size() == 1) {
                    InfoCmp.Capability vcap = InfoCmp.Capability.byName((String)((String)argv.get(0)));
                    if (vcap != null) {
                        this.terminal().puts(vcap, new Object[0]);
                    } else {
                        this.terminal().writer().println("Unknown capability");
                    }
                } else {
                    this.terminal().writer().println("Usage: tput [CAPABILITY]");
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        private void testkey(Builtins.CommandInput input) {
            String[] usage = new String[]{"testkey -  display the key events", "Usage: testkey", "  -? --help                       Displays command help"};
            try {
                int c;
                this.parseOptions(usage, input.args());
                this.terminal().writer().write("Input the key event(Enter to complete): ");
                this.terminal().writer().flush();
                StringBuilder sb = new StringBuilder();
                while ((c = ((LineReaderImpl)this.reader).readCharacter()) != 10 && c != 13) {
                    sb.append(new String(Character.toChars(c)));
                }
                this.terminal().writer().println(KeyMap.display((String)sb.toString()));
                this.terminal().writer().flush();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        private void clear(Builtins.CommandInput input) {
            String[] usage = new String[]{"clear -  clear terminal", "Usage: clear", "  -? --help                       Displays command help"};
            try {
                this.parseOptions(usage, input.args());
                this.terminal().puts(InfoCmp.Capability.clear_screen, new Object[0]);
                this.terminal().flush();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        private void executeCmnd(List<String> args) throws Exception {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            ArrayList<String> _args = new ArrayList<String>();
            if (OSUtils.IS_WINDOWS) {
                _args.add("cmd.exe");
                _args.add("/c");
            } else {
                _args.add("sh");
                _args.add("-c");
            }
            _args.add(args.stream().collect(Collectors.joining(" ")));
            builder.command(_args);
            builder.directory(this.workDir.get().toFile());
            Process process = builder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
            new Thread(streamGobbler).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new Exception("Failed to execute: " + String.join((CharSequence)" ", args.subList(2, args.size())));
            }
        }

        private void shell(Builtins.CommandInput input) {
            String[] usage = new String[]{"!<command> -  execute shell command", "Usage: !<command>", "  -? --help                       Displays command help"};
            try {
                this.parseOptions(usage, input.args());
            }
            catch (Options.HelpException e) {
                this.exception = e;
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
            ArrayList<String> argv = new ArrayList<String>();
            argv.addAll(Arrays.asList(input.args()));
            if (!argv.isEmpty()) {
                try {
                    this.executeCmnd(argv);
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        }

        private Set<String> capabilities() {
            return InfoCmp.getCapabilitiesByName().keySet();
        }

        private List<Completer> tputCompleter(String command) {
            ArrayList<Completer> completers = new ArrayList<Completer>();
            completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)new StringsCompleter(this::capabilities), this::commandOptions, 1)}));
            return completers;
        }
    }

    private static class SubCommands
    extends ObjectCommand
    implements CommandRegistry {
        public SubCommands() {
            this.commandExecute.put("cmdKo1", new Builtins.CommandMethods(this::cmd1, this::defaultCompleter));
            this.commandExecute.put("cmdKo2", new Builtins.CommandMethods(this::cmd2, this::defaultCompleter));
            this.commandExecute.put("cmdOk", new Builtins.CommandMethods(this::cmd3, this::defaultCompleter));
        }

        private Object cmd1(Builtins.CommandInput input) {
            String[] usage = new String[]{"cmdKo1 -  parse input.args, return opt.argObjects[0]", "          works only with string parameters", "Usage: cmdKo1 [OBJECT]", "  -? --help                       Displays command help"};
            Object out = null;
            try {
                Options opt = this.parseOptions(usage, input.args());
                List xargs = opt.argObjects();
                out = xargs.size() > 0 ? xargs.get(0) : null;
            }
            catch (Exception e) {
                this.exception = e;
            }
            return out;
        }

        private Object cmd2(Builtins.CommandInput input) {
            String[] usage = new String[]{"cmdKo2 -  parse input.xargs, return opt.args[0]", "          works only with string parameters", "Usage: cmdKo2 [OBJECT]", "  -? --help                       Displays command help"};
            Object out = null;
            try {
                Options opt = this.parseOptions(usage, input.xargs());
                List args = opt.args();
                out = args.size() > 0 ? args.get(0) : null;
            }
            catch (Exception e) {
                this.exception = e;
            }
            return out;
        }

        private Object cmd3(Builtins.CommandInput input) {
            String[] usage = new String[]{"cmdOk -  parse input.xargs, return opt.argObjects[0]", "         manage correctly object parameters", "Usage: cmdOk [OBJECT]", "  -? --help                       Displays command help"};
            Object out = null;
            try {
                Options opt = this.parseOptions(usage, input.xargs());
                List xargs = opt.argObjects();
                out = xargs.size() > 0 ? xargs.get(0) : null;
            }
            catch (Exception e) {
                this.exception = e;
            }
            return out;
        }
    }

    private static abstract class AbstractCommandRegistry {
        protected final Map<String, Builtins.CommandMethods> commandExecute = new HashMap<String, Builtins.CommandMethods>();
        protected Exception exception;
        protected Map<String, String> aliasCommand = new HashMap<String, String>();

        public Set<String> commandNames() {
            return this.commandExecute.keySet();
        }

        public Map<String, String> commandAliases() {
            return this.aliasCommand;
        }

        public boolean hasCommand(String command) {
            return this.commandExecute.containsKey(command) || this.aliasCommand.containsKey(command);
        }

        protected String command(String name) {
            if (this.commandExecute.containsKey(name)) {
                return name;
            }
            if (this.aliasCommand.containsKey(name)) {
                return this.aliasCommand.get(name);
            }
            return null;
        }

        public Completers.SystemCompleter compileCompleters() {
            Completers.SystemCompleter out = new Completers.SystemCompleter();
            for (String c : this.commandExecute.keySet()) {
                out.add(c, (List)this.commandExecute.get(c).compileCompleter().apply(c));
            }
            out.addAliases(this.aliasCommand);
            return out;
        }

        public Options parseOptions(String[] usage, Object[] args) throws Options.HelpException {
            Options opt = Options.compile((String[])usage).parse(args);
            if (opt.isSet("help")) {
                throw new Options.HelpException(opt.usage());
            }
            return opt;
        }
    }

    private static abstract class VoidCommand
    extends AbstractCommandRegistry {
        public Object execute(CommandRegistry.CommandSession session, String command, String[] args) throws Exception {
            this.exception = null;
            ((Builtins.CommandMethods)this.commandExecute.get(this.command(command))).execute().accept(new Builtins.CommandInput(command, (Object[])args, session));
            if (this.exception != null) {
                throw this.exception;
            }
            return null;
        }

        protected List<Completers.OptDesc> commandOptions(String command) {
            try {
                this.execute(new CommandRegistry.CommandSession(), command, new String[]{"--help"});
            }
            catch (Options.HelpException e) {
                return Builtins.compileCommandOptions((String)e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        protected List<Completer> defaultCompleter(String command) {
            ArrayList<Completer> completers = new ArrayList<Completer>();
            completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)}));
            return completers;
        }
    }

    private static abstract class ObjectCommand
    extends AbstractCommandRegistry {
        public Object invoke(CommandRegistry.CommandSession session, String command, Object ... args) throws Exception {
            this.exception = null;
            Object out = ((Builtins.CommandMethods)this.commandExecute.get(this.command(command))).executeFunction().apply(new Builtins.CommandInput(command, args, session));
            if (this.exception != null) {
                throw this.exception;
            }
            return out;
        }

        protected List<Completers.OptDesc> commandOptions(String command) {
            try {
                this.invoke(new CommandRegistry.CommandSession(), command, "--help");
            }
            catch (Options.HelpException e) {
                return Builtins.compileCommandOptions((String)e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        protected List<Completer> defaultCompleter(String command) {
            ArrayList<Completer> completers = new ArrayList<Completer>();
            completers.add((Completer)new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)}));
            return completers;
        }
    }
}

