/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.sonatype.guice.bean.locators.LazyBeanEntry;
import org.sonatype.guice.bean.locators.QualifyingStrategy;
import org.sonatype.guice.bean.locators.RankedBindings;
import org.sonatype.guice.bean.locators.RankedList;
import org.sonatype.inject.BeanEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocatedBeans<Q extends Annotation, T>
implements Iterable<BeanEntry<Q, T>> {
    final Key<T> key;
    final RankedBindings<T> bindings;
    final QualifyingStrategy strategy;
    Map<Binding<T>, BeanEntry<Q, T>> beanCache;

    LocatedBeans(Key<T> key, RankedBindings<T> bindings) {
        this.key = key;
        this.bindings = bindings;
        this.strategy = QualifyingStrategy.selectFor(key);
        bindings.linkToBeans(this);
    }

    @Override
    public synchronized Iterator<BeanEntry<Q, T>> iterator() {
        return new Itr(null != this.beanCache ? new IdentityHashMap<Binding<T>, BeanEntry<Q, T>>(this.beanCache) : Collections.EMPTY_MAP);
    }

    synchronized void retainAll(RankedList<Binding<T>> activeBindings) {
        if (null != this.beanCache) {
            for (Binding<T> b : new ArrayList<Binding<T>>(this.beanCache.keySet())) {
                if (activeBindings.indexOfThis(b) >= 0) continue;
                this.beanCache.remove(b);
            }
        }
    }

    synchronized BeanEntry<Q, T> cacheBean(Q qualifier, Binding<T> binding, int rank) {
        BeanEntry<Q, T> bean;
        if (null == this.beanCache) {
            this.beanCache = new IdentityHashMap<Binding<T>, BeanEntry<Q, T>>();
        }
        if (null == (bean = this.beanCache.get(binding))) {
            bean = new LazyBeanEntry<Q, T>(qualifier, binding, rank);
            this.beanCache.put(binding, bean);
        }
        return bean;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Itr
    implements Iterator<BeanEntry<Q, T>> {
        private final RankedBindings.Itr itr;
        private final Map<Binding<T>, BeanEntry<Q, T>> readCache;
        private BeanEntry<Q, T> nextBean;

        Itr(Map<Binding<T>, BeanEntry<Q, T>> readCache) {
            this.itr = LocatedBeans.this.bindings.iterator();
            this.readCache = readCache;
        }

        @Override
        public boolean hasNext() {
            if (null != this.nextBean) {
                return true;
            }
            while (this.itr.hasNext()) {
                Object binding = this.itr.next();
                this.nextBean = this.readCache.get(binding);
                if (null != this.nextBean) {
                    return true;
                }
                Annotation qualifier = LocatedBeans.this.strategy.qualifies(LocatedBeans.this.key, (Binding<?>)binding);
                if (null == qualifier) continue;
                this.nextBean = LocatedBeans.this.cacheBean(qualifier, binding, this.itr.rank());
                return true;
            }
            return false;
        }

        @Override
        public BeanEntry<Q, T> next() {
            if (this.hasNext()) {
                BeanEntry bean = this.nextBean;
                this.nextBean = null;
                return bean;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

