/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.artifact;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArtifact
implements Artifact {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}.[0-9]{6}-[0-9]+)$");

    protected static boolean isSnapshot(String version) {
        return version.endsWith(SNAPSHOT) || SNAPSHOT_TIMESTAMP.matcher(version).matches();
    }

    protected static String toBaseVersion(String version) {
        Matcher m;
        String baseVersion = version == null ? version : (version.startsWith("[") || version.startsWith("(") ? version : ((m = SNAPSHOT_TIMESTAMP.matcher(version)).matches() ? (m.group(1) != null ? m.group(1) + SNAPSHOT : SNAPSHOT) : version));
        return baseVersion;
    }

    @Override
    public Artifact setVersion(String version) {
        if (this.getVersion().equals(version)) {
            return this;
        }
        return new DefaultArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), version, this.getFile(), this.getProperties());
    }

    @Override
    public Artifact setFile(File file) {
        if (AbstractArtifact.eq(this.getFile(), file)) {
            return this;
        }
        return new DefaultArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), this.getVersion(), file, this.getProperties());
    }

    @Override
    public Artifact setProperties(Map<String, String> properties) {
        if (((Object)this.getProperties()).equals(properties)) {
            return this;
        }
        return new DefaultArtifact(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension(), this.getVersion(), properties, this.getFile());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.getGroupId());
        buffer.append(':').append(this.getArtifactId());
        buffer.append(':').append(this.getExtension());
        if (this.getClassifier().length() > 0) {
            buffer.append(':').append(this.getClassifier());
        }
        buffer.append(':').append(this.getVersion());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact that = (Artifact)obj;
        return this.getArtifactId().equals(that.getArtifactId()) && this.getGroupId().equals(that.getGroupId()) && this.getVersion().equals(that.getVersion()) && this.getExtension().equals(that.getExtension()) && this.getClassifier().equals(that.getClassifier()) && AbstractArtifact.eq(this.getFile(), that.getFile()) && ((Object)this.getProperties()).equals(that.getProperties());
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getGroupId().hashCode();
        hash = hash * 31 + this.getArtifactId().hashCode();
        hash = hash * 31 + this.getExtension().hashCode();
        hash = hash * 31 + this.getClassifier().hashCode();
        hash = hash * 31 + this.getVersion().hashCode();
        hash = hash * 31 + AbstractArtifact.hash(this.getFile());
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

