/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.user;

import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.user.UserCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationInfo {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationInfo.class);
    String user;
    String ticket;
    UserCredentials userCredentials;
    public static final AuthenticationInfo ANONYMOUS = new AuthenticationInfo("anonymous", "anonymous");

    public AuthenticationInfo() {
    }

    public AuthenticationInfo(String user) {
        this.user = user;
    }

    public AuthenticationInfo(String user, String ticket) {
        this.user = user;
        this.ticket = ticket;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public UserCredentials getUserCredentials() {
        return this.userCredentials;
    }

    public void setUserCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
    }

    public static boolean isAnonymous(AuthenticationInfo subject) {
        if (subject == null) {
            LOG.warn("Subject is null, assuming anonymous. Not recommended to use subject as null except in tests");
            return true;
        }
        return subject.isAnonymous();
    }

    public boolean isAnonymous() {
        return ANONYMOUS.equals(this) || "anonymous".equalsIgnoreCase(this.getUser()) || StringUtils.isEmpty((String)this.getUser());
    }
}

