/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark.dep;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.spark.SparkContext;
import org.apache.zeppelin.dep.AbstractDependencyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.DependencyFilterUtils;
import org.sonatype.aether.util.filter.PatternExclusionsDependencyFilter;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.Path;
import scala.tools.nsc.Global;
import scala.tools.nsc.backend.JavaPlatform;
import scala.tools.nsc.util.ClassPath;
import scala.tools.nsc.util.MergedClassPath;
import scala.util.Properties;

public class SparkDependencyResolver
extends AbstractDependencyResolver {
    Logger logger = LoggerFactory.getLogger(SparkDependencyResolver.class);
    private Global global;
    private ClassLoader runtimeClassLoader;
    private SparkContext sc;
    private final String[] exclusions = new String[]{"org.scala-lang:scala-library", "org.scala-lang:scala-compiler", "org.scala-lang:scala-reflect", "org.scala-lang:scalap", "org.apache.zeppelin:zeppelin-zengine", "org.apache.zeppelin:zeppelin-spark", "org.apache.zeppelin:zeppelin-server"};

    public SparkDependencyResolver(Global global, ClassLoader runtimeClassLoader, SparkContext sc, String localRepoPath, String additionalRemoteRepository) {
        super(localRepoPath);
        this.global = global;
        this.runtimeClassLoader = runtimeClassLoader;
        this.sc = sc;
        this.addRepoFromProperty(additionalRemoteRepository);
    }

    private void addRepoFromProperty(String listOfRepo) {
        if (listOfRepo != null) {
            String[] repos;
            for (String repo : repos = listOfRepo.split(";")) {
                String[] parts = repo.split(",");
                if (parts.length != 3) continue;
                String id = parts[0].trim();
                String url = parts[1].trim();
                boolean isSnapshot = Boolean.parseBoolean(parts[2].trim());
                if (id.length() <= 1 || url.length() <= 1) continue;
                this.addRepo(id, url, isSnapshot);
            }
        }
    }

    private void updateCompilerClassPath(URL[] urls) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method[] methods;
        JavaPlatform platform = this.global.platform();
        MergedClassPath<AbstractFile> newClassPath = this.mergeUrlsIntoClassPath(platform, urls);
        for (Method m : methods = platform.getClass().getMethods()) {
            if (!m.getName().endsWith("currentClassPath_$eq")) continue;
            m.invoke((Object)platform, new Some(newClassPath));
            break;
        }
        LinkedList<String> classPaths = new LinkedList<String>();
        for (URL url : urls) {
            classPaths.add(url.getPath());
        }
        this.global.invalidateClassPathEntries((Seq)JavaConversions.asScalaBuffer(classPaths).toList());
    }

    private void updateRuntimeClassPath_1_x(URL[] urls) throws SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Method addURL = this.runtimeClassLoader.getClass().getDeclaredMethod("addURL", URL.class);
        addURL.setAccessible(true);
        for (URL url : urls) {
            addURL.invoke((Object)this.runtimeClassLoader, url);
        }
    }

    private void updateRuntimeClassPath_2_x(URL[] urls) throws SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Method addURL = this.runtimeClassLoader.getClass().getDeclaredMethod("addNewUrl", URL.class);
        addURL.setAccessible(true);
        for (URL url : urls) {
            addURL.invoke((Object)this.runtimeClassLoader, url);
        }
    }

    private MergedClassPath<AbstractFile> mergeUrlsIntoClassPath(JavaPlatform platform, URL[] urls) {
        IndexedSeq entries = ((MergedClassPath)platform.classPath()).entries();
        LinkedList<Object> cp = new LinkedList<Object>();
        for (int i = 0; i < entries.size(); ++i) {
            cp.add(entries.apply(i));
        }
        for (URL url : urls) {
            File f;
            AbstractFile file = "file".equals(url.getProtocol()) ? ((f = new File(url.getPath())).isDirectory() ? AbstractFile.getDirectory((Path)scala.reflect.io.File.jfile2path((File)f)) : AbstractFile.getFile((Path)scala.reflect.io.File.jfile2path((File)f))) : AbstractFile.getURL((URL)url);
            ClassPath newcp = (ClassPath)platform.classPath().context().newClassPath(file);
            if (cp.contains(newcp)) continue;
            cp.add(newcp);
        }
        return new MergedClassPath((IndexedSeq)JavaConversions.asScalaBuffer(cp).toIndexedSeq(), platform.classPath().context());
    }

    public List<String> load(String artifact, boolean addSparkContext) throws Exception {
        return this.load(artifact, new LinkedList<String>(), addSparkContext);
    }

    public List<String> load(String artifact, Collection<String> excludes, boolean addSparkContext) throws Exception {
        if (StringUtils.isBlank((String)artifact)) {
            throw new RuntimeException("Invalid artifact to load");
        }
        int numSplits = artifact.split(":").length;
        if (numSplits >= 3 && numSplits <= 6) {
            return this.loadFromMvn(artifact, excludes, addSparkContext);
        }
        this.loadFromFs(artifact, addSparkContext);
        LinkedList<String> libs = new LinkedList<String>();
        libs.add(artifact);
        return libs;
    }

    private void loadFromFs(String artifact, boolean addSparkContext) throws Exception {
        File jarFile = new File(artifact);
        new Global.Run(this.global);
        if (this.sc.version().startsWith("1.1")) {
            this.updateRuntimeClassPath_1_x(new URL[]{jarFile.toURI().toURL()});
        } else {
            this.updateRuntimeClassPath_2_x(new URL[]{jarFile.toURI().toURL()});
        }
        if (addSparkContext) {
            this.sc.addJar(jarFile.getAbsolutePath());
        }
    }

    private List<String> loadFromMvn(String artifact, Collection<String> excludes, boolean addSparkContext) throws Exception {
        LinkedList<String> loadedLibs = new LinkedList<String>();
        LinkedList<String> allExclusions = new LinkedList<String>();
        allExclusions.addAll(excludes);
        allExclusions.addAll(Arrays.asList(this.exclusions));
        List<ArtifactResult> listOfArtifact = this.getArtifactsWithDep(artifact, allExclusions);
        Iterator<ArtifactResult> it = listOfArtifact.iterator();
        block0: while (it.hasNext()) {
            Artifact a = it.next().getArtifact();
            String gav = a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion();
            for (String exclude : allExclusions) {
                if (!gav.startsWith(exclude)) continue;
                it.remove();
                continue block0;
            }
        }
        LinkedList<URL> newClassPathList = new LinkedList<URL>();
        LinkedList<File> files = new LinkedList<File>();
        for (ArtifactResult artifactResult : listOfArtifact) {
            this.logger.info("Load " + artifactResult.getArtifact().getGroupId() + ":" + artifactResult.getArtifact().getArtifactId() + ":" + artifactResult.getArtifact().getVersion());
            newClassPathList.add(artifactResult.getArtifact().getFile().toURI().toURL());
            files.add(artifactResult.getArtifact().getFile());
            loadedLibs.add(artifactResult.getArtifact().getGroupId() + ":" + artifactResult.getArtifact().getArtifactId() + ":" + artifactResult.getArtifact().getVersion());
        }
        new Global.Run(this.global);
        if (this.sc.version().startsWith("1.1")) {
            this.updateRuntimeClassPath_1_x(newClassPathList.toArray(new URL[0]));
        } else {
            this.updateRuntimeClassPath_2_x(newClassPathList.toArray(new URL[0]));
        }
        this.updateCompilerClassPath(newClassPathList.toArray(new URL[0]));
        if (addSparkContext) {
            for (File f : files) {
                this.sc.addJar(f.getAbsolutePath());
            }
        }
        return loadedLibs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArtifactResult> getArtifactsWithDep(String dependency, Collection<String> excludes) throws Exception {
        DefaultArtifact artifact = new DefaultArtifact(SparkDependencyResolver.inferScalaVersion(dependency));
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter("compile");
        PatternExclusionsDependencyFilter exclusionFilter = new PatternExclusionsDependencyFilter(SparkDependencyResolver.inferScalaVersion(excludes));
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "compile"));
        List list = this.repos;
        synchronized (list) {
            for (RemoteRepository repo : this.repos) {
                collectRequest.addRepository(repo);
            }
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.andFilter(exclusionFilter, classpathFilter));
        return this.system.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
    }

    public static Collection<String> inferScalaVersion(Collection<String> artifact) {
        LinkedList<String> list = new LinkedList<String>();
        for (String a : artifact) {
            list.add(SparkDependencyResolver.inferScalaVersion(a));
        }
        return list;
    }

    public static String inferScalaVersion(String artifact) {
        int pos = artifact.indexOf(":");
        if (pos < 0 || pos + 2 >= artifact.length()) {
            return artifact;
        }
        if (':' == artifact.charAt(pos + 1)) {
            String restOfthem = "";
            String versionSep = ":";
            String groupId = artifact.substring(0, pos);
            int nextPos = artifact.indexOf(":", pos + 2);
            if (nextPos < 0) {
                if (artifact.charAt(artifact.length() - 1) == '*') {
                    nextPos = artifact.length() - 1;
                    versionSep = "";
                    restOfthem = "*";
                } else {
                    versionSep = "";
                    nextPos = artifact.length();
                }
            }
            String artifactId = artifact.substring(pos + 2, nextPos);
            if (nextPos < artifact.length() && !restOfthem.equals("*")) {
                restOfthem = artifact.substring(nextPos + 1);
            }
            String[] version = Properties.versionNumberString().split("[.]");
            String scalaVersion = version[0] + "." + version[1];
            return groupId + ":" + artifactId + "_" + scalaVersion + versionSep + restOfthem;
        }
        return artifact;
    }
}

