/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark.dep;

import java.io.File;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.dep.Booter;
import org.apache.zeppelin.dep.Repository;
import org.apache.zeppelin.spark.dep.SparkDependencyResolver;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.DependencyFilterUtils;
import org.sonatype.aether.util.filter.PatternExclusionsDependencyFilter;

public class SparkDependencyContext {
    List<org.apache.zeppelin.dep.Dependency> dependencies = new LinkedList<org.apache.zeppelin.dep.Dependency>();
    List<Repository> repositories = new LinkedList<Repository>();
    List<File> files = new LinkedList<File>();
    List<File> filesDist = new LinkedList<File>();
    private RepositorySystem system = Booter.newRepositorySystem();
    private RepositorySystemSession session;
    private RemoteRepository mavenCentral = Booter.newCentralRepository();
    private RemoteRepository mavenLocal = Booter.newLocalRepository();
    private List<RemoteRepository> additionalRepos = new LinkedList<RemoteRepository>();

    public SparkDependencyContext(String localRepoPath, String additionalRemoteRepository) {
        this.session = Booter.newRepositorySystemSession(this.system, localRepoPath);
        this.addRepoFromProperty(additionalRemoteRepository);
    }

    public org.apache.zeppelin.dep.Dependency load(String lib) {
        org.apache.zeppelin.dep.Dependency dep = new org.apache.zeppelin.dep.Dependency(lib);
        if (this.dependencies.contains(dep)) {
            this.dependencies.remove(dep);
        }
        this.dependencies.add(dep);
        return dep;
    }

    public Repository addRepo(String name) {
        Repository rep = new Repository(name);
        this.repositories.add(rep);
        return rep;
    }

    public void reset() {
        this.dependencies = new LinkedList<org.apache.zeppelin.dep.Dependency>();
        this.repositories = new LinkedList<Repository>();
        this.files = new LinkedList<File>();
        this.filesDist = new LinkedList<File>();
    }

    private void addRepoFromProperty(String listOfRepo) {
        if (listOfRepo != null) {
            String[] repos;
            for (String repo : repos = listOfRepo.split(";")) {
                String[] parts = repo.split(",");
                if (parts.length != 3) continue;
                String id = parts[0].trim();
                String url = parts[1].trim();
                boolean isSnapshot = Boolean.parseBoolean(parts[2].trim());
                if (id.length() <= 1 || url.length() <= 1) continue;
                RemoteRepository rr = new RemoteRepository(id, "default", url);
                rr.setPolicy(isSnapshot, null);
                this.additionalRepos.add(rr);
            }
        }
    }

    public List<File> fetch() throws MalformedURLException, DependencyResolutionException, ArtifactResolutionException {
        for (org.apache.zeppelin.dep.Dependency dep : this.dependencies) {
            if (!dep.isLocalFsArtifact()) {
                List<ArtifactResult> artifacts = this.fetchArtifactWithDep(dep);
                for (ArtifactResult artifact : artifacts) {
                    if (dep.isDist()) {
                        this.filesDist.add(artifact.getArtifact().getFile());
                    }
                    this.files.add(artifact.getArtifact().getFile());
                }
                continue;
            }
            if (dep.isDist()) {
                this.filesDist.add(new File(dep.getGroupArtifactVersion()));
            }
            this.files.add(new File(dep.getGroupArtifactVersion()));
        }
        return this.files;
    }

    private List<ArtifactResult> fetchArtifactWithDep(org.apache.zeppelin.dep.Dependency dep) throws DependencyResolutionException, ArtifactResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(SparkDependencyResolver.inferScalaVersion(dep.getGroupArtifactVersion()));
        DependencyFilter classpathFlter = DependencyFilterUtils.classpathFilter("compile");
        PatternExclusionsDependencyFilter exclusionFilter = new PatternExclusionsDependencyFilter(SparkDependencyResolver.inferScalaVersion(dep.getExclusions()));
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "compile"));
        collectRequest.addRepository(this.mavenCentral);
        collectRequest.addRepository(this.mavenLocal);
        for (RemoteRepository remoteRepository : this.additionalRepos) {
            collectRequest.addRepository(remoteRepository);
        }
        for (Repository repository : this.repositories) {
            RemoteRepository rr = new RemoteRepository(repository.getId(), "default", repository.getUrl());
            rr.setPolicy(repository.isSnapshot(), null);
            Authentication auth = repository.getAuthentication();
            if (auth != null) {
                rr.setAuthentication(auth);
            }
            collectRequest.addRepository(rr);
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.andFilter(exclusionFilter, classpathFlter));
        return this.system.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
    }

    public List<File> getFiles() {
        return this.files;
    }

    public List<File> getFilesDist() {
        return this.filesDist;
    }
}

