/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.util.List;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.spark.RDisplay;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.safety.Whitelist;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class ZeppelinRDisplay$ {
    public static final ZeppelinRDisplay$ MODULE$;
    private final Regex pattern;

    static {
        new ZeppelinRDisplay$();
    }

    public Regex pattern() {
        return this.pattern;
    }

    public RDisplay render(String html, String imageWidth) {
        Document document = Jsoup.parse(html);
        document.outputSettings().prettyPrint(false);
        Element body = document.body();
        if (body.getElementsByTag("p").isEmpty()) {
            return new RDisplay(body.html(), InterpreterResult.Type.HTML, InterpreterResult.Code.SUCCESS);
        }
        String bodyHtml = body.html();
        if (bodyHtml.contains("<img") || bodyHtml.contains("<script") || bodyHtml.contains("%html ") || bodyHtml.contains("%table ") || bodyHtml.contains("%img ")) {
            if (bodyHtml.contains("%table")) {
                return this.tableDisplay(body);
            }
            if (bodyHtml.contains("%img")) {
                return this.imgDisplay(body);
            }
            return this.htmlDisplay(body, imageWidth);
        }
        return this.textDisplay(body);
    }

    private RDisplay textDisplay(Element body) {
        String text = Jsoup.clean(body.html(), "", Whitelist.none(), new Document.OutputSettings().prettyPrint(false));
        return new RDisplay(text, InterpreterResult.Type.TEXT, InterpreterResult.Code.SUCCESS);
    }

    private RDisplay tableDisplay(Element body) {
        String p = body.getElementsByTag("p").first().html().replace("\u201c%table ", "").replace("\u201d", "");
        String r = (String)this.pattern().findFirstIn((CharSequence)p).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String table = p.replace(r, "").replace("\\t", "\t").replace("\\n", "\n");
        return new RDisplay(table, InterpreterResult.Type.TABLE, InterpreterResult.Code.SUCCESS);
    }

    private RDisplay imgDisplay(Element body) {
        String p = body.getElementsByTag("p").first().html().replace("\u201c%img ", "").replace("\u201d", "");
        String r = (String)this.pattern().findFirstIn((CharSequence)p).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String img = p.replace(r, "");
        return new RDisplay(img, InterpreterResult.Type.IMG, InterpreterResult.Code.SUCCESS);
    }

    private RDisplay htmlDisplay(Element body, String imageWidth) {
        ObjectRef div = ObjectRef.create((Object)new String());
        JavaConversions$.MODULE$.asScalaBuffer((List)body.children()).foreach((Function1)new Serializable(div){
            public static final long serialVersionUID = 0L;
            private final ObjectRef div$1;

            public final void apply(Element element) {
                String eHtml = element.html();
                String eOuterHtml = element.outerHtml();
                eOuterHtml = eOuterHtml.replace("\u201c%html ", "").replace("\u201d", "");
                String r = (String)ZeppelinRDisplay$.MODULE$.pattern().findFirstIn((CharSequence)eHtml).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                this.div$1.elem = new StringBuilder().append((Object)((String)this.div$1.elem)).append((Object)eOuterHtml.replace(r, "")).toString();
            }
            {
                this.div$1 = div$1;
            }
        });
        String content = ((String)div.elem).replaceAll("src=\"//", "src=\"http://").replaceAll("href=\"//", "href=\"http://");
        body.html(content);
        JavaConversions$.MODULE$.asScalaBuffer((List)body.getElementsByTag("img")).foreach((Function1)new Serializable(imageWidth){
            public static final long serialVersionUID = 0L;
            private final String imageWidth$1;

            public final Element apply(Element image) {
                return image.attr("width", this.imageWidth$1);
            }
            {
                this.imageWidth$1 = imageWidth$1;
            }
        });
        return new RDisplay(body.html(), InterpreterResult.Type.HTML, InterpreterResult.Code.SUCCESS);
    }

    private ZeppelinRDisplay$() {
        MODULE$ = this;
        this.pattern = new Regex("^ *\\[\\d*\\] ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }
}

