/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.util.InterpreterOutputStream;
import org.apache.zeppelin.spark.SparkVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinR
implements ExecuteResultHandler {
    Logger logger = LoggerFactory.getLogger(ZeppelinR.class);
    private final String rCmdPath;
    private final SparkVersion sparkVersion;
    private DefaultExecutor executor;
    private InterpreterOutputStream outputStream;
    private PipedOutputStream input;
    private final String scriptPath;
    private final String libPath;
    static Map<Integer, ZeppelinR> zeppelinR = Collections.synchronizedMap(new HashMap());
    private InterpreterOutput initialOutput;
    private final int port;
    private boolean rScriptRunning;
    boolean rScriptInitialized = false;
    Integer rScriptInitializeNotifier = new Integer(0);
    Request rRequestObject = null;
    Integer rRequestNotifier = new Integer(0);
    Object rResponseValue = null;
    boolean rResponseError = false;
    Integer rResponseNotifier = new Integer(0);

    public ZeppelinR(String rCmdPath, String libPath, int sparkRBackendPort, SparkVersion sparkVersion) {
        this.rCmdPath = rCmdPath;
        this.libPath = libPath;
        this.sparkVersion = sparkVersion;
        this.port = sparkRBackendPort;
        try {
            File scriptFile = File.createTempFile("zeppelin_sparkr-", ".R");
            this.scriptPath = scriptFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new InterpreterException(e);
        }
    }

    public void open() throws IOException {
        this.createRScript();
        zeppelinR.put(this.hashCode(), this);
        CommandLine cmd = CommandLine.parse(this.rCmdPath);
        cmd.addArgument("--no-save");
        cmd.addArgument("--no-restore");
        cmd.addArgument("-f");
        cmd.addArgument(this.scriptPath);
        cmd.addArgument("--args");
        cmd.addArgument(Integer.toString(this.hashCode()));
        cmd.addArgument(Integer.toString(this.port));
        cmd.addArgument(this.libPath);
        cmd.addArgument(Integer.toString(this.sparkVersion.toNumber()));
        this.logger.debug(cmd.toString());
        this.executor = new DefaultExecutor();
        this.outputStream = new InterpreterOutputStream(this.logger);
        this.input = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream(this.input);
        PumpStreamHandler streamHandler = new PumpStreamHandler(this.outputStream, this.outputStream, in);
        this.executor.setWatchdog(new ExecuteWatchdog(-1L));
        this.executor.setStreamHandler(streamHandler);
        Map<String, String> env = EnvironmentUtils.getProcEnvironment();
        this.initialOutput = new InterpreterOutput(null);
        this.outputStream.setInterpreterOutput(this.initialOutput);
        this.executor.execute(cmd, env, this);
        this.rScriptRunning = true;
        this.eval("cat('')");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String expr) {
        ZeppelinR zeppelinR = this;
        synchronized (zeppelinR) {
            this.rRequestObject = new Request("eval", expr, null);
            return this.request();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, Object value) {
        ZeppelinR zeppelinR = this;
        synchronized (zeppelinR) {
            this.rRequestObject = new Request("set", key, value);
            this.request();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        ZeppelinR zeppelinR = this;
        synchronized (zeppelinR) {
            this.rRequestObject = new Request("get", key, null);
            return this.request();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getS0(String key) {
        ZeppelinR zeppelinR = this;
        synchronized (zeppelinR) {
            this.rRequestObject = new Request("getS", key, null);
            return (String)this.request();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object request() throws RuntimeException {
        if (!this.rScriptRunning) {
            throw new RuntimeException("r repl is not running");
        }
        if (!this.rScriptInitialized) {
            this.waitForRScriptInitialized();
        }
        this.rResponseValue = null;
        Integer n = this.rRequestNotifier;
        synchronized (n) {
            this.rRequestNotifier.notify();
        }
        Object respValue = null;
        Integer n2 = this.rResponseNotifier;
        synchronized (n2) {
            while (this.rResponseValue == null && this.rScriptRunning) {
                try {
                    this.rResponseNotifier.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
            respValue = this.rResponseValue;
            this.rResponseValue = null;
        }
        if (this.rResponseError) {
            throw new RuntimeException(respValue.toString());
        }
        return respValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRScriptInitialized() throws InterpreterException {
        Integer n = this.rScriptInitializeNotifier;
        synchronized (n) {
            long startTime = System.nanoTime();
            while (!this.rScriptInitialized && this.rScriptRunning && System.nanoTime() - startTime < 10000000000L) {
                try {
                    this.rScriptInitializeNotifier.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
        String errorMessage = "";
        try {
            this.initialOutput.flush();
            errorMessage = new String(this.initialOutput.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.rScriptInitialized) {
            throw new InterpreterException("sparkr is not responding " + errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request getRequest() {
        Integer n = this.rRequestNotifier;
        synchronized (n) {
            while (this.rRequestObject == null) {
                try {
                    this.rRequestNotifier.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
            Request req = this.rRequestObject;
            this.rRequestObject = null;
            return req;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Object value, boolean error) {
        Integer n = this.rResponseNotifier;
        synchronized (n) {
            this.rResponseValue = value;
            this.rResponseError = error;
            this.rResponseNotifier.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScriptInitialized() {
        Integer n = this.rScriptInitializeNotifier;
        synchronized (n) {
            this.rScriptInitialized = true;
            this.rScriptInitializeNotifier.notifyAll();
        }
    }

    private void createRScript() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        File out = new File(this.scriptPath);
        if (out.exists() && out.isDirectory()) {
            throw new InterpreterException("Can't create r script " + out.getAbsolutePath());
        }
        try {
            FileOutputStream outStream = new FileOutputStream(out);
            IOUtils.copy(classLoader.getResourceAsStream("R/zeppelin_sparkr.R"), (OutputStream)outStream);
            outStream.close();
        }
        catch (IOException e) {
            throw new InterpreterException(e);
        }
        this.logger.info("File {} created", (Object)this.scriptPath);
    }

    public void close() {
        this.executor.getWatchdog().destroyProcess();
        new File(this.scriptPath).delete();
        zeppelinR.remove(this.hashCode());
    }

    public static ZeppelinR getZeppelinR(int hashcode) {
        return zeppelinR.get(hashcode);
    }

    public void setInterpreterOutput(InterpreterOutput out) {
        this.outputStream.setInterpreterOutput(out);
    }

    @Override
    public void onProcessComplete(int i) {
        this.logger.info("process complete {}", (Object)i);
        this.rScriptRunning = false;
    }

    @Override
    public void onProcessFailed(ExecuteException e) {
        this.logger.error(e.getMessage(), e);
        this.rScriptRunning = false;
    }

    public static class Request {
        String type;
        String stmt;
        Object value;

        public Request(String type, String stmt, Object value) {
            this.type = type;
            this.stmt = stmt;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getStmt() {
            return this.stmt;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

