/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.zeppelin.annotation.Experimental;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectWatcher;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.RemoteWorksController;
import org.apache.zeppelin.interpreter.ResultMessages;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.apache.zeppelin.spark.dep.SparkDependencyResolver;
import scala.Function2;
import scala.Function3;
import scala.Tuple2;
import scala.Unit;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class ZeppelinContext {
    private static final Map<String, String> interpreterClassMap = new HashMap<String, String>();
    private SparkDependencyResolver dep;
    private InterpreterContext interpreterContext;
    private int maxResult;
    private List<Class> supportedClasses;
    private InterpreterHookRegistry hooks;
    public SparkContext sc;
    public SQLContext sqlContext;
    private GUI gui;

    public ZeppelinContext(SparkContext sc, SQLContext sql, InterpreterContext interpreterContext, SparkDependencyResolver dep, InterpreterHookRegistry hooks, int maxResult) {
        this.sc = sc;
        this.sqlContext = sql;
        this.interpreterContext = interpreterContext;
        this.dep = dep;
        this.hooks = hooks;
        this.maxResult = maxResult;
        this.supportedClasses = new ArrayList<Class>();
        try {
            this.getClass();
            this.supportedClasses.add(Class.forName("org.apache.spark.sql.Dataset"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.getClass();
            this.supportedClasses.add(Class.forName("org.apache.spark.sql.DataFrame"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.getClass();
            this.supportedClasses.add(Class.forName("org.apache.spark.sql.SchemaRDD"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.supportedClasses.isEmpty()) {
            throw new InterpreterException("Can not road Dataset/DataFrame/SchemaRDD class");
        }
    }

    @ZeppelinApi
    public Object input(String name) {
        return this.input(name, "");
    }

    @ZeppelinApi
    public Object input(String name, Object defaultValue) {
        return this.gui.input(name, defaultValue);
    }

    @ZeppelinApi
    public Object select(String name, Iterable<Tuple2<Object, String>> options) {
        return this.select(name, "", options);
    }

    @ZeppelinApi
    public Object select(String name, Object defaultValue, Iterable<Tuple2<Object, String>> options) {
        return this.gui.select(name, defaultValue, this.tuplesToParamOptions(options));
    }

    @ZeppelinApi
    public Iterable<Object> checkbox(String name, Iterable<Tuple2<Object, String>> options) {
        LinkedList<Object> allChecked = new LinkedList<Object>();
        for (Tuple2 option : JavaConversions.asJavaIterable(options)) {
            allChecked.add(option._1());
        }
        return this.checkbox(name, (Iterable<Object>)JavaConversions.collectionAsScalaIterable(allChecked), options);
    }

    @ZeppelinApi
    public Iterable<Object> checkbox(String name, Iterable<Object> defaultChecked, Iterable<Tuple2<Object, String>> options) {
        return JavaConversions.collectionAsScalaIterable(this.gui.checkbox(name, JavaConversions.asJavaCollection(defaultChecked), this.tuplesToParamOptions(options)));
    }

    private Input.ParamOption[] tuplesToParamOptions(Iterable<Tuple2<Object, String>> options) {
        int n = options.size();
        Input.ParamOption[] paramOptions = new Input.ParamOption[n];
        Iterator it = JavaConversions.asJavaIterable(options).iterator();
        int i = 0;
        while (it.hasNext()) {
            Tuple2 valueAndDisplayValue = (Tuple2)it.next();
            paramOptions[i++] = new Input.ParamOption(valueAndDisplayValue._1(), (String)valueAndDisplayValue._2());
        }
        return paramOptions;
    }

    public void setGui(GUI o) {
        this.gui = o;
    }

    private void restartInterpreter() {
    }

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    public void setInterpreterContext(InterpreterContext interpreterContext) {
        this.interpreterContext = interpreterContext;
    }

    public void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

    @ZeppelinApi
    public void show(Object o) {
        this.show(o, this.maxResult);
    }

    @ZeppelinApi
    public void show(Object o, int maxResult) {
        try {
            if (this.supportedClasses.contains(o.getClass())) {
                this.interpreterContext.out.write(ZeppelinContext.showDF(this.sc, this.interpreterContext, o, maxResult));
            } else {
                this.interpreterContext.out.write(o.toString());
            }
        }
        catch (IOException e) {
            throw new InterpreterException(e);
        }
    }

    public static String showDF(ZeppelinContext z, Object df) {
        return ZeppelinContext.showDF(z.sc, z.interpreterContext, df, z.maxResult);
    }

    public static String showDF(SparkContext sc, InterpreterContext interpreterContext, Object df, int maxResult) {
        Object[] rows = null;
        String jobGroup = "zeppelin-" + interpreterContext.getParagraphId();
        sc.setJobGroup(jobGroup, "Zeppelin", false);
        try {
            if (df.getClass().getCanonicalName().equals("org.apache.spark.sql.Dataset")) {
                Method convertToDFMethod = df.getClass().getMethod("toDF", new Class[0]);
                df = convertToDFMethod.invoke(df, new Object[0]);
            }
            Method take = df.getClass().getMethod("take", Integer.TYPE);
            rows = (Object[])take.invoke(df, maxResult + 1);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            sc.clearJobGroup();
            throw new InterpreterException(e);
        }
        List columns = null;
        try {
            Object qe = df.getClass().getMethod("queryExecution", new Class[0]).invoke(df, new Object[0]);
            Object a = qe.getClass().getMethod("analyzed", new Class[0]).invoke(qe, new Object[0]);
            Seq seq = (Seq)a.getClass().getMethod("output", new Class[0]).invoke(a, new Object[0]);
            columns = (List)JavaConverters.seqAsJavaListConverter((Seq)seq).asJava();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InterpreterException(e);
        }
        StringBuilder msg = new StringBuilder();
        msg.append("%table ");
        for (Attribute col : columns) {
            msg.append(col.name() + "\t");
        }
        String trim = msg.toString().trim();
        msg = new StringBuilder(trim);
        msg.append("\n");
        try {
            for (int r = 0; r < maxResult && r < rows.length; ++r) {
                Object row = rows[r];
                Method isNullAt = row.getClass().getMethod("isNullAt", Integer.TYPE);
                Method apply = row.getClass().getMethod("apply", Integer.TYPE);
                for (int i = 0; i < columns.size(); ++i) {
                    if (!((Boolean)isNullAt.invoke(row, i)).booleanValue()) {
                        msg.append(apply.invoke(row, i).toString());
                    } else {
                        msg.append("null");
                    }
                    if (i == columns.size() - 1) continue;
                    msg.append("\t");
                }
                msg.append("\n");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InterpreterException(e);
        }
        if (rows.length > maxResult) {
            msg.append("\n");
            msg.append(ResultMessages.getExceedsLimitRowsMessage(maxResult, "zeppelin.spark.maxResult"));
        }
        sc.clearJobGroup();
        return msg.toString();
    }

    @ZeppelinApi
    public void run(String noteId, String paragraphId) {
        this.run(noteId, paragraphId, this.interpreterContext);
    }

    @ZeppelinApi
    public void run(String paragraphId) {
        String noteId = this.interpreterContext.getNoteId();
        this.run(noteId, paragraphId, this.interpreterContext);
    }

    @ZeppelinApi
    public void run(String noteId, String paragraphId, InterpreterContext context) {
        if (paragraphId.equals(context.getParagraphId())) {
            throw new InterpreterException("Can not run current Paragraph");
        }
        List<InterpreterContextRunner> runners = this.getInterpreterContextRunner(noteId, paragraphId, context);
        if (runners.size() <= 0) {
            throw new InterpreterException("Paragraph " + paragraphId + " not found " + runners.size());
        }
        for (InterpreterContextRunner r : runners) {
            r.run();
        }
    }

    public void runNote(String noteId) {
        this.runNote(noteId, this.interpreterContext);
    }

    public void runNote(String noteId, InterpreterContext context) {
        String runningNoteId = context.getNoteId();
        String runningParagraphId = context.getParagraphId();
        List<InterpreterContextRunner> runners = this.getInterpreterContextRunner(noteId, context);
        if (runners.size() <= 0) {
            throw new InterpreterException("Note " + noteId + " not found " + runners.size());
        }
        for (InterpreterContextRunner r : runners) {
            if (r.getNoteId().equals(runningNoteId) && r.getParagraphId().equals(runningParagraphId)) continue;
            r.run();
        }
    }

    @ZeppelinApi
    public List<InterpreterContextRunner> getInterpreterContextRunner(String noteId, InterpreterContext interpreterContext) {
        List<InterpreterContextRunner> runners = new LinkedList<InterpreterContextRunner>();
        RemoteWorksController remoteWorksController = interpreterContext.getRemoteWorksController();
        if (remoteWorksController != null) {
            runners = remoteWorksController.getRemoteContextRunner(noteId);
        }
        return runners;
    }

    @ZeppelinApi
    public List<InterpreterContextRunner> getInterpreterContextRunner(String noteId, String paragraphId, InterpreterContext interpreterContext) {
        List<InterpreterContextRunner> runners = new LinkedList<InterpreterContextRunner>();
        RemoteWorksController remoteWorksController = interpreterContext.getRemoteWorksController();
        if (remoteWorksController != null) {
            runners = remoteWorksController.getRemoteContextRunner(noteId, paragraphId);
        }
        return runners;
    }

    @ZeppelinApi
    public void run(int idx) {
        String noteId = this.interpreterContext.getNoteId();
        this.run(noteId, idx, this.interpreterContext);
    }

    public void run(String noteId, int idx, InterpreterContext context) {
        List<InterpreterContextRunner> runners = this.getInterpreterContextRunner(noteId, context);
        if (idx >= runners.size()) {
            throw new InterpreterException("Index out of bound");
        }
        InterpreterContextRunner runner = runners.get(idx);
        if (runner.getParagraphId().equals(context.getParagraphId())) {
            throw new InterpreterException("Can not run current Paragraph");
        }
        runner.run();
    }

    @ZeppelinApi
    public void run(List<Object> paragraphIdOrIdx) {
        this.run(paragraphIdOrIdx, this.interpreterContext);
    }

    @ZeppelinApi
    public void run(List<Object> paragraphIdOrIdx, InterpreterContext context) {
        String noteId = context.getNoteId();
        for (Object idOrIdx : paragraphIdOrIdx) {
            if (idOrIdx instanceof String) {
                String paragraphId = (String)idOrIdx;
                this.run(noteId, paragraphId, context);
                continue;
            }
            if (idOrIdx instanceof Integer) {
                Integer idx = (Integer)idOrIdx;
                this.run(noteId, idx, context);
                continue;
            }
            throw new InterpreterException("Paragraph " + idOrIdx + " not found");
        }
    }

    @ZeppelinApi
    public void runAll() {
        this.runAll(this.interpreterContext);
    }

    @ZeppelinApi
    public void runAll(InterpreterContext context) {
        this.runNote(context.getNoteId());
    }

    @ZeppelinApi
    public List<String> listParagraphs() {
        LinkedList<String> paragraphs = new LinkedList<String>();
        for (InterpreterContextRunner r : this.interpreterContext.getRunners()) {
            paragraphs.add(r.getParagraphId());
        }
        return paragraphs;
    }

    private AngularObject getAngularObject(String name, InterpreterContext interpreterContext) {
        AngularObject ao;
        AngularObjectRegistry registry = interpreterContext.getAngularObjectRegistry();
        String noteId = interpreterContext.getNoteId();
        AngularObject paragraphAo = registry.get(name, noteId, interpreterContext.getParagraphId());
        AngularObject noteAo = registry.get(name, noteId, null);
        AngularObject angularObject = ao = paragraphAo != null ? paragraphAo : noteAo;
        if (ao == null) {
            ao = registry.get(name, null, null);
        }
        return ao;
    }

    @ZeppelinApi
    public Object angular(String name) {
        AngularObject ao = this.getAngularObject(name, this.interpreterContext);
        if (ao == null) {
            return null;
        }
        return ao.get();
    }

    @Deprecated
    public Object angularGlobal(String name) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, null, null);
        if (ao == null) {
            return null;
        }
        return ao.get();
    }

    @ZeppelinApi
    public void angularBind(String name, Object o) {
        this.angularBind(name, o, this.interpreterContext.getNoteId());
    }

    @Deprecated
    public void angularBindGlobal(String name, Object o) {
        this.angularBind(name, o, (String)null);
    }

    @ZeppelinApi
    public void angularBind(String name, Object o, AngularObjectWatcher watcher) {
        this.angularBind(name, o, this.interpreterContext.getNoteId(), watcher);
    }

    @Deprecated
    public void angularBindGlobal(String name, Object o, AngularObjectWatcher watcher) {
        this.angularBind(name, o, null, watcher);
    }

    @ZeppelinApi
    public void angularWatch(String name, AngularObjectWatcher watcher) {
        this.angularWatch(name, this.interpreterContext.getNoteId(), watcher);
    }

    @Deprecated
    public void angularWatchGlobal(String name, AngularObjectWatcher watcher) {
        this.angularWatch(name, null, watcher);
    }

    @ZeppelinApi
    public void angularWatch(String name, Function2<Object, Object, Unit> func) {
        this.angularWatch(name, this.interpreterContext.getNoteId(), func);
    }

    @Deprecated
    public void angularWatchGlobal(String name, Function2<Object, Object, Unit> func) {
        this.angularWatch(name, null, func);
    }

    @ZeppelinApi
    public void angularWatch(String name, Function3<Object, Object, InterpreterContext, Unit> func) {
        this.angularWatch(name, this.interpreterContext.getNoteId(), func);
    }

    @Deprecated
    public void angularWatchGlobal(String name, Function3<Object, Object, InterpreterContext, Unit> func) {
        this.angularWatch(name, null, func);
    }

    @ZeppelinApi
    public void angularUnwatch(String name, AngularObjectWatcher watcher) {
        this.angularUnwatch(name, this.interpreterContext.getNoteId(), watcher);
    }

    @Deprecated
    public void angularUnwatchGlobal(String name, AngularObjectWatcher watcher) {
        this.angularUnwatch(name, null, watcher);
    }

    @ZeppelinApi
    public void angularUnwatch(String name) {
        this.angularUnwatch(name, this.interpreterContext.getNoteId());
    }

    @Deprecated
    public void angularUnwatchGlobal(String name) {
        this.angularUnwatch(name, (String)null);
    }

    @ZeppelinApi
    public void angularUnbind(String name) {
        String noteId = this.interpreterContext.getNoteId();
        this.angularUnbind(name, noteId);
    }

    @Deprecated
    public void angularUnbindGlobal(String name) {
        this.angularUnbind(name, null);
    }

    private void angularBind(String name, Object o, String noteId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) == null) {
            registry.add(name, o, noteId, null);
        } else {
            registry.get(name, noteId, null).set(o);
        }
    }

    private void angularBind(String name, Object o, String noteId, AngularObjectWatcher watcher) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) == null) {
            registry.add(name, o, noteId, null);
        } else {
            registry.get(name, noteId, null).set(o);
        }
        this.angularWatch(name, watcher);
    }

    private void angularWatch(String name, String noteId, AngularObjectWatcher watcher) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) != null) {
            registry.get(name, noteId, null).addWatcher(watcher);
        }
    }

    private void angularWatch(String name, String noteId, final Function2<Object, Object, Unit> func) {
        AngularObjectWatcher w = new AngularObjectWatcher(this.getInterpreterContext()){

            @Override
            public void watch(Object oldObject, Object newObject, InterpreterContext context) {
                func.apply(newObject, newObject);
            }
        };
        this.angularWatch(name, noteId, w);
    }

    private void angularWatch(String name, String noteId, final Function3<Object, Object, InterpreterContext, Unit> func) {
        AngularObjectWatcher w = new AngularObjectWatcher(this.getInterpreterContext()){

            @Override
            public void watch(Object oldObject, Object newObject, InterpreterContext context) {
                func.apply(oldObject, newObject, (Object)context);
            }
        };
        this.angularWatch(name, noteId, w);
    }

    private void angularUnwatch(String name, String noteId, AngularObjectWatcher watcher) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) != null) {
            registry.get(name, noteId, null).removeWatcher(watcher);
        }
    }

    private void angularUnwatch(String name, String noteId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) != null) {
            registry.get(name, noteId, null).clearAllWatchers();
        }
    }

    private void angularUnbind(String name, String noteId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        registry.remove(name, noteId, null);
    }

    public String getClassNameFromReplName(String replName) {
        for (String name : interpreterClassMap.values()) {
            if (!replName.equals(name)) continue;
            return replName;
        }
        if (replName.contains("spark.")) {
            replName = replName.replace("spark.", "");
        }
        return interpreterClassMap.get(replName);
    }

    @Experimental
    public void registerHook(String event, String cmd, String replName) {
        String noteId = this.interpreterContext.getNoteId();
        String className = this.getClassNameFromReplName(replName);
        this.hooks.register(noteId, className, event, cmd);
    }

    @Experimental
    public void registerHook(String event, String cmd) {
        String className = this.interpreterContext.getClassName();
        this.registerHook(event, cmd, className);
    }

    @Experimental
    public String getHook(String event, String replName) {
        String noteId = this.interpreterContext.getNoteId();
        String className = this.getClassNameFromReplName(replName);
        return this.hooks.get(noteId, className, event);
    }

    @Experimental
    public String getHook(String event) {
        String className = this.interpreterContext.getClassName();
        return this.getHook(event, className);
    }

    @Experimental
    public void unregisterHook(String event, String replName) {
        String noteId = this.interpreterContext.getNoteId();
        String className = this.getClassNameFromReplName(replName);
        this.hooks.unregister(noteId, className, event);
    }

    @Experimental
    public void unregisterHook(String event) {
        String className = this.interpreterContext.getClassName();
        this.unregisterHook(event, className);
    }

    @ZeppelinApi
    public void put(String name, Object value) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        resourcePool.put(name, value);
    }

    @ZeppelinApi
    public Object get(String name) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        Resource resource = resourcePool.get(name);
        if (resource != null) {
            return resource.get();
        }
        return null;
    }

    @ZeppelinApi
    public void remove(String name) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        resourcePool.remove(name);
    }

    @ZeppelinApi
    public boolean containsKey(String name) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        Resource resource = resourcePool.get(name);
        return resource != null;
    }

    @ZeppelinApi
    public ResourceSet getAll() {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        return resourcePool.getAll();
    }

    static {
        interpreterClassMap.put("spark", "org.apache.zeppelin.spark.SparkInterpreter");
        interpreterClassMap.put("sql", "org.apache.zeppelin.spark.SparkSqlInterpreter");
        interpreterClassMap.put("dep", "org.apache.zeppelin.spark.DepInterpreter");
        interpreterClassMap.put("pyspark", "org.apache.zeppelin.spark.PySparkInterpreter");
    }
}

