/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    public static Logger logger = LoggerFactory.getLogger(Utils.class);

    Utils() {
    }

    static Object invokeMethod(Object o, String name) {
        return Utils.invokeMethod(o, name, new Class[0], new Object[0]);
    }

    static Object invokeMethod(Object o, String name, Class[] argTypes, Object[] params) {
        try {
            return o.getClass().getMethod(name, argTypes).invoke(o, params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    static Object invokeStaticMethod(Class c, String name, Class[] argTypes, Object[] params) {
        try {
            return c.getMethod(name, argTypes).invoke(null, params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    static Object invokeStaticMethod(Class c, String name) {
        return Utils.invokeStaticMethod(c, name, new Class[0], new Object[0]);
    }

    static Class findClass(String name) {
        return Utils.findClass(name, false);
    }

    static Class findClass(String name, boolean silence) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            if (!silence) {
                logger.error(e.getMessage(), e);
            }
            return null;
        }
    }

    static Object instantiateClass(String name, Class[] argTypes, Object[] params) {
        try {
            Constructor<?> constructor = Utils.class.getClassLoader().loadClass(name).getConstructor(argTypes);
            return constructor.newInstance(params);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    static boolean isScala2_10() {
        try {
            Class.forName("org.apache.spark.repl.SparkIMain");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (IncompatibleClassChangeError e) {
            return false;
        }
    }

    static boolean isScala2_11() {
        return !Utils.isScala2_10();
    }

    static boolean isSpark2() {
        try {
            Class.forName("org.apache.spark.sql.SparkSession");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

