/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteAngularObject;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAngularObjectRegistry
extends AngularObjectRegistry {
    Logger logger = LoggerFactory.getLogger(RemoteAngularObjectRegistry.class);
    private InterpreterGroup interpreterGroup;

    public RemoteAngularObjectRegistry(String interpreterId, AngularObjectRegistryListener listener, InterpreterGroup interpreterGroup) {
        super(interpreterId, listener);
        this.interpreterGroup = interpreterGroup;
    }

    private RemoteInterpreterProcess getRemoteInterpreterProcess() {
        return this.interpreterGroup.getRemoteInterpreterProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AngularObject addAndNotifyRemoteProcess(String name, Object o, String noteId, String paragraphId) {
        Gson gson = new Gson();
        RemoteInterpreterProcess remoteInterpreterProcess = this.getRemoteInterpreterProcess();
        if (!remoteInterpreterProcess.isRunning()) {
            return super.add(name, o, noteId, paragraphId, true);
        }
        RemoteInterpreterService.Client client = null;
        boolean broken = false;
        try {
            client = remoteInterpreterProcess.getClient();
            client.angularObjectAdd(name, noteId, paragraphId, gson.toJson(o));
            AngularObject angularObject = super.add(name, o, noteId, paragraphId, true);
            return angularObject;
        }
        catch (TException e) {
            broken = true;
            this.logger.error("Error", e);
        }
        catch (Exception e) {
            this.logger.error("Error", e);
        }
        finally {
            if (client != null) {
                remoteInterpreterProcess.releaseClient(client, broken);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AngularObject removeAndNotifyRemoteProcess(String name, String noteId, String paragraphId) {
        RemoteInterpreterProcess remoteInterpreterProcess = this.getRemoteInterpreterProcess();
        if (remoteInterpreterProcess == null || !remoteInterpreterProcess.isRunning()) {
            return super.remove(name, noteId, paragraphId);
        }
        RemoteInterpreterService.Client client = null;
        boolean broken = false;
        try {
            client = remoteInterpreterProcess.getClient();
            client.angularObjectRemove(name, noteId, paragraphId);
            AngularObject angularObject = super.remove(name, noteId, paragraphId);
            return angularObject;
        }
        catch (TException e) {
            broken = true;
            this.logger.error("Error", e);
        }
        catch (Exception e) {
            this.logger.error("Error", e);
        }
        finally {
            if (client != null) {
                remoteInterpreterProcess.releaseClient(client, broken);
            }
        }
        return null;
    }

    public void removeAllAndNotifyRemoteProcess(String noteId, String paragraphId) {
        List<AngularObject> all = this.getAll(noteId, paragraphId);
        for (AngularObject ao : all) {
            this.removeAndNotifyRemoteProcess(ao.getName(), noteId, paragraphId);
        }
    }

    @Override
    protected AngularObject createNewAngularObject(String name, Object o, String noteId, String paragraphId) {
        return new RemoteAngularObject(name, o, noteId, paragraphId, this.interpreterGroup, this.getAngularObjectListener());
    }
}

