/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;

public class LazyOpenInterpreter
extends Interpreter
implements WrappedInterpreter {
    private Interpreter intp;
    volatile boolean opened = false;

    public LazyOpenInterpreter(Interpreter intp) {
        super(new Properties());
        this.intp = intp;
    }

    @Override
    public Interpreter getInnerInterpreter() {
        return this.intp;
    }

    @Override
    public void setProperty(Properties property) {
        this.intp.setProperty(property);
    }

    @Override
    public Properties getProperty() {
        return this.intp.getProperty();
    }

    @Override
    public String getProperty(String key) {
        return this.intp.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open() {
        if (this.opened) {
            return;
        }
        Interpreter interpreter = this.intp;
        synchronized (interpreter) {
            if (!this.opened) {
                this.intp.open();
                this.opened = true;
            }
        }
    }

    @Override
    public InterpreterResult executePrecode(InterpreterContext interpreterContext) {
        return this.intp.executePrecode(interpreterContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Interpreter interpreter = this.intp;
        synchronized (interpreter) {
            if (this.opened) {
                this.intp.close();
                this.opened = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Interpreter interpreter = this.intp;
        synchronized (interpreter) {
            return this.opened;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) {
        this.open();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            InterpreterResult interpreterResult = this.intp.interpret(st, context);
            return interpreterResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Override
    public void cancel(InterpreterContext context) {
        this.open();
        this.intp.cancel(context);
    }

    @Override
    public Interpreter.FormType getFormType() {
        return this.intp.getFormType();
    }

    @Override
    public int getProgress(InterpreterContext context) {
        if (this.opened) {
            return this.intp.getProgress(context);
        }
        return 0;
    }

    @Override
    public Scheduler getScheduler() {
        return this.intp.getScheduler();
    }

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        this.open();
        List<InterpreterCompletion> completion2 = this.intp.completion(buf, cursor, interpreterContext);
        return completion2;
    }

    @Override
    public String getClassName() {
        return this.intp.getClassName();
    }

    @Override
    public InterpreterGroup getInterpreterGroup() {
        return this.intp.getInterpreterGroup();
    }

    @Override
    public void setInterpreterGroup(InterpreterGroup interpreterGroup) {
        this.intp.setInterpreterGroup(interpreterGroup);
    }

    @Override
    public URL[] getClassloaderUrls() {
        return this.intp.getClassloaderUrls();
    }

    @Override
    public void setClassloaderUrls(URL[] urls) {
        this.intp.setClassloaderUrls(urls);
    }

    @Override
    public void registerHook(String noteId, String event, String cmd) {
        this.intp.registerHook(noteId, event, cmd);
    }

    @Override
    public void registerHook(String event, String cmd) {
        this.intp.registerHook(event, cmd);
    }

    @Override
    public String getHook(String noteId, String event) {
        return this.intp.getHook(noteId, event);
    }

    @Override
    public String getHook(String event) {
        return this.intp.getHook(event);
    }

    @Override
    public void unregisterHook(String noteId, String event) {
        this.intp.unregisterHook(noteId, event);
    }

    @Override
    public void unregisterHook(String event) {
        this.intp.unregisterHook(event);
    }
}

