/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.List;
import java.util.Map;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.RemoteWorksController;
import org.apache.zeppelin.interpreter.remote.RemoteEventClient;
import org.apache.zeppelin.interpreter.remote.RemoteEventClientWrapper;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.user.AuthenticationInfo;

public class InterpreterContext {
    private static final ThreadLocal<InterpreterContext> threadIC = new ThreadLocal();
    public final InterpreterOutput out;
    private final String noteId;
    private final String replName;
    private final String paragraphTitle;
    private final String paragraphId;
    private final String paragraphText;
    private AuthenticationInfo authenticationInfo;
    private final Map<String, Object> config;
    private GUI gui;
    private AngularObjectRegistry angularObjectRegistry;
    private ResourcePool resourcePool;
    private List<InterpreterContextRunner> runners;
    private String className;
    private RemoteEventClientWrapper client;
    private RemoteWorksController remoteWorksController;

    public static InterpreterContext get() {
        return threadIC.get();
    }

    public static void set(InterpreterContext ic) {
        threadIC.set(ic);
    }

    public static void remove() {
        threadIC.remove();
    }

    public InterpreterContext(String noteId, String paragraphId, String replName, String paragraphTitle, String paragraphText, AuthenticationInfo authenticationInfo, Map<String, Object> config, GUI gui, AngularObjectRegistry angularObjectRegistry, ResourcePool resourcePool, List<InterpreterContextRunner> runners, InterpreterOutput out) {
        this(noteId, paragraphId, replName, paragraphTitle, paragraphText, authenticationInfo, config, gui, angularObjectRegistry, resourcePool, runners, out, null);
    }

    public InterpreterContext(String noteId, String paragraphId, String replName, String paragraphTitle, String paragraphText, AuthenticationInfo authenticationInfo, Map<String, Object> config, GUI gui, AngularObjectRegistry angularObjectRegistry, ResourcePool resourcePool, List<InterpreterContextRunner> runners, InterpreterOutput out, RemoteWorksController remoteWorksController) {
        this.noteId = noteId;
        this.paragraphId = paragraphId;
        this.replName = replName;
        this.paragraphTitle = paragraphTitle;
        this.paragraphText = paragraphText;
        this.authenticationInfo = authenticationInfo;
        this.config = config;
        this.gui = gui;
        this.angularObjectRegistry = angularObjectRegistry;
        this.resourcePool = resourcePool;
        this.runners = runners;
        this.out = out;
        this.remoteWorksController = remoteWorksController;
    }

    public InterpreterContext(String noteId, String paragraphId, String replName, String paragraphTitle, String paragraphText, AuthenticationInfo authenticationInfo, Map<String, Object> config, GUI gui, AngularObjectRegistry angularObjectRegistry, ResourcePool resourcePool, List<InterpreterContextRunner> contextRunners, InterpreterOutput output, RemoteWorksController remoteWorksController, RemoteInterpreterEventClient eventClient) {
        this(noteId, paragraphId, replName, paragraphTitle, paragraphText, authenticationInfo, config, gui, angularObjectRegistry, resourcePool, contextRunners, output, remoteWorksController);
        this.client = new RemoteEventClient(eventClient);
    }

    public String getNoteId() {
        return this.noteId;
    }

    public String getReplName() {
        return this.replName;
    }

    public String getParagraphId() {
        return this.paragraphId;
    }

    public String getParagraphText() {
        return this.paragraphText;
    }

    public String getParagraphTitle() {
        return this.paragraphTitle;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public GUI getGui() {
        return this.gui;
    }

    public AngularObjectRegistry getAngularObjectRegistry() {
        return this.angularObjectRegistry;
    }

    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public List<InterpreterContextRunner> getRunners() {
        return this.runners;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public RemoteEventClientWrapper getClient() {
        return this.client;
    }

    public RemoteWorksController getRemoteWorksController() {
        return this.remoteWorksController;
    }

    public void setRemoteWorksController(RemoteWorksController remoteWorksController) {
        this.remoteWorksController = remoteWorksController;
    }

    public InterpreterOutput out() {
        return this.out;
    }
}

