/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.helium.Application;
import org.apache.zeppelin.helium.ApplicationContext;
import org.apache.zeppelin.helium.ApplicationException;
import org.apache.zeppelin.helium.ClassLoaderApplication;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.resource.DistributedResourcePool;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLoader {
    Logger logger = LoggerFactory.getLogger(ApplicationLoader.class);
    private final DependencyResolver depResolver;
    private final ResourcePool resourcePool;
    private final Map<HeliumPackage, Class<Application>> cached;

    public ApplicationLoader(ResourcePool resourcePool, DependencyResolver depResolver) {
        this.depResolver = depResolver;
        this.resourcePool = resourcePool;
        this.cached = Collections.synchronizedMap(new HashMap());
    }

    public Application load(HeliumPackage packageInfo, ApplicationContext context) throws Exception {
        if (packageInfo.getType() != HeliumPackage.Type.APPLICATION) {
            throw new ApplicationException("Can't instantiate " + (Object)((Object)packageInfo.getType()) + " package using ApplicationLoader");
        }
        RunningApplication key = new RunningApplication(packageInfo, context.getNoteId(), context.getParagraphId());
        ResourceSet resources = this.findRequiredResourceSet(packageInfo.getResources(), context.getNoteId(), context.getParagraphId());
        Class<Application> appClass = this.loadClass(packageInfo);
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = appClass.getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            ClassLoaderApplication app;
            Constructor<Application> constructor = appClass.getConstructor(ApplicationContext.class);
            ClassLoaderApplication classLoaderApplication = app = new ClassLoaderApplication(constructor.newInstance(context), cl);
            return classLoaderApplication;
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }

    public ResourceSet findRequiredResourceSet(String[][] requiredResources, String noteId, String paragraphId) {
        if (requiredResources == null || requiredResources.length == 0) {
            return new ResourceSet();
        }
        ResourceSet allResources = this.resourcePool instanceof DistributedResourcePool ? ((DistributedResourcePool)this.resourcePool).getAll(false) : this.resourcePool.getAll();
        return ApplicationLoader.findRequiredResourceSet(requiredResources, noteId, paragraphId, allResources);
    }

    static ResourceSet findRequiredResourceSet(String[][] requiredResources, String noteId, String paragraphId, ResourceSet resources) {
        ResourceSet args = new ResourceSet();
        if (requiredResources == null || requiredResources.length == 0) {
            return args;
        }
        resources = resources.filterByNoteId(noteId).filterByParagraphId(paragraphId);
        for (String[] requires : requiredResources) {
            args.clear();
            for (String require : requires) {
                boolean found = false;
                for (Resource r : resources) {
                    if (require.startsWith(":") && r.getClassName().equals(require.substring(1))) {
                        found = true;
                    } else if (r.getResourceId().getName().equals(require)) {
                        found = true;
                    }
                    if (!found) continue;
                    args.add(r);
                    break;
                }
                if (!found) break;
            }
            if (args.size() != requires.length) continue;
            return args;
        }
        return null;
    }

    private Class<Application> loadClass(HeliumPackage packageInfo) throws Exception {
        List<File> paths;
        if (this.cached.containsKey(packageInfo)) {
            return this.cached.get(packageInfo);
        }
        LinkedList<URL> urlList = new LinkedList<URL>();
        if (packageInfo.getArtifact() != null && (paths = this.depResolver.load(packageInfo.getArtifact())) != null) {
            for (File path : paths) {
                urlList.add(path.toURI().toURL());
            }
        }
        URLClassLoader applicationClassLoader = new URLClassLoader(urlList.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        Class<Application> cls = applicationClassLoader.loadClass(packageInfo.getClassName());
        this.cached.put(packageInfo, cls);
        return cls;
    }

    private static class RunningApplication {
        HeliumPackage packageInfo;
        String noteId;
        String paragraphId;

        public RunningApplication(HeliumPackage packageInfo, String noteId, String paragraphId) {
            this.packageInfo = packageInfo;
            this.noteId = noteId;
            this.paragraphId = paragraphId;
        }

        public HeliumPackage getPackageInfo() {
            return this.packageInfo;
        }

        public String getNoteId() {
            return this.noteId;
        }

        public String getParagraphId() {
            return this.paragraphId;
        }

        public int hashCode() {
            return (this.paragraphId + this.noteId + this.packageInfo.getArtifact() + this.packageInfo.getClassName()).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RunningApplication)) {
                return false;
            }
            RunningApplication r = (RunningApplication)o;
            return this.packageInfo.equals(r.getPackageInfo()) && this.paragraphId.equals(r.getParagraphId()) && this.noteId.equals(r.getNoteId());
        }
    }
}

