/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.tools;

import java.io.File;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.shaded.log.FileMessageSet;
import kafka.shaded.log.Log$;
import kafka.shaded.log.OffsetIndex;
import kafka.shaded.log.OffsetIndex$;
import kafka.shaded.log.OffsetPosition;
import kafka.shaded.message.ByteBufferMessageSet$;
import kafka.shaded.message.CompressionCodec;
import kafka.shaded.message.Message;
import kafka.shaded.message.MessageAndOffset;
import kafka.shaded.message.MessageSet$;
import kafka.shaded.message.NoCompressionCodec$;
import kafka.shaded.serializer.Decoder;
import kafka.shaded.tools.DumpLogSegments;
import kafka.shaded.tools.DumpLogSegments$$anonfun$kafka$tools$DumpLogSegments$;
import kafka.shaded.utils.CommandLineUtils$;
import kafka.shaded.utils.CoreUtils$;
import kafka.shaded.utils.IteratorTemplate;
import kafka.shaded.utils.VerifiableProperties;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.RichInt$;

public final class DumpLogSegments$ {
    public static final DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] args) {
        DumpLogSegments.MessageParser<String, String> messageParser;
        boolean isDeepIteration;
        OptionParser parser = new OptionParser();
        OptionSpecBuilder printOpt = parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs");
        OptionSpecBuilder verifyOpt = parser.accepts("verify-index-only", "if set, just verify the index log without printing its content");
        OptionSpecBuilder indexSanityOpt = parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        ArgumentAcceptingOptionSpec<String> filesOpt = parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x500000), (Integer[])((Object[])new Integer[0]));
        OptionSpecBuilder deepIterationOpt = parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration");
        ArgumentAcceptingOptionSpec<String> valueDecoderOpt = parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.shaded.serializer.StringDecoder", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> keyDecoderOpt = parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.shaded.serializer.StringDecoder", (String[])((Object[])new String[0]));
        OptionSpecBuilder offsetsOpt = parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from __consumer_offsets topic");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{filesOpt}));
        boolean print2 = options.has(printOpt);
        boolean verifyOnly = options.has(verifyOpt);
        boolean indexSanityOnly = options.has(indexSanityOpt);
        String[] files = options.valueOf(filesOpt).split(",");
        int maxMessageSize = options.valueOf(maxMessageSizeOpt);
        boolean bl = isDeepIteration = options.has(deepIterationOpt);
        if (options.has(offsetsOpt)) {
            messageParser = new DumpLogSegments.OffsetsMessageParser();
        } else {
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject(options.valueOf(valueDecoderOpt), Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject(options.valueOf(keyDecoderOpt), Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            messageParser = new DumpLogSegments.DecoderMessageParser(keyDecoder, valueDecoder);
        }
        DumpLogSegments.OffsetsMessageParser messageParser2 = messageParser;
        HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap = new HashMap<String, List<Tuple2<Object, Object>>>();
        HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap = new HashMap<String, List<Tuple2<Object, Object>>>();
        Predef$.MODULE$.refArrayOps((Object[])files).foreach(new scala.Serializable(print2, verifyOnly, indexSanityOnly, maxMessageSize, isDeepIteration, messageParser2, misMatchesForIndexFilesMap, nonConsecutivePairsForLogFilesMap){
            public static final long serialVersionUID = 0L;
            private final boolean print$1;
            private final boolean verifyOnly$1;
            private final boolean indexSanityOnly$1;
            private final int maxMessageSize$1;
            private final boolean isDeepIteration$1;
            private final DumpLogSegments.MessageParser messageParser$1;
            private final HashMap misMatchesForIndexFilesMap$1;
            private final HashMap nonConsecutivePairsForLogFilesMap$1;

            public final void apply(String arg) {
                File file = new File(arg);
                if (file.getName().endsWith(Log$.MODULE$.LogFileSuffix())) {
                    Predef$.MODULE$.println(new StringBuilder().append((Object)"Dumping ").append(file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpLog(file, this.print$1, this.nonConsecutivePairsForLogFilesMap$1, this.isDeepIteration$1, this.maxMessageSize$1, this.messageParser$1);
                } else if (file.getName().endsWith(Log$.MODULE$.IndexFileSuffix())) {
                    Predef$.MODULE$.println(new StringBuilder().append((Object)"Dumping ").append(file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpIndex(file, this.indexSanityOnly$1, this.verifyOnly$1, this.misMatchesForIndexFilesMap$1, this.maxMessageSize$1);
                }
            }
            {
                this.print$1 = print$1;
                this.verifyOnly$1 = verifyOnly$1;
                this.indexSanityOnly$1 = indexSanityOnly$1;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.isDeepIteration$1 = isDeepIteration$1;
                this.messageParser$1 = messageParser$1;
                this.misMatchesForIndexFilesMap$1 = misMatchesForIndexFilesMap$1;
                this.nonConsecutivePairsForLogFilesMap$1 = nonConsecutivePairsForLogFilesMap$1;
            }
        });
        misMatchesForIndexFilesMap.foreach(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$1) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String fileName = tuple2._1();
                    List<Tuple2<Object, Object>> listOfMismatches = tuple2._2();
                    System.err.println(new StringBuilder().append((Object)"Mismatches in :").append((Object)fileName).toString());
                    listOfMismatches.foreach(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(m._1$mcJ$sp()), BoxesRunTime.boxToLong(m._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        nonConsecutivePairsForLogFilesMap.foreach(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$2) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String fileName = tuple2._1();
                    List<Tuple2<Object, Object>> listOfNonConsecutivePairs = tuple2._2();
                    System.err.println(new StringBuilder().append((Object)"Non-secutive offsets in :").append((Object)fileName).toString());
                    listOfNonConsecutivePairs.foreach(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(m._1$mcJ$sp()), BoxesRunTime.boxToLong(m._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void kafka$tools$DumpLogSegments$$dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString());
                FileMessageSet messageSet = new FileMessageSet(logFile, false);
                OffsetIndex index2 = new OffsetIndex(file, startOffset, OffsetIndex$.MODULE$.$lessinit$greater$default$3());
                if (indexSanityOnly) {
                    index2.sanityCheck();
                    Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file})));
                    return;
                }
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index2.entries()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable(file, verifyOnly, misMatchesForIndexFilesMap, maxMessageSize, messageSet, index2, object){
                    public static final long serialVersionUID = 0L;
                    private final File file$2;
                    private final boolean verifyOnly$2;
                    private final HashMap misMatchesForIndexFilesMap$2;
                    private final int maxMessageSize$2;
                    private final FileMessageSet messageSet$1;
                    private final OffsetIndex index$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Serializable serializable2;
                        OffsetPosition entry2 = this.index$1.entry(i);
                        FileMessageSet partialFileMessageSet = this.messageSet$1.read(entry2.position(), this.maxMessageSize$2);
                        MessageAndOffset messageAndOffset = DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator((MessageAndOffset)partialFileMessageSet.head(), true).next();
                        if (messageAndOffset.offset() != entry2.offset() + this.index$1.baseOffset()) {
                            List<Tuple2<Object, Object>> misMatchesSeq = this.misMatchesForIndexFilesMap$2.getOrElse(this.file$2.getAbsolutePath(), new scala.Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final List<Tuple2<Object, Object>> apply() {
                                    return Nil$.MODULE$;
                                }
                            });
                            misMatchesSeq = misMatchesSeq.$colon$colon(new Tuple2$mcJJ$sp(entry2.offset() + this.index$1.baseOffset(), messageAndOffset.offset()));
                            serializable2 = this.misMatchesForIndexFilesMap$2.put(this.file$2.getAbsolutePath(), misMatchesSeq);
                        } else {
                            serializable2 = BoxedUnit.UNIT;
                        }
                        if (entry2.offset() == 0L && i > 0) {
                            throw new NonLocalReturnControl$mcV$sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        if (!this.verifyOnly$2) {
                            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("offset: %d position: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(entry2.offset() + this.index$1.baseOffset()), BoxesRunTime.boxToInteger(entry2.position())})));
                        }
                    }
                    {
                        this.file$2 = file$2;
                        this.verifyOnly$2 = verifyOnly$2;
                        this.misMatchesForIndexFilesMap$2 = misMatchesForIndexFilesMap$2;
                        this.maxMessageSize$2 = maxMessageSize$2;
                        this.messageSet$1 = messageSet$1;
                        this.index$1 = index$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                }));
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void kafka$tools$DumpLogSegments$$dumpLog(File file, boolean printContents, HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
        Predef$.MODULE$.println(new StringBuilder().append((Object)"Starting offset: ").append(BoxesRunTime.boxToLong(startOffset)).toString());
        FileMessageSet messageSet = new FileMessageSet(file, false);
        LongRef validBytes = new LongRef(0L);
        LongRef lastOffset = new LongRef(-1L);
        Iterator<MessageAndOffset> shallowIterator = messageSet.iterator(maxMessageSize);
        shallowIterator.foreach(new scala.Serializable(file, printContents, nonConsecutivePairsForLogFilesMap, isDeepIteration, parser, validBytes, lastOffset){
            public static final long serialVersionUID = 0L;
            public final File file$1;
            public final boolean printContents$1;
            public final HashMap nonConsecutivePairsForLogFilesMap$2;
            private final boolean isDeepIteration$2;
            public final DumpLogSegments.MessageParser parser$1;
            public final LongRef validBytes$1;
            public final LongRef lastOffset$1;

            public final void apply(MessageAndOffset shallowMessageAndOffset) {
                Iterator<MessageAndOffset> itr = DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator(shallowMessageAndOffset, this.isDeepIteration$2);
                itr.foreach(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$kafka$tools$DumpLogSegments$$dumpLog$1 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(MessageAndOffset messageAndOffset) {
                        Serializable serializable2;
                        Serializable serializable3;
                        Message msg = messageAndOffset.message();
                        if (this.$outer.lastOffset$1.elem == -1L) {
                            this.$outer.lastOffset$1.elem = messageAndOffset.offset();
                            serializable3 = BoxedUnit.UNIT;
                        } else {
                            CompressionCodec compressionCodec = msg.compressionCodec();
                            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                            if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) && messageAndOffset.offset() != this.$outer.lastOffset$1.elem + 1L) {
                                List<Tuple2<Object, Object>> nonConsecutivePairsSeq = this.$outer.nonConsecutivePairsForLogFilesMap$2.getOrElse(this.$outer.file$1.getAbsolutePath(), new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final List<Tuple2<Object, Object>> apply() {
                                        return Nil$.MODULE$;
                                    }
                                });
                                nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon(new Tuple2$mcJJ$sp(this.$outer.lastOffset$1.elem, messageAndOffset.offset()));
                                serializable3 = this.$outer.nonConsecutivePairsForLogFilesMap$2.put(this.$outer.file$1.getAbsolutePath(), nonConsecutivePairsSeq);
                            } else {
                                serializable3 = BoxedUnit.UNIT;
                            }
                        }
                        this.$outer.lastOffset$1.elem = messageAndOffset.offset();
                        Predef$.MODULE$.print(new StringBuilder().append((Object)"offset: ").append(BoxesRunTime.boxToLong(messageAndOffset.offset())).append((Object)" position: ").append(BoxesRunTime.boxToLong(this.$outer.validBytes$1.elem)).append((Object)" isvalid: ").append(BoxesRunTime.boxToBoolean(msg.isValid())).append((Object)" payloadsize: ").append(BoxesRunTime.boxToInteger(msg.payloadSize())).append((Object)" magic: ").append(BoxesRunTime.boxToByte(msg.magic())).append((Object)" compresscodec: ").append(msg.compressionCodec()).append((Object)" crc: ").append(BoxesRunTime.boxToLong(msg.checksum())).toString());
                        if (msg.hasKey()) {
                            Predef$.MODULE$.print(new StringBuilder().append((Object)" keysize: ").append(BoxesRunTime.boxToInteger(msg.keySize())).toString());
                        }
                        if (this.$outer.printContents$1) {
                            Tuple2<Option<K>, Option<V>> tuple2;
                            Tuple2<Option<K>, Option<V>> tuple22 = this.$outer.parser$1.parse(msg);
                            if (tuple22 == null) throw new MatchError(tuple22);
                            Option<K> key = tuple22._1();
                            Option<V> payload = tuple22._2();
                            Tuple2<Option<K>, Option<V>> tuple23 = tuple2 = new Tuple2<Option<K>, Option<V>>(key, payload);
                            Option<K> key2 = tuple23._1();
                            Option<V> payload2 = tuple23._2();
                            key2.map(new scala.Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Object key) {
                                    Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" key: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{key})));
                                }
                            });
                            serializable2 = payload2.map(new scala.Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Object payload) {
                                    Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" payload: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{payload})));
                                }
                            });
                        } else {
                            serializable2 = BoxedUnit.UNIT;
                        }
                        Predef$.MODULE$.println();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.validBytes$1.elem += (long)MessageSet$.MODULE$.entrySize(shallowMessageAndOffset.message());
            }
            {
                this.file$1 = file$1;
                this.printContents$1 = printContents$1;
                this.nonConsecutivePairsForLogFilesMap$2 = nonConsecutivePairsForLogFilesMap$2;
                this.isDeepIteration$2 = isDeepIteration$2;
                this.parser$1 = parser$1;
                this.validBytes$1 = validBytes$1;
                this.lastOffset$1 = lastOffset$1;
            }
        });
        long trailingBytes = (long)messageSet.sizeInBytes() - validBytes.elem;
        if (trailingBytes > 0L) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(trailingBytes), file.getName()})));
        }
    }

    public Iterator<MessageAndOffset> kafka$tools$DumpLogSegments$$getIterator(MessageAndOffset messageAndOffset, boolean isDeepIteration) {
        IteratorTemplate<MessageAndOffset> iteratorTemplate;
        if (isDeepIteration) {
            Message message = messageAndOffset.message();
            CompressionCodec compressionCodec = message.compressionCodec();
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            CompressionCodec compressionCodec2 = compressionCodec;
            Iterator<MessageAndOffset> iterator2 = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? this.getSingleMessageIterator(messageAndOffset) : ByteBufferMessageSet$.MODULE$.deepIterator(messageAndOffset);
            iteratorTemplate = iterator2;
        } else {
            iteratorTemplate = this.getSingleMessageIterator(messageAndOffset);
        }
        return iteratorTemplate;
    }

    private IteratorTemplate<MessageAndOffset> getSingleMessageIterator(MessageAndOffset messageAndOffset) {
        return new IteratorTemplate<MessageAndOffset>(messageAndOffset){
            private boolean messageIterated;
            private final MessageAndOffset messageAndOffset$1;

            public boolean messageIterated() {
                return this.messageIterated;
            }

            public void messageIterated_$eq(boolean x$1) {
                this.messageIterated = x$1;
            }

            public MessageAndOffset makeNext() {
                MessageAndOffset messageAndOffset;
                if (this.messageIterated()) {
                    messageAndOffset = (MessageAndOffset)this.allDone();
                } else {
                    this.messageIterated_$eq(true);
                    messageAndOffset = this.messageAndOffset$1;
                }
                return messageAndOffset;
            }
            {
                this.messageAndOffset$1 = messageAndOffset$1;
                this.messageIterated = false;
            }
        };
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }
}

