/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.coordinator;

import java.util.UUID;
import kafka.shaded.coordinator.AwaitingSync$;
import kafka.shaded.coordinator.Dead$;
import kafka.shaded.coordinator.GroupCoordinator$;
import kafka.shaded.coordinator.GroupMetadata$;
import kafka.shaded.coordinator.GroupOverview;
import kafka.shaded.coordinator.GroupState;
import kafka.shaded.coordinator.GroupSummary;
import kafka.shaded.coordinator.MemberMetadata;
import kafka.shaded.coordinator.MemberSummary;
import kafka.shaded.coordinator.PreparingRebalance$;
import kafka.shaded.coordinator.Stable$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$Int$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ex!B\u0001\u0003\u0011\u00139\u0011!D$s_V\u0004X*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tAIa\u0003\u0002\u000e\u000fJ|W\u000f]'fi\u0006$\u0017\r^1\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a#\u0003b\u0001\n\u00139\u0012a\u0005<bY&$\u0007K]3wS>,8o\u0015;bi\u0016\u001cX#\u0001\r\u0011\tearD\t\b\u0003\u001biI!a\u0007\b\u0002\rA\u0013X\rZ3g\u0013\tibDA\u0002NCBT!a\u0007\b\u0011\u0005!\u0001\u0013BA\u0011\u0003\u0005)9%o\\;q'R\fG/\u001a\t\u00043\rz\u0012B\u0001\u0013\u001f\u0005\r\u0019V\r\u001e\u0005\u0007M%\u0001\u000b\u0011\u0002\r\u0002)Y\fG.\u001b3Qe\u00164\u0018n\\;t'R\fG/Z:!\r\u0015Q!\u0001\u0001\u0002)'\t9C\u0002\u0003\u0005+O\t\u0015\r\u0011\"\u0001,\u0003\u001d9'o\\;q\u0013\u0012,\u0012\u0001\f\t\u000335J!A\f\u0010\u0003\rM#(/\u001b8h\u0011!\u0001tE!A!\u0002\u0013a\u0013\u0001C4s_V\u0004\u0018\n\u001a\u0011\t\u0011I:#Q1A\u0005\u0002-\nA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016D\u0001\u0002N\u0014\u0003\u0002\u0003\u0006I\u0001L\u0001\u000eaJ|Go\\2pYRK\b/\u001a\u0011\t\u000bM9C\u0011\u0001\u001c\u0015\u0007]B\u0014\b\u0005\u0002\tO!)!&\u000ea\u0001Y!)!'\u000ea\u0001Y!91h\nb\u0001\n\u0013a\u0014aB7f[\n,'o]\u000b\u0002{A!ah\u0011\u0017F\u001b\u0005y$B\u0001!B\u0003\u001diW\u000f^1cY\u0016T!A\u0011\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002E\u007f\t9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\u0005G\u0013\t9%A\u0001\bNK6\u0014WM]'fi\u0006$\u0017\r^1\t\r%;\u0003\u0015!\u0003>\u0003!iW-\u001c2feN\u0004\u0003bB&(\u0001\u0004%I\u0001T\u0001\u0006gR\fG/Z\u000b\u0002?!9aj\na\u0001\n\u0013y\u0015!C:uCR,w\fJ3r)\t\u00016\u000b\u0005\u0002\u000e#&\u0011!K\u0004\u0002\u0005+:LG\u000fC\u0004U\u001b\u0006\u0005\t\u0019A\u0010\u0002\u0007a$\u0013\u0007\u0003\u0004WO\u0001\u0006KaH\u0001\u0007gR\fG/\u001a\u0011\t\u000fa;\u0003\u0019!C\u00013\u0006aq-\u001a8fe\u0006$\u0018n\u001c8JIV\t!\f\u0005\u0002\u000e7&\u0011AL\u0004\u0002\u0004\u0013:$\bb\u00020(\u0001\u0004%\taX\u0001\u0011O\u0016tWM]1uS>t\u0017\nZ0%KF$\"\u0001\u00151\t\u000fQk\u0016\u0011!a\u00015\"1!m\nQ!\ni\u000bQbZ3oKJ\fG/[8o\u0013\u0012\u0004\u0003b\u00023(\u0001\u0004%\taK\u0001\tY\u0016\fG-\u001a:JI\"9am\na\u0001\n\u00039\u0017\u0001\u00047fC\u0012,'/\u00133`I\u0015\fHC\u0001)i\u0011\u001d!V-!AA\u00021BaA[\u0014!B\u0013a\u0013!\u00037fC\u0012,'/\u00133!\u0011\u001daw\u00051A\u0005\u0002-\n\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0005\b]\u001e\u0002\r\u0011\"\u0001p\u00031\u0001(o\u001c;pG>dw\fJ3r)\t\u0001\u0006\u000fC\u0004U[\u0006\u0005\t\u0019\u0001\u0017\t\rI<\u0003\u0015)\u0003-\u0003%\u0001(o\u001c;pG>d\u0007\u0005C\u0003uO\u0011\u0005Q/\u0001\u0002jgR\u0011a/\u001f\t\u0003\u001b]L!\u0001\u001f\b\u0003\u000f\t{w\u000e\\3b]\")!p\u001da\u0001?\u0005QqM]8vaN#\u0018\r^3\t\u000bq<C\u0011A?\u0002\u00079|G\u000f\u0006\u0002w}\")!p\u001fa\u0001?!9\u0011\u0011A\u0014\u0005\u0002\u0005\r\u0011a\u00015bgR\u0019a/!\u0002\t\r\u0005\u001dq\u00101\u0001-\u0003!iW-\u001c2fe&#\u0007bBA\u0006O\u0011\u0005\u0011QB\u0001\u0004O\u0016$HcA#\u0002\u0010!9\u0011qAA\u0005\u0001\u0004a\u0003bBA\nO\u0011\u0005\u0011QC\u0001\u0004C\u0012$G#\u0002)\u0002\u0018\u0005e\u0001bBA\u0004\u0003#\u0001\r\u0001\f\u0005\b\u00037\t\t\u00021\u0001F\u0003\u0019iW-\u001c2fe\"9\u0011qD\u0014\u0005\u0002\u0005\u0005\u0012A\u0002:f[>4X\rF\u0002Q\u0003GAq!a\u0002\u0002\u001e\u0001\u0007A\u0006\u0003\u0004\u0002(\u001d\"\t\u0001T\u0001\rGV\u0014(/\u001a8u'R\fG/\u001a\u0005\b\u0003W9C\u0011AA\u0017\u0003\u001dI7/R7qif,\u0012A\u001e\u0005\b\u0003c9C\u0011AA\u001a\u0003Uqw\u000e^-fiJ+'n\\5oK\u0012lU-\u001c2feN,\"!!\u000e\u0011\u000b\u0005]\u0012qI#\u000f\t\u0005e\u00121\t\b\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA#\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA%\u0003\u0017\u0012A\u0001T5ti*\u0019\u0011Q\t\b\t\u000f\u0005=s\u0005\"\u0001\u0002R\u0005Q\u0011\r\u001c7NK6\u0014WM]:\u0016\u0005\u0005M\u0003#BA+\u0003/bS\"A!\n\u0005\u0011\n\u0005bBA.O\u0011\u0005\u00111G\u0001\u0012C2dW*Z7cKJlU\r^1eCR\f\u0007BBA0O\u0011\u0005\u0011,\u0001\tsK\n\fG.\u00198dKRKW.Z8vi\"9\u00111M\u0014\u0005\u0002\u0005\u0015\u0014AF4f]\u0016\u0014\u0018\r^3NK6\u0014WM]%e'V4g-\u001b=\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005Y\u0006twM\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\rq\u00131\u000e\u0005\b\u0003o:C\u0011AA\u0017\u00031\u0019\u0017M\u001c*fE\u0006d\u0017M\\2f\u0011\u001d\tYh\nC\u0001\u0003{\nA\u0002\u001e:b]NLG/[8o)>$2\u0001UA@\u0011\u0019Q\u0018\u0011\u0010a\u0001?!1\u00111Q\u0014\u0005\u0002-\nab]3mK\u000e$\bK]8u_\u000e|G\u000eC\u0004\u0002\b\u001e\"I!!#\u0002%\r\fg\u000eZ5eCR,\u0007K]8u_\u000e|Gn]\u000b\u0003\u0003\u0017\u0003R!!$\u0002\u00142j!!a$\u000b\u0007\u0005E\u0015)A\u0005j[6,H/\u00192mK&\u0019A%a$\t\u000f\u0005]u\u0005\"\u0001\u0002\u001a\u0006\t2/\u001e9q_J$8\u000f\u0015:pi>\u001cw\u000e\\:\u0015\u0007Y\fY\n\u0003\u0005\u0002\u001e\u0006U\u0005\u0019AAP\u0003=iW-\u001c2feB\u0013x\u000e^8d_2\u001c\bcA\r$Y!9\u00111U\u0014\u0005\u0002\u0005\u0015\u0016AE5oSRtU\r\u001f;HK:,'/\u0019;j_:$\u0012\u0001\u0015\u0005\b\u0003S;C\u0011AAV\u0003U\u0019WO\u001d:f]RlU-\u001c2fe6+G/\u00193bi\u0006,\"!!,\u0011\u000beaB&a,\u0011\u000b5\t\t,!.\n\u0007\u0005MfBA\u0003BeJ\f\u0017\u0010E\u0002\u000e\u0003oK1!!/\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005uv\u0005\"\u0001\u0002@\u000691/^7nCJLXCAAa!\rA\u00111Y\u0005\u0004\u0003\u000b\u0014!\u0001D$s_V\u00048+^7nCJL\bbBAeO\u0011\u0005\u00111Z\u0001\t_Z,'O^5foV\u0011\u0011Q\u001a\t\u0004\u0011\u0005=\u0017bAAi\u0005\tiqI]8va>3XM\u001d<jK^Dq!!6(\t\u0013\t9.A\u000bbgN,'\u000f\u001e,bY&$GK]1og&$\u0018n\u001c8\u0015\u0007A\u000bI\u000eC\u0004\u0002\\\u0006M\u0007\u0019A\u0010\u0002\u0017Q\f'oZ3u'R\fG/\u001a\u0005\b\u0003?<C\u0011IAq\u0003!!xn\u0015;sS:<G#\u0001\u0017)\u0007\u001d\n)\u000f\u0005\u0003\u0002h\u00065XBAAu\u0015\r\tY\u000fB\u0001\u0006kRLGn]\u0005\u0005\u0003_\fIOA\u0007o_:$\bN]3bIN\fg-\u001a")
public class GroupMetadata {
    private final String groupId;
    private final String protocolType;
    private final HashMap<String, MemberMetadata> members;
    private GroupState state;
    private int generationId;
    private String leaderId;
    private String protocol;

    public String groupId() {
        return this.groupId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    private HashMap<String, MemberMetadata> members() {
        return this.members;
    }

    private GroupState state() {
        return this.state;
    }

    private void state_$eq(GroupState x$1) {
        this.state = x$1;
    }

    public int generationId() {
        return this.generationId;
    }

    public void generationId_$eq(int x$1) {
        this.generationId = x$1;
    }

    public String leaderId() {
        return this.leaderId;
    }

    public void leaderId_$eq(String x$1) {
        this.leaderId = x$1;
    }

    public String protocol() {
        return this.protocol;
    }

    public void protocol_$eq(String x$1) {
        this.protocol = x$1;
    }

    public boolean is(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return !(groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null);
    }

    public boolean not(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null;
    }

    public boolean has(String memberId) {
        return this.members().contains(memberId);
    }

    public MemberMetadata get(String memberId) {
        return this.members().apply(memberId);
    }

    public void add(String memberId, MemberMetadata member) {
        Predef$.MODULE$.assert(this.supportsProtocols(member.protocols()));
        if (this.leaderId() == null) {
            this.leaderId_$eq(memberId);
        }
        this.members().put(memberId, member);
    }

    public void remove(String memberId) {
        this.members().remove(memberId);
        String string2 = memberId;
        String string3 = this.leaderId();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.leaderId_$eq(this.members().isEmpty() ? null : (String)this.members().keys().head());
        }
    }

    public GroupState currentState() {
        return this.state();
    }

    public boolean isEmpty() {
        return this.members().isEmpty();
    }

    public List<MemberMetadata> notYetRejoinedMembers() {
        return ((TraversableOnce)this.members().values().filter(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MemberMetadata x$1) {
                return x$1.awaitingJoinCallback() == null;
            }
        })).toList();
    }

    public Set<String> allMembers() {
        return this.members().keySet();
    }

    public List<MemberMetadata> allMemberMetadata() {
        return this.members().values().toList();
    }

    public int rebalanceTimeout() {
        return BoxesRunTime.unboxToInt(this.members().values().foldLeft(BoxesRunTime.boxToInteger(0), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int timeout, MemberMetadata member) {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(timeout), member.sessionTimeoutMs());
            }
        }));
    }

    public String generateMemberIdSuffix() {
        return UUID.randomUUID().toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canRebalance() {
        GroupState groupState = this.state();
        Stable$ stable$ = Stable$.MODULE$;
        if (groupState == null) {
            if (stable$ == null) return true;
        } else if (groupState.equals(stable$)) return true;
        GroupState groupState2 = this.state();
        AwaitingSync$ awaitingSync$ = AwaitingSync$.MODULE$;
        if (groupState2 != null) {
            if (!groupState2.equals(awaitingSync$)) return false;
            return true;
        }
        if (awaitingSync$ == null) return true;
        return false;
    }

    public void transitionTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.state_$eq(groupState);
    }

    public String selectProtocol() {
        if (this.members().isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        scala.collection.immutable.Set<String> candidates = this.candidateProtocols();
        List<Tuple2<String, Object>> votes = ((TraversableLike)this.allMemberMetadata().map(new Serializable(this, candidates){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set candidates$1;

            public final String apply(MemberMetadata x$2) {
                return x$2.vote(this.candidates$1);
            }
            {
                this.candidates$1 = candidates$1;
            }
        }, List$.MODULE$.canBuildFrom())).groupBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return Predef$.MODULE$.identity(x);
            }
        }).mapValues(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(List<String> x$3) {
                return x$3.size();
            }
        }).toList();
        return votes.maxBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<String, Object> x$4) {
                return x$4._2$mcI$sp();
            }
        }, Ordering$Int$.MODULE$)._1();
    }

    private scala.collection.immutable.Set<String> candidateProtocols() {
        return ((LinearSeqOptimized)this.allMemberMetadata().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<String> apply(MemberMetadata x$5) {
                return x$5.protocols();
            }
        }, List$.MODULE$.canBuildFrom())).reduceLeft(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<String> apply(scala.collection.immutable.Set<String> commonProtocols, scala.collection.immutable.Set<String> protocols2) {
                return (scala.collection.immutable.Set)commonProtocols.$amp(protocols2);
            }
        });
    }

    public boolean supportsProtocols(scala.collection.immutable.Set<String> memberProtocols) {
        return this.isEmpty() || ((TraversableOnce)memberProtocols.$amp(this.candidateProtocols())).nonEmpty();
    }

    public void initNextGeneration() {
        List<MemberMetadata> list2 = this.notYetRejoinedMembers();
        GenTraversable genTraversable = List$.MODULE$.empty();
        Predef$.MODULE$.assert(!(list2 != null ? !((Object)list2).equals(genTraversable) : genTraversable != null));
        this.generationId_$eq(this.generationId() + 1);
        this.protocol_$eq(this.selectProtocol());
        this.transitionTo(AwaitingSync$.MODULE$);
    }

    public Map<String, byte[]> currentMemberMetadata() {
        if (this.is(Dead$.MODULE$) || this.is(PreparingRebalance$.MODULE$)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Cannot obtain member metadata for group in state %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.state()})));
        }
        return ((TraversableOnce)this.members().map((Function1<String, MemberMetadata>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadata $outer;

            public final Tuple2<String, byte[]> apply(Tuple2<String, MemberMetadata> x0$1) {
                Tuple2<String, MemberMetadata> tuple2 = x0$1;
                if (tuple2 != null) {
                    String memberId = tuple2._1();
                    MemberMetadata memberMetadata = tuple2._2();
                    Tuple2<String, byte[]> tuple22 = new Tuple2<String, byte[]>(memberId, memberMetadata.metadata(this.$outer.protocol()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public GroupSummary summary() {
        GroupSummary groupSummary;
        if (this.is(Stable$.MODULE$)) {
            List<MemberSummary> members = ((TraversableOnce)this.members().values().map(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GroupMetadata $outer;

                public final MemberSummary apply(MemberMetadata member) {
                    return member.summary(this.$outer.protocol());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), this.protocolType(), this.protocol(), members);
        } else {
            List<MemberSummary> members = ((TraversableOnce)this.members().values().map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final MemberSummary apply(MemberMetadata member) {
                    return member.summaryNoMetadata();
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), this.protocolType(), GroupCoordinator$.MODULE$.NoProtocol(), members);
        }
        return groupSummary;
    }

    public GroupOverview overview() {
        return new GroupOverview(this.groupId(), this.protocolType());
    }

    private void assertValidTransition(GroupState targetState) {
        if (((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$GroupMetadata$$validPreviousStates().apply(targetState)).contains(this.state())) {
            return;
        }
        throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Group %s should be in the %s states before moving to %s state. Instead it is in %s state")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.groupId(), ((TraversableOnce)GroupMetadata$.MODULE$.kafka$coordinator$GroupMetadata$$validPreviousStates().apply(targetState)).mkString(","), targetState, this.state()})));
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("[%s,%s,%s,%s]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.groupId(), this.protocolType(), this.currentState().toString(), this.members()}));
    }

    public GroupMetadata(String groupId, String protocolType) {
        this.groupId = groupId;
        this.protocolType = protocolType;
        this.members = new HashMap();
        this.state = Stable$.MODULE$;
        this.generationId = 0;
        this.leaderId = null;
        this.protocol = null;
    }
}

