/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.cluster;

import java.nio.ByteBuffer;
import kafka.shaded.api.ApiUtils$;
import kafka.shaded.cluster.BrokerEndPoint;
import kafka.shaded.common.KafkaException;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class BrokerEndPoint$
implements Serializable {
    public static final BrokerEndPoint$ MODULE$;
    private final Regex uriParseExp;

    static {
        new BrokerEndPoint$();
    }

    private Regex uriParseExp() {
        return this.uriParseExp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple2<String, Object>> parseHostPort(String connectionString) {
        Option option;
        String string2 = connectionString;
        Option<List<String>> option3 = this.uriParseExp().unapplySeq(string2);
        if (option3.isEmpty()) return None$.MODULE$;
        if (option3.get() == null) return None$.MODULE$;
        if (((LinearSeqOptimized)option3.get()).lengthCompare(2) != 0) return None$.MODULE$;
        String host = (String)((LinearSeqOptimized)option3.get()).apply(0);
        String port = (String)((LinearSeqOptimized)option3.get()).apply(1);
        try {
            option = new Some<Tuple2<String, Integer>>(new Tuple2<String, Integer>(host, BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            return option;
        }
        catch (NumberFormatException numberFormatException) {
            option = None$.MODULE$;
        }
        return option;
    }

    public BrokerEndPoint createBrokerEndPoint(int brokerId, String connectionString) {
        return (BrokerEndPoint)((Object)this.parseHostPort(connectionString).map(new Serializable(brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final BrokerEndPoint apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String host = tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    BrokerEndPoint brokerEndPoint = new BrokerEndPoint(this.brokerId$1, host, port);
                    return brokerEndPoint;
                }
                throw new MatchError(tuple2);
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        }).getOrElse(new Serializable(connectionString){
            public static final long serialVersionUID = 0L;
            private final String connectionString$1;

            public final Nothing$ apply() {
                throw new KafkaException(new StringBuilder().append((Object)"Unable to parse ").append((Object)this.connectionString$1).append((Object)" to a broker endpoint").toString());
            }
            {
                this.connectionString$1 = connectionString$1;
            }
        }));
    }

    public BrokerEndPoint readFrom(ByteBuffer buffer) {
        int brokerId = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new BrokerEndPoint(brokerId, host, port);
    }

    public BrokerEndPoint apply(int id, String host, int port) {
        return new BrokerEndPoint(id, host, port);
    }

    public Option<Tuple3<Object, String, Object>> unapply(BrokerEndPoint x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Integer, String, Integer>>(new Tuple3<Integer, String, Integer>(BoxesRunTime.boxToInteger(x$0.id()), x$0.host(), BoxesRunTime.boxToInteger(x$0.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BrokerEndPoint$() {
        MODULE$ = this;
        this.uriParseExp = new StringOps(Predef$.MODULE$.augmentString("\\[?([0-9a-zA-Z\\-%.:]*)\\]?:([0-9]+)")).r();
    }
}

